/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.EpochNanoClock;

public class OffsetEpochNanoClock
implements EpochNanoClock {
    private static final int DEFAULT_MAX_MEASUREMENT_RETRIES = 100;
    private static final long DEFAULT_MEASUREMENT_THRESHOLD_NS = 250L;
    private static final long DEFAULT_RESAMPLE_INTERVAL_NS = TimeUnit.HOURS.toNanos(1L);
    private final int maxMeasurementRetries;
    private final long measurementThresholdNs;
    private final long resampleIntervalNs;
    private volatile TimeFields timeFields;

    public OffsetEpochNanoClock() {
        this(100, 250L, DEFAULT_RESAMPLE_INTERVAL_NS);
    }

    public OffsetEpochNanoClock(int n2, long l2, long l3) {
        this.maxMeasurementRetries = n2;
        this.measurementThresholdNs = l2;
        this.resampleIntervalNs = l3;
        this.sample();
    }

    public void sample() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = Long.MAX_VALUE;
        int n2 = this.maxMeasurementRetries;
        long l5 = this.measurementThresholdNs;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l6 = System.nanoTime();
            long l7 = System.currentTimeMillis();
            long l8 = System.nanoTime();
            long l9 = l8 - l6;
            if (l9 < l5) {
                this.timeFields = new TimeFields(TimeUnit.MILLISECONDS.toNanos(l7), l6 + l8 >> 1, true);
                return;
            }
            if (l9 >= l4) continue;
            l2 = TimeUnit.MILLISECONDS.toNanos(l7);
            l3 = l6 + l8 >> 1;
            l4 = l9;
        }
        this.timeFields = new TimeFields(l2, l3, false);
    }

    @Override
    public long nanoTime() {
        TimeFields timeFields = this.timeFields;
        long l2 = System.nanoTime() - timeFields.initialNanoTime;
        if (l2 < 0L || l2 > this.resampleIntervalNs) {
            this.sample();
            return this.nanoTime();
        }
        return timeFields.initialCurrentNanoTime + l2;
    }

    public boolean isWithinThreshold() {
        return this.timeFields.isWithinThreshold;
    }

    static final class TimeFields {
        final long initialCurrentNanoTime;
        final long initialNanoTime;
        final boolean isWithinThreshold;

        private TimeFields(long l2, long l3, boolean bl2) {
            this.initialNanoTime = l3;
            this.initialCurrentNanoTime = l2;
            this.isWithinThreshold = bl2;
        }
    }
}

