/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.UnsafeBuffer;

public class MappedResizeableBuffer
implements AutoCloseable {
    private long addressOffset;
    private long capacity;
    private FileChannel fileChannel;
    private FileChannel.MapMode mapMode;

    public MappedResizeableBuffer(FileChannel fileChannel, long l2, long l3) {
        this.fileChannel = fileChannel;
        this.mapMode = FileChannel.MapMode.READ_WRITE;
        this.map(l2, l3);
    }

    public MappedResizeableBuffer(FileChannel fileChannel, FileChannel.MapMode mapMode, long l2, long l3) {
        this.fileChannel = fileChannel;
        this.mapMode = mapMode;
        this.map(l2, l3);
    }

    @Override
    public void close() {
        this.unmap();
    }

    public void resize(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Length must be a positive long, but is: " + l2);
        }
        this.unmap();
        this.map(0L, l2);
    }

    public void wrap(long l2, long l3) {
        if (l2 == this.addressOffset && l3 == this.capacity) {
            return;
        }
        this.wrap(this.fileChannel, l2, l3);
    }

    public void wrap(FileChannel fileChannel, long l2, long l3) {
        this.unmap();
        this.fileChannel = fileChannel;
        this.map(l2, l3);
    }

    public void wrap(FileChannel fileChannel, FileChannel.MapMode mapMode, long l2, long l3) {
        this.unmap();
        this.fileChannel = fileChannel;
        this.mapMode = mapMode;
        this.map(l2, l3);
    }

    public long addressOffset() {
        return this.addressOffset;
    }

    public FileChannel fileChannel() {
        return this.fileChannel;
    }

    public FileChannel.MapMode mapMode() {
        return this.mapMode;
    }

    public void setMemory(long l2, int n2, byte by2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, n2);
        }
        long l3 = this.addressOffset + l2;
        if (UnsafeAccess.MEMSET_HACK_REQUIRED && n2 > UnsafeAccess.MEMSET_HACK_THRESHOLD && 0L == (l3 & 1L)) {
            UnsafeAccess.UNSAFE.putByte(null, l3, by2);
            UnsafeAccess.UNSAFE.setMemory(null, l3 + 1L, n2 - 1, by2);
        } else {
            UnsafeAccess.UNSAFE.setMemory(null, l3, n2, by2);
        }
    }

    public long capacity() {
        return this.capacity;
    }

    public void checkLimit(long l2) {
        if (l2 > this.capacity) {
            throw new IndexOutOfBoundsException("limit=" + l2 + " is beyond capacity=" + this.capacity);
        }
    }

    public void verifyAlignment() {
        if (0L != (this.addressOffset & 7L)) {
            throw new IllegalStateException("AtomicBuffer is not correctly aligned: addressOffset=" + this.addressOffset + " is not divisible by " + 8);
        }
    }

    public long getLong(long l2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        long l3 = UnsafeAccess.UNSAFE.getLong(null, this.addressOffset + l2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            l3 = Long.reverseBytes(l3);
        }
        return l3;
    }

    public void putLong(long l2, long l3, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        long l4 = l3;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            l4 = Long.reverseBytes(l4);
        }
        UnsafeAccess.UNSAFE.putLong(null, this.addressOffset + l2, l4);
    }

    public long getLong(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        return UnsafeAccess.UNSAFE.getLong(null, this.addressOffset + l2);
    }

    public void putLong(long l2, long l3) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        UnsafeAccess.UNSAFE.putLong(null, this.addressOffset + l2, l3);
    }

    public long getLongVolatile(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        return UnsafeAccess.UNSAFE.getLongVolatile(null, this.addressOffset + l2);
    }

    public void putLongVolatile(long l2, long l3) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        UnsafeAccess.UNSAFE.putLongVolatile(null, this.addressOffset + l2, l3);
    }

    public void putLongOrdered(long l2, long l3) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        UnsafeAccess.UNSAFE.putOrderedLong(null, this.addressOffset + l2, l3);
    }

    public long addLongOrdered(long l2, long l3) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        long l4 = this.addressOffset + l2;
        long l5 = UnsafeAccess.UNSAFE.getLong(null, l4);
        UnsafeAccess.UNSAFE.putOrderedLong(null, l4, l5 + l3);
        return l5;
    }

    public boolean compareAndSetLong(long l2, long l3, long l4) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapLong(null, this.addressOffset + l2, l3, l4);
    }

    public long getAndSetLong(long l2, long l3) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        return UnsafeAccess.UNSAFE.getAndSetLong(null, this.addressOffset + l2, l3);
    }

    public long getAndAddLong(long l2, long l3) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        return UnsafeAccess.UNSAFE.getAndAddLong(null, this.addressOffset + l2, l3);
    }

    public int getInt(long l2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        int n2 = UnsafeAccess.UNSAFE.getInt(null, this.addressOffset + l2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n2 = Integer.reverseBytes(n2);
        }
        return n2;
    }

    public void putInt(long l2, int n2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        int n3 = n2;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            n3 = Integer.reverseBytes(n3);
        }
        UnsafeAccess.UNSAFE.putInt(null, this.addressOffset + l2, n3);
    }

    public int getInt(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        return UnsafeAccess.UNSAFE.getInt(null, this.addressOffset + l2);
    }

    public void putInt(long l2, int n2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        UnsafeAccess.UNSAFE.putInt(null, this.addressOffset + l2, n2);
    }

    public int getIntVolatile(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        return UnsafeAccess.UNSAFE.getIntVolatile(null, this.addressOffset + l2);
    }

    public void putIntVolatile(long l2, int n2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        UnsafeAccess.UNSAFE.putIntVolatile(null, this.addressOffset + l2, n2);
    }

    public void putIntOrdered(long l2, int n2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        UnsafeAccess.UNSAFE.putOrderedInt(null, this.addressOffset + l2, n2);
    }

    public int addIntOrdered(long l2, int n2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        long l3 = this.addressOffset + l2;
        int n3 = UnsafeAccess.UNSAFE.getInt(null, l3);
        UnsafeAccess.UNSAFE.putOrderedInt(null, l3, n3 + n2);
        return n3;
    }

    public boolean compareAndSetInt(long l2, int n2, int n3) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        return UnsafeAccess.UNSAFE.compareAndSwapInt(null, this.addressOffset + l2, n2, n3);
    }

    public int getAndSetInt(long l2, int n2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        return UnsafeAccess.UNSAFE.getAndSetInt(null, this.addressOffset + l2, n2);
    }

    public int getAndAddInt(long l2, int n2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        return UnsafeAccess.UNSAFE.getAndAddInt(null, this.addressOffset + l2, n2);
    }

    public double getDouble(long l2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long l3 = UnsafeAccess.UNSAFE.getLong(null, this.addressOffset + l2);
            return Double.longBitsToDouble(Long.reverseBytes(l3));
        }
        return UnsafeAccess.UNSAFE.getDouble(null, this.addressOffset + l2);
    }

    public void putDouble(long l2, double d2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            long l3 = Long.reverseBytes(Double.doubleToRawLongBits(d2));
            UnsafeAccess.UNSAFE.putLong(null, this.addressOffset + l2, l3);
        } else {
            UnsafeAccess.UNSAFE.putDouble(null, this.addressOffset + l2, d2);
        }
    }

    public double getDouble(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        return UnsafeAccess.UNSAFE.getDouble(null, this.addressOffset + l2);
    }

    public void putDouble(long l2, double d2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 8);
        }
        UnsafeAccess.UNSAFE.putDouble(null, this.addressOffset + l2, d2);
    }

    public float getFloat(long l2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int n2 = UnsafeAccess.UNSAFE.getInt(null, this.addressOffset + l2);
            return Float.intBitsToFloat(Integer.reverseBytes(n2));
        }
        return UnsafeAccess.UNSAFE.getFloat(null, this.addressOffset + l2);
    }

    public void putFloat(long l2, float f2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            int n2 = Integer.reverseBytes(Float.floatToRawIntBits(f2));
            UnsafeAccess.UNSAFE.putInt(null, this.addressOffset + l2, n2);
        } else {
            UnsafeAccess.UNSAFE.putFloat(null, this.addressOffset + l2, f2);
        }
    }

    public float getFloat(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        return UnsafeAccess.UNSAFE.getFloat(null, this.addressOffset + l2);
    }

    public void putFloat(long l2, float f2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 4);
        }
        UnsafeAccess.UNSAFE.putFloat(null, this.addressOffset + l2, f2);
    }

    public short getShort(long l2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        short s2 = UnsafeAccess.UNSAFE.getShort(null, this.addressOffset + l2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            s2 = Short.reverseBytes(s2);
        }
        return s2;
    }

    public void putShort(long l2, short s2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        short s3 = s2;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            s3 = Short.reverseBytes(s3);
        }
        UnsafeAccess.UNSAFE.putShort(null, this.addressOffset + l2, s3);
    }

    public short getShort(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        return UnsafeAccess.UNSAFE.getShort(null, this.addressOffset + l2);
    }

    public void putShort(long l2, short s2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        UnsafeAccess.UNSAFE.putShort(null, this.addressOffset + l2, s2);
    }

    public short getShortVolatile(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        return UnsafeAccess.UNSAFE.getShortVolatile(null, this.addressOffset + l2);
    }

    public void putShortVolatile(long l2, short s2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        UnsafeAccess.UNSAFE.putShortVolatile(null, this.addressOffset + l2, s2);
    }

    public byte getByte(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(l2);
        }
        return UnsafeAccess.UNSAFE.getByte(null, this.addressOffset + l2);
    }

    public void putByte(long l2, byte by2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(l2);
        }
        UnsafeAccess.UNSAFE.putByte(null, this.addressOffset + l2, by2);
    }

    public byte getByteVolatile(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(l2);
        }
        return UnsafeAccess.UNSAFE.getByteVolatile(null, this.addressOffset + l2);
    }

    public void putByteVolatile(long l2, byte by2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck(l2);
        }
        UnsafeAccess.UNSAFE.putByteVolatile(null, this.addressOffset + l2, by2);
    }

    public void getBytes(long l2, byte[] byArray) {
        this.getBytes(l2, byArray, 0L, byArray.length);
    }

    public void getBytes(long l2, byte[] byArray, long l3, int n2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, n2);
            BufferUtil.boundsCheck(byArray, l3, n2);
        }
        UnsafeAccess.UNSAFE.copyMemory(null, this.addressOffset + l2, byArray, BufferUtil.ARRAY_BASE_OFFSET + l3, n2);
    }

    public void getBytes(long l2, ByteBuffer byteBuffer, int n2) {
        long l3;
        byte[] byArray;
        int n3 = byteBuffer.position();
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, n2);
            BufferUtil.boundsCheck(byteBuffer, (long)n3, n2);
        }
        if (byteBuffer.isDirect()) {
            byArray = null;
            l3 = BufferUtil.address(byteBuffer);
        } else {
            byArray = BufferUtil.array(byteBuffer);
            l3 = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(byteBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(null, this.addressOffset + l2, byArray, l3 + (long)n3, n2);
        byteBuffer.position(byteBuffer.position() + n2);
    }

    public void putBytes(long l2, byte[] byArray) {
        this.putBytes(l2, byArray, 0L, byArray.length);
    }

    public void putBytes(long l2, byte[] byArray, long l3, int n2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, n2);
            BufferUtil.boundsCheck(byArray, l3, n2);
        }
        UnsafeAccess.UNSAFE.copyMemory(byArray, BufferUtil.ARRAY_BASE_OFFSET + l3, null, this.addressOffset + l2, n2);
    }

    public void putBytes(long l2, ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.position();
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, n2);
            BufferUtil.boundsCheck(byteBuffer, (long)n3, n2);
        }
        this.putBytes(l2, byteBuffer, (long)n3, n2);
        byteBuffer.position(n3 + n2);
    }

    public void putBytes(long l2, ByteBuffer byteBuffer, long l3, int n2) {
        long l4;
        byte[] byArray;
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, n2);
            BufferUtil.boundsCheck(byteBuffer, l3, n2);
        }
        if (byteBuffer.isDirect()) {
            byArray = null;
            l4 = BufferUtil.address(byteBuffer);
        } else {
            byArray = BufferUtil.array(byteBuffer);
            l4 = BufferUtil.ARRAY_BASE_OFFSET + (long)BufferUtil.arrayOffset(byteBuffer);
        }
        UnsafeAccess.UNSAFE.copyMemory(byArray, l4 + l3, null, this.addressOffset + l2, n2);
    }

    public void putBytes(long l2, DirectBuffer directBuffer, int n2, int n3) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, n3);
            directBuffer.boundsCheck(n2, n3);
        }
        UnsafeAccess.UNSAFE.copyMemory(directBuffer.byteArray(), directBuffer.addressOffset() + (long)n2, null, this.addressOffset + l2, n3);
    }

    public char getChar(long l2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        char c2 = UnsafeAccess.UNSAFE.getChar(null, this.addressOffset + l2);
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            c2 = (char)Short.reverseBytes((short)c2);
        }
        return c2;
    }

    public void putChar(long l2, char c2, ByteOrder byteOrder) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        char c3 = c2;
        if (BufferUtil.NATIVE_BYTE_ORDER != byteOrder) {
            c3 = (char)Short.reverseBytes((short)c3);
        }
        UnsafeAccess.UNSAFE.putChar(null, this.addressOffset + l2, c3);
    }

    public char getChar(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        return UnsafeAccess.UNSAFE.getChar(null, this.addressOffset + l2);
    }

    public void putChar(long l2, char c2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        UnsafeAccess.UNSAFE.putChar(null, this.addressOffset + l2, c2);
    }

    public char getCharVolatile(long l2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        return UnsafeAccess.UNSAFE.getCharVolatile(null, this.addressOffset + l2);
    }

    public void putCharVolatile(long l2, char c2) {
        if (UnsafeBuffer.SHOULD_BOUNDS_CHECK) {
            this.boundsCheck0(l2, 2);
        }
        UnsafeAccess.UNSAFE.putCharVolatile(null, this.addressOffset + l2, c2);
    }

    public String getStringUtf8(long l2) {
        int n2 = this.getInt(l2);
        return this.getStringUtf8(l2, n2);
    }

    public String getStringUtf8(long l2, ByteOrder byteOrder) {
        int n2 = this.getInt(l2, byteOrder);
        return this.getStringUtf8(l2, n2);
    }

    public String getStringUtf8(long l2, int n2) {
        byte[] byArray = new byte[n2];
        this.getBytes(l2 + 4L, byArray);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public int putStringUtf8(long l2, String string) {
        return this.putStringUtf8(l2, string, Integer.MAX_VALUE);
    }

    public int putStringUtf8(long l2, String string, ByteOrder byteOrder) {
        return this.putStringUtf8(l2, string, byteOrder, Integer.MAX_VALUE);
    }

    public int putStringUtf8(long l2, String string, int n2) {
        byte[] byArray;
        byte[] byArray2 = byArray = string != null ? string.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (byArray.length > n2) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + n2);
        }
        this.putInt(l2, byArray.length);
        this.putBytes(l2 + 4L, byArray);
        return 4 + byArray.length;
    }

    public int putStringUtf8(long l2, String string, ByteOrder byteOrder, int n2) {
        byte[] byArray;
        byte[] byArray2 = byArray = string != null ? string.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        if (byArray.length > n2) {
            throw new IllegalArgumentException("Encoded string larger than maximum size: " + n2);
        }
        this.putInt(l2, byArray.length, byteOrder);
        this.putBytes(l2 + 4L, byArray);
        return 4 + byArray.length;
    }

    public String getStringWithoutLengthUtf8(long l2, int n2) {
        byte[] byArray = new byte[n2];
        this.getBytes(l2, byArray);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public int putStringWithoutLengthUtf8(long l2, String string) {
        byte[] byArray = string != null ? string.getBytes(StandardCharsets.UTF_8) : BufferUtil.NULL_BYTES;
        this.putBytes(l2, byArray);
        return byArray.length;
    }

    public void boundsCheck(long l2, int n2) {
        this.boundsCheck0(l2, n2);
    }

    private void boundsCheck(long l2) {
        if (l2 < 0L || l2 >= this.capacity) {
            throw new IndexOutOfBoundsException("index=" + l2 + " capacity=" + this.capacity);
        }
    }

    private void boundsCheck0(long l2, int n2) {
        long l3 = l2 + (long)n2;
        if (l2 < 0L || l3 > this.capacity || l3 < l2) {
            throw new IndexOutOfBoundsException("index=" + l2 + " length=" + n2 + " capacity=" + this.capacity);
        }
    }

    private void map(long l2, long l3) {
        this.capacity = l3;
        this.addressOffset = IoUtil.map(this.fileChannel, this.mapMode, l2, l3);
    }

    private void unmap() {
        IoUtil.unmap(this.fileChannel, this.addressOffset, this.capacity);
    }

    public String toString() {
        return "MappedResizeableBuffer{addressOffset=" + this.addressOffset + ", capacity=" + this.capacity + ", fileChannel=" + this.fileChannel + ", mapMode=" + this.mapMode + '}';
    }
}

