/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Collection;
import java.util.function.Consumer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AbstractConcurrentArrayQueue;
import org.agrona.hints.ThreadHints;

public class ManyToManyConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueue<E> {
    private static final int SEQUENCES_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class);
    private final long[] sequences;

    public ManyToManyConcurrentArrayQueue(int n2) {
        super(n2);
        if (n2 < 2) {
            throw new IllegalArgumentException("requestedCapacity must be >= 2: requestedCapacity=" + n2);
        }
        long[] lArray = new long[this.capacity];
        for (int i2 = 0; i2 < this.capacity; ++i2) {
            lArray[i2] = i2;
        }
        UnsafeAccess.UNSAFE.putLongVolatile(lArray, ManyToManyConcurrentArrayQueue.sequenceArrayOffset(0L, lArray.length - 1), 0L);
        this.sequences = lArray;
    }

    @Override
    public boolean offer(E e2) {
        if (null == e2) {
            throw new NullPointerException("element cannot be null");
        }
        long l2 = this.capacity - 1;
        long[] lArray = this.sequences;
        Object[] objectArray = this.buffer;
        long l3;
        long l4;
        long l5;
        while ((l5 = UnsafeAccess.UNSAFE.getLongVolatile(lArray, l4 = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(l3 = this.tail, l2))) >= l3) {
            if (UnsafeAccess.UNSAFE.compareAndSwapLong(this, TAIL_OFFSET, l3, l3 + 1L)) {
                UnsafeAccess.UNSAFE.putObject(objectArray, ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(l3, l2), e2);
                UnsafeAccess.UNSAFE.putOrderedLong(lArray, l4, l3 + 1L);
                return true;
            }
            ThreadHints.onSpinWait();
        }
        return false;
    }

    @Override
    public E poll() {
        long[] lArray = this.sequences;
        Object[] objectArray = this.buffer;
        long l2 = this.capacity - 1;
        long l3;
        long l4;
        long l5;
        long l6;
        while ((l6 = UnsafeAccess.UNSAFE.getLongVolatile(lArray, l5 = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(l4 = this.head, l2))) >= (l3 = l4 + 1L)) {
            if (UnsafeAccess.UNSAFE.compareAndSwapLong(this, HEAD_OFFSET, l4, l3)) {
                long l7 = ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(l4, l2);
                Object object = UnsafeAccess.UNSAFE.getObject(objectArray, l7);
                UnsafeAccess.UNSAFE.putObject(objectArray, l7, null);
                UnsafeAccess.UNSAFE.putOrderedLong(lArray, l5, l3 + l2);
                return (E)object;
            }
            ThreadHints.onSpinWait();
        }
        return null;
    }

    @Override
    public E peek() {
        long[] lArray = this.sequences;
        Object[] objectArray = this.buffer;
        long l2 = this.capacity - 1;
        long l3;
        long l4;
        long l5;
        long l6;
        while ((l6 = UnsafeAccess.UNSAFE.getLongVolatile(lArray, l5 = ManyToManyConcurrentArrayQueue.sequenceArrayOffset(l4 = this.head, l2))) >= (l3 = l4 + 1L)) {
            if (l6 == l3) {
                long l7 = ManyToManyConcurrentArrayQueue.sequenceToBufferOffset(l4, l2);
                Object object = UnsafeAccess.UNSAFE.getObject(objectArray, l7);
                if (l4 == this.head) {
                    return (E)object;
                }
            }
            ThreadHints.onSpinWait();
        }
        return null;
    }

    @Override
    public int drain(Consumer<E> consumer) {
        return this.drain(consumer, this.size());
    }

    @Override
    public int drain(Consumer<E> consumer, int n2) {
        E e2;
        int n3;
        for (n3 = 0; n3 < n2 && null != (e2 = this.poll()); ++n3) {
            consumer.accept(e2);
        }
        return n3;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        E e2;
        int n3;
        for (n3 = 0; n3 < n2 && null != (e2 = this.poll()); ++n3) {
            collection.add(e2);
        }
        return n3;
    }

    private static long sequenceArrayOffset(long l2, long l3) {
        return (long)SEQUENCES_ARRAY_BASE + ((l2 & l3) << 3);
    }
}

