/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.BitUtil;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AbstractConcurrentArrayQueueConsumer;
import org.agrona.concurrent.AbstractConcurrentArrayQueuePadding3;
import org.agrona.concurrent.AbstractConcurrentArrayQueueProducer;
import org.agrona.concurrent.QueuedPipe;

public abstract class AbstractConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueuePadding3
implements QueuedPipe<E> {
    protected static final long TAIL_OFFSET;
    protected static final long SHARED_HEAD_CACHE_OFFSET;
    protected static final long HEAD_OFFSET;
    protected static final int BUFFER_ARRAY_BASE;
    protected static final int SHIFT_FOR_SCALE;
    protected final int capacity;
    protected final E[] buffer;

    public AbstractConcurrentArrayQueue(int n2) {
        this.capacity = BitUtil.findNextPositivePowerOfTwo(n2);
        this.buffer = new Object[this.capacity];
    }

    @Override
    public long addedCount() {
        return this.tail;
    }

    @Override
    public long removedCount() {
        return this.head;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size();
    }

    @Override
    public E peek() {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(this.buffer, AbstractConcurrentArrayQueue.sequenceToBufferOffset(this.head, this.capacity - 1));
    }

    @Override
    public boolean add(E e2) {
        if (this.offer(e2)) {
            return true;
        }
        throw new IllegalStateException("Queue is full");
    }

    @Override
    public E remove() {
        Object e2 = this.poll();
        if (null == e2) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e2;
    }

    @Override
    public E element() {
        E e2 = this.peek();
        if (null == e2) {
            throw new NoSuchElementException("Queue is empty");
        }
        return e2;
    }

    @Override
    public boolean contains(Object object) {
        if (null == object) {
            return false;
        }
        E[] EArray = this.buffer;
        int n2 = this.capacity - 1;
        long l2 = this.tail;
        for (long i2 = this.head; i2 < l2; ++i2) {
            Object object2 = UnsafeAccess.UNSAFE.getObjectVolatile(EArray, AbstractConcurrentArrayQueue.sequenceToBufferOffset(i2, n2));
            if (!object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        for (E e2 : collection) {
            this.add(e2);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        Object e2;
        while (null != (e2 = this.poll())) {
        }
    }

    @Override
    public boolean isEmpty() {
        return this.head >= this.tail;
    }

    @Override
    public int size() {
        long l2;
        long l3;
        long l4 = this.head;
        do {
            l3 = l4;
            l2 = this.tail;
        } while ((l4 = this.head) != l3);
        long l5 = l2 - l4;
        if (l5 < 0L) {
            return 0;
        }
        if (l5 > (long)this.capacity) {
            return this.capacity;
        }
        return (int)l5;
    }

    public static long sequenceToBufferOffset(long l2, long l3) {
        return (long)BUFFER_ARRAY_BASE + ((l2 & l3) << SHIFT_FOR_SCALE);
    }

    static {
        try {
            BUFFER_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
            SHIFT_FOR_SCALE = BitUtil.calculateShiftForScale(UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class));
            TAIL_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(AbstractConcurrentArrayQueueProducer.class.getDeclaredField("tail"));
            SHARED_HEAD_CACHE_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(AbstractConcurrentArrayQueueProducer.class.getDeclaredField("sharedHeadCache"));
            HEAD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(AbstractConcurrentArrayQueueConsumer.class.getDeclaredField("head"));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

