/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.ObjLongConsumer;
import java.util.function.ToLongFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Object2LongCounterMap<K> {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long initialValue;
    private int resizeThreshold;
    private int size = 0;
    private K[] keys;
    private long[] values;

    public Object2LongCounterMap(long l2) {
        this(8, 0.65f, l2);
    }

    public Object2LongCounterMap(int n2, float f2, long l2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.initialValue = l2;
        int n3 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.keys = new Object[n3];
        this.values = new long[n3];
        Arrays.fill(this.values, l2);
        this.resizeThreshold = (int)((float)n3 * f2);
    }

    public long initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.values.length;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long get(K k2) {
        long l2;
        long l3 = this.initialValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        while (l3 != (l2 = lArray[n3]) && !Objects.equals(KArray[n3], k2)) {
            ++n3;
            n3 &= n2;
        }
        return l2;
    }

    public long put(K k2, long l2) {
        long l3 = this.initialValue;
        if (l3 == l2) {
            throw new IllegalArgumentException("cannot accept initialValue");
        }
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        long l4 = l3;
        while (lArray[n3] != l3) {
            if (Objects.equals(KArray[n3], k2)) {
                l4 = lArray[n3];
                break;
            }
            ++n3;
            n3 &= n2;
        }
        if (l4 == l3) {
            ++this.size;
            KArray[n3] = k2;
        }
        lArray[n3] = l2;
        this.increaseCapacity();
        return l4;
    }

    public long incrementAndGet(K k2) {
        return this.addAndGet(k2, 1L);
    }

    public long decrementAndGet(K k2) {
        return this.addAndGet(k2, -1L);
    }

    public long addAndGet(K k2, long l2) {
        return this.getAndAdd(k2, l2) + l2;
    }

    public long getAndIncrement(K k2) {
        return this.getAndAdd(k2, 1L);
    }

    public long getAndDecrement(K k2) {
        return this.getAndAdd(k2, -1L);
    }

    public long getAndAdd(K k2, long l2) {
        long l3 = this.initialValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        long l4 = l3;
        while (l3 != lArray[n3]) {
            if (Objects.equals(KArray[n3], k2)) {
                l4 = lArray[n3];
                break;
            }
            ++n3;
            n3 &= n2;
        }
        if (l2 != 0L) {
            long l5;
            lArray[n3] = l5 = l4 + l2;
            if (l3 == l4) {
                ++this.size;
                KArray[n3] = k2;
                this.increaseCapacity();
            } else if (l3 == l5) {
                --this.size;
                this.compactChain(n3);
            }
        }
        return l4;
    }

    public void forEach(ObjLongConsumer<K> objLongConsumer) {
        long l2 = this.initialValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length;
        int n3 = this.size;
        for (int i2 = 0; n3 > 0 && i2 < n2; ++i2) {
            if (l2 == lArray[i2]) continue;
            objLongConsumer.accept(KArray[i2], lArray[i2]);
            --n3;
        }
    }

    public boolean containsKey(K k2) {
        return this.initialValue != this.get(k2);
    }

    public boolean containsValue(long l2) {
        boolean bl2 = false;
        if (this.initialValue != l2) {
            for (long l3 : this.values) {
                if (l2 != l3) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, null);
            Arrays.fill(this.values, this.initialValue);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public long computeIfAbsent(K k2, ToLongFunction<? super K> toLongFunction) {
        long l2 = this.get(k2);
        if (this.initialValue == l2 && this.initialValue != (l2 = toLongFunction.applyAsLong(k2))) {
            this.put(k2, l2);
        }
        return l2;
    }

    public long remove(K k2) {
        long l2 = this.initialValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length - 1;
        int n3 = Hashing.hash(k2, n2);
        long l3 = l2;
        while (l2 != lArray[n3]) {
            if (Objects.equals(KArray[n3], k2)) {
                l3 = lArray[n3];
                lArray[n3] = l2;
                --this.size;
                this.compactChain(n3);
                break;
            }
            ++n3;
            n3 &= n2;
        }
        return l3;
    }

    public long minValue() {
        long l2 = this.initialValue;
        long l3 = 0 == this.size ? l2 : Long.MAX_VALUE;
        for (long l4 : this.values) {
            if (l2 == l4) continue;
            l3 = Math.min(l3, l4);
        }
        return l3;
    }

    public long maxValue() {
        long l2 = this.initialValue;
        long l3 = 0 == this.size ? l2 : Long.MIN_VALUE;
        for (long l4 : this.values) {
            if (l2 == l4) continue;
            l3 = Math.max(l3, l4);
        }
        return l3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        long l2 = this.initialValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = lArray[i2];
            if (l2 == l3) continue;
            stringBuilder.append(KArray[i2]).append('=').append(l3).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private void compactChain(int n2) {
        long l2 = this.initialValue;
        K[] KArray = this.keys;
        long[] lArray = this.values;
        int n3 = lArray.length - 1;
        int n4 = n2;
        while (true) {
            ++n4;
            long l3 = lArray[n4 &= n3];
            if (l2 == l3) break;
            K k2 = KArray[n4];
            int n5 = Hashing.hash(k2, n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            KArray[n2] = k2;
            lArray[n2] = l3;
            KArray[n4] = null;
            lArray[n4] = l2;
            n2 = n4;
        }
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int n2 = this.values.length * 2;
            this.rehash(n2);
        }
    }

    private void rehash(int n2) {
        int n3 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        Object[] objectArray = new Object[n2];
        long[] lArray = new long[n2];
        long l2 = this.initialValue;
        Arrays.fill(lArray, l2);
        K[] KArray = this.keys;
        long[] lArray2 = this.values;
        int n4 = lArray2.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            long l3 = lArray2[i2];
            if (l2 == l3) continue;
            K k2 = KArray[i2];
            int n5 = Hashing.hash(k2, n3);
            while (l2 != lArray[n5]) {
                ++n5;
                n5 &= n3;
            }
            objectArray[n5] = k2;
            lArray[n5] = l3;
        }
        this.keys = objectArray;
        this.values = lArray;
    }
}

