/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;
import org.agrona.collections.IntIntFunction;
import org.agrona.collections.IntIntPredicate;

public class Int2IntHashMap
implements Map<Integer, Integer> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int missingValue;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private int[] entries;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;

    public Int2IntHashMap(int n2) {
        this(8, 0.65f, n2);
    }

    public Int2IntHashMap(int n2, float f2, int n3) {
        this(n2, f2, n3, true);
    }

    public Int2IntHashMap(int n2, float f2, int n3, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.missingValue = n3;
        this.shouldAvoidAllocation = bl2;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public Int2IntHashMap(Int2IntHashMap int2IntHashMap) {
        this.loadFactor = int2IntHashMap.loadFactor;
        this.resizeThreshold = int2IntHashMap.resizeThreshold;
        this.size = int2IntHashMap.size;
        this.shouldAvoidAllocation = int2IntHashMap.shouldAvoidAllocation;
        this.missingValue = int2IntHashMap.missingValue;
        this.entries = (int[])int2IntHashMap.entries.clone();
    }

    public int missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    public int getOrDefault(int n2, int n3) {
        int n4 = this.get(n2);
        return this.missingValue != n4 ? n4 : n3;
    }

    public int get(int n2) {
        int n3;
        int n4 = this.missingValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = Hashing.evenHash(n2, n5);
        while (n4 != (n3 = nArray[n6 + 1]) && n2 != nArray[n6]) {
            n6 = Int2IntHashMap.next(n6, n5);
        }
        return n3;
    }

    @Override
    public int put(int n2, int n3) {
        int n4;
        int n5 = this.missingValue;
        if (n5 == n3) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int[] nArray = this.entries;
        int n6 = nArray.length - 1;
        int n7 = Hashing.evenHash(n2, n6);
        while (n5 != (n4 = nArray[n7 + 1]) && n2 != nArray[n7]) {
            n7 = Int2IntHashMap.next(n7, n6);
        }
        if (n5 == n4) {
            ++this.size;
            nArray[n7] = n2;
        }
        nArray[n7 + 1] = n3;
        this.increaseCapacity();
        return n4;
    }

    @Override
    public int putIfAbsent(int n2, int n3) {
        int n4;
        int n5 = this.missingValue;
        if (n5 == n3) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int[] nArray = this.entries;
        int n6 = nArray.length - 1;
        int n7 = Hashing.evenHash(n2, n6);
        while (n5 != (n4 = nArray[n7 + 1])) {
            if (n2 == nArray[n7]) {
                return n4;
            }
            n7 = Int2IntHashMap.next(n7, n6);
        }
        ++this.size;
        nArray[n7] = n2;
        nArray[n7 + 1] = n3;
        this.increaseCapacity();
        return n4;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int n2 = this.entries.length;
            this.rehash(n2);
        }
    }

    private void rehash(int n2) {
        int n3 = this.missingValue;
        int[] nArray = this.entries;
        int n4 = nArray.length;
        this.capacity(n2);
        int[] nArray2 = this.entries;
        int n5 = nArray2.length - 1;
        for (int i2 = 1; i2 < n4; i2 += 2) {
            int n6 = nArray[i2];
            if (n3 == n6) continue;
            int n7 = nArray[i2 - 1];
            int n8 = Hashing.evenHash(n7, n5);
            while (n3 != nArray2[n8 + 1]) {
                n8 = Int2IntHashMap.next(n8, n5);
            }
            nArray2[n8] = n7;
            nArray2[n8 + 1] = n6;
        }
    }

    @Deprecated
    public void intForEach(IntIntConsumer intIntConsumer) {
        this.forEachInt(intIntConsumer);
    }

    public void forEachInt(IntIntConsumer intIntConsumer) {
        Objects.requireNonNull(intIntConsumer);
        int n2 = this.missingValue;
        int[] nArray = this.entries;
        int n3 = nArray.length;
        int n4 = this.size;
        for (int i2 = 1; n4 > 0 && i2 < n3; i2 += 2) {
            if (n2 == nArray[i2]) continue;
            intIntConsumer.accept(nArray[i2 - 1], nArray[i2]);
            --n4;
        }
    }

    public boolean containsKey(int n2) {
        return this.missingValue != this.get(n2);
    }

    public boolean containsValue(int n2) {
        boolean bl2 = false;
        int n3 = this.missingValue;
        if (n3 != n2) {
            int[] nArray = this.entries;
            int n4 = nArray.length;
            int n5 = this.size;
            for (int i2 = 1; n5 > 0 && i2 < n4; i2 += 2) {
                int n6 = nArray[i2];
                if (n3 == n6) continue;
                if (n6 == n2) {
                    bl2 = true;
                    break;
                }
                --n5;
            }
        }
        return bl2;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public int computeIfAbsent(int n2, IntUnaryOperator intUnaryOperator) {
        int n3;
        Objects.requireNonNull(intUnaryOperator);
        int n4 = this.missingValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = Hashing.evenHash(n2, n5);
        while (n4 != (n3 = nArray[n6 + 1]) && n2 != nArray[n6]) {
            n6 = Int2IntHashMap.next(n6, n5);
        }
        if (n4 == n3 && n4 != (n3 = intUnaryOperator.applyAsInt(n2))) {
            nArray[n6] = n2;
            nArray[n6 + 1] = n3;
            ++this.size;
            this.increaseCapacity();
        }
        return n3;
    }

    public int computeIfPresent(int n2, IntBinaryOperator intBinaryOperator) {
        int n3;
        Objects.requireNonNull(intBinaryOperator);
        int n4 = this.missingValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = Hashing.evenHash(n2, n5);
        while (n4 != (n3 = nArray[n6 + 1]) && n2 != nArray[n6]) {
            n6 = Int2IntHashMap.next(n6, n5);
        }
        if (n4 != n3) {
            nArray[n6 + 1] = n3 = intBinaryOperator.applyAsInt(n2, n3);
            if (n3 == n4) {
                --this.size;
                this.compactChain(n6);
            }
        }
        return n3;
    }

    public int compute(int n2, IntBinaryOperator intBinaryOperator) {
        int n3;
        Objects.requireNonNull(intBinaryOperator);
        int n4 = this.missingValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = Hashing.evenHash(n2, n5);
        while (n4 != (n3 = nArray[n6 + 1]) && n2 != nArray[n6]) {
            n6 = Int2IntHashMap.next(n6, n5);
        }
        int n7 = intBinaryOperator.applyAsInt(n2, n3);
        if (n4 != n7) {
            nArray[n6 + 1] = n7;
            if (n3 == n4) {
                nArray[n6] = n2;
                ++this.size;
                this.increaseCapacity();
            }
        } else if (n4 != n3) {
            nArray[n6 + 1] = n4;
            --this.size;
            this.compactChain(n6);
        }
        return n7;
    }

    @Override
    public Integer get(Object object) {
        return this.valOrNull(this.get((Integer)object));
    }

    @Override
    public Integer put(Integer n2, Integer n3) {
        return this.valOrNull(this.put((int)n2, (int)n3));
    }

    @Override
    public void forEach(BiConsumer<? super Integer, ? super Integer> biConsumer) {
        this.forEachInt(biConsumer::accept);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey((Integer)object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.containsValue((Integer)object);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        for (Map.Entry<? extends Integer, ? extends Integer> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Int2IntHashMap int2IntHashMap) {
        EntryIterator entryIterator = int2IntHashMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            entryIterator.findNext();
            this.put(entryIterator.getIntKey(), entryIterator.getIntValue());
        }
    }

    @Override
    public Integer putIfAbsent(Integer n2, Integer n3) {
        return this.valOrNull(this.putIfAbsent((int)n2, (int)n3));
    }

    @Override
    public Integer replace(Integer n2, Integer n3) {
        return this.valOrNull(this.replace((int)n2, (int)n3));
    }

    @Override
    public boolean replace(Integer n2, Integer n3, Integer n4) {
        return this.replace((int)n2, (int)n3, (int)n4);
    }

    @Override
    public void replaceAll(BiFunction<? super Integer, ? super Integer, ? extends Integer> biFunction) {
        this.replaceAllInt(biFunction::apply);
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.values) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Integer remove(Object object) {
        return this.valOrNull(this.remove((Integer)object));
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.remove((Integer)object, (Integer)object2);
    }

    public int remove(int n2) {
        int n3;
        int n4 = this.missingValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = Hashing.evenHash(n2, n5);
        while (n4 != (n3 = nArray[n6 + 1])) {
            if (n2 == nArray[n6]) {
                nArray[n6 + 1] = n4;
                --this.size;
                this.compactChain(n6);
                break;
            }
            n6 = Int2IntHashMap.next(n6, n5);
        }
        return n3;
    }

    public boolean remove(int n2, int n3) {
        int n4;
        int n5 = this.missingValue;
        int[] nArray = this.entries;
        int n6 = nArray.length - 1;
        int n7 = Hashing.evenHash(n2, n6);
        while (n5 != (n4 = nArray[n7 + 1])) {
            if (n2 == nArray[n7]) {
                if (n3 != n4) break;
                nArray[n7 + 1] = n5;
                --this.size;
                this.compactChain(n7);
                return true;
            }
            n7 = Int2IntHashMap.next(n7, n6);
        }
        return false;
    }

    public int merge(int n2, int n3, IntIntFunction intIntFunction) {
        int n4;
        int n5;
        Objects.requireNonNull(intIntFunction);
        int n6 = this.missingValue;
        if (n6 == n3) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        int[] nArray = this.entries;
        int n7 = nArray.length - 1;
        int n8 = Hashing.evenHash(n2, n7);
        while (n6 != (n5 = nArray[n8 + 1]) && n2 != nArray[n8]) {
            n8 = Int2IntHashMap.next(n8, n7);
        }
        int n9 = n4 = n6 == n5 ? n3 : intIntFunction.apply(n5, n3);
        if (n6 != n4) {
            nArray[n8 + 1] = n4;
            if (n5 == n6) {
                nArray[n8] = n2;
                ++this.size;
                this.increaseCapacity();
            }
        } else {
            nArray[n8 + 1] = n6;
            --this.size;
            this.compactChain(n8);
        }
        return n4;
    }

    private void compactChain(int n2) {
        int n3;
        int n4 = this.missingValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = n2;
        while (n4 != (n3 = nArray[(n6 = Int2IntHashMap.next(n6, n5)) + 1])) {
            int n7 = nArray[n6];
            int n8 = Hashing.evenHash(n7, n5);
            if ((n6 >= n8 || n8 > n2 && n2 > n6) && (n8 > n2 || n2 > n6)) continue;
            nArray[n2] = n7;
            nArray[n2 + 1] = n3;
            nArray[n6 + 1] = n4;
            n2 = n6;
        }
    }

    public int minValue() {
        int n2 = this.missingValue;
        int n3 = 0 == this.size ? n2 : Integer.MAX_VALUE;
        int[] nArray = this.entries;
        int n4 = nArray.length;
        for (int i2 = 1; i2 < n4; i2 += 2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            n3 = Math.min(n3, n5);
        }
        return n3;
    }

    public int maxValue() {
        int n2 = this.missingValue;
        int n3 = 0 == this.size ? n2 : Integer.MIN_VALUE;
        int[] nArray = this.entries;
        int n4 = nArray.length;
        for (int i2 = 1; i2 < n4; i2 += 2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            n3 = Math.max(n3, n5);
        }
        return n3;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder stringBuilder = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            stringBuilder.append(entryIterator.getIntKey()).append('=').append(entryIterator.getIntValue());
            if (!entryIterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    @Override
    public int replace(int n2, int n3) {
        int n4;
        int n5 = this.missingValue;
        int[] nArray = this.entries;
        int n6 = nArray.length - 1;
        int n7 = Hashing.evenHash(n2, n6);
        while (n5 != (n4 = nArray[n7 + 1])) {
            if (n2 == nArray[n7]) {
                nArray[n7 + 1] = n3;
                break;
            }
            n7 = Int2IntHashMap.next(n7, n6);
        }
        return n4;
    }

    @Override
    public boolean replace(int n2, int n3, int n4) {
        int n5;
        int n6 = this.missingValue;
        int[] nArray = this.entries;
        int n7 = nArray.length - 1;
        int n8 = Hashing.evenHash(n2, n7);
        while (n6 != (n5 = nArray[n8 + 1])) {
            if (n2 == nArray[n8]) {
                if (n3 != n5) break;
                nArray[n8 + 1] = n4;
                return true;
            }
            n8 = Int2IntHashMap.next(n8, n7);
        }
        return false;
    }

    public void replaceAllInt(IntIntFunction intIntFunction) {
        Objects.requireNonNull(intIntFunction);
        int n2 = this.missingValue;
        int[] nArray = this.entries;
        int n3 = nArray.length;
        int n4 = this.size;
        for (int i2 = 1; n4 > 0 && i2 < n3; i2 += 2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            int n6 = intIntFunction.apply(nArray[i2 - 1], n5);
            if (n2 == n6) {
                throw new IllegalArgumentException("cannot replace with a missingValue");
            }
            nArray[i2] = n6;
            --n4;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        return this.size == map.size() && this.entrySet().equals(map.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int n2, int n3) {
        return n2 + 2 & n3;
    }

    private void capacity(int n2) {
        int n3 = n2 * 2;
        if (n3 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        this.entries = new int[n3];
        Arrays.fill(this.entries, this.missingValue);
    }

    private Integer valOrNull(int n2) {
        return this.missingValue == n2 ? null : Integer.valueOf(n2);
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, Integer>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2IntHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Integer n2 = Int2IntHashMap.this.get(entry.getKey());
            return n2 != null && n2.equals(entry.getValue());
        }

        public boolean removeIfInt(IntIntPredicate intIntPredicate) {
            boolean bl2 = false;
            EntryIterator entryIterator = this.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.findNext();
                if (!intIntPredicate.test(entryIterator.getIntKey(), entryIterator.getIntValue())) continue;
                entryIterator.remove();
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            T[] TArray2 = TArray.length >= Int2IntHashMap.this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), Int2IntHashMap.this.size);
            EntryIterator entryIterator = this.iterator();
            for (int i2 = 0; i2 < TArray2.length; ++i2) {
                if (!entryIterator.hasNext()) {
                    TArray2[i2] = null;
                    break;
                }
                entryIterator.next();
                TArray2[i2] = entryIterator.allocateDuplicateEntry();
            }
            return TArray2;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Integer> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return this.contains((Integer)object);
        }

        public boolean contains(int n2) {
            return Int2IntHashMap.this.containsValue(n2);
        }

        public boolean removeIfInt(IntPredicate intPredicate) {
            boolean bl2 = false;
            ValueIterator valueIterator = this.iterator();
            while (valueIterator.hasNext()) {
                if (!intPredicate.test(valueIterator.nextValue())) continue;
                valueIterator.remove();
                bl2 = true;
            }
            return bl2;
        }
    }

    public final class KeySet
    extends AbstractSet<Integer> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Int2IntHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Int2IntHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Int2IntHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Int2IntHashMap.this.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.contains((Integer)object);
        }

        public boolean contains(int n2) {
            return Int2IntHashMap.this.containsKey(n2);
        }

        public boolean removeIfInt(IntPredicate intPredicate) {
            boolean bl2 = false;
            KeyIterator keyIterator = this.iterator();
            while (keyIterator.hasNext()) {
                if (!intPredicate.test(keyIterator.nextValue())) continue;
                keyIterator.remove();
                bl2 = true;
            }
            return bl2;
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Integer, Integer>>,
    Map.Entry<Integer, Integer> {
        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2IntHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        public int getIntValue() {
            return Int2IntHashMap.this.entries[this.keyPosition() + 1];
        }

        @Override
        public Integer setValue(Integer n2) {
            return this.setValue((int)n2);
        }

        @Override
        public int setValue(int n2) {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (Int2IntHashMap.this.missingValue == n2) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            int n3 = this.keyPosition();
            int[] nArray = Int2IntHashMap.this.entries;
            int n4 = nArray[n3 + 1];
            nArray[n3 + 1] = n2;
            return n4;
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            this.findNext();
            if (Int2IntHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Integer, Integer> allocateDuplicateEntry() {
            return new MapEntry(this.getIntKey(), this.getIntValue());
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.getIntKey()) ^ Integer.hashCode(this.getIntValue());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
        }

        public final class MapEntry
        implements Map.Entry<Integer, Integer> {
            private final int k;
            private final int v;

            public MapEntry(int n2, int n3) {
                this.k = n2;
                this.v = n3;
            }

            @Override
            public Integer getKey() {
                return this.k;
            }

            @Override
            public Integer getValue() {
                return this.v;
            }

            @Override
            public Integer setValue(Integer n2) {
                return Int2IntHashMap.this.put(this.k, (int)n2);
            }

            @Override
            public int hashCode() {
                return Integer.hashCode(EntryIterator.this.getIntKey()) ^ Integer.hashCode(EntryIterator.this.getIntValue());
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return entry.getKey() != null && entry.getValue() != null && entry.getKey().equals(this.k) && entry.getValue().equals(this.v);
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition() + 1];
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<Integer> {
        @Override
        public Integer next() {
            return this.nextValue();
        }

        public int nextValue() {
            this.findNext();
            return Int2IntHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int n2;
            this.isPositionValid = false;
            this.remaining = Int2IntHashMap.this.size;
            int n3 = Int2IntHashMap.this.missingValue;
            int[] nArray = Int2IntHashMap.this.entries;
            int n4 = n2 = nArray.length;
            if (n3 != nArray[n2 - 1]) {
                for (int i2 = 1; i2 < n2; i2 += 2) {
                    if (n3 != nArray[i2]) continue;
                    n4 = i2 - 1;
                    break;
                }
            }
            this.stopCounter = n4;
            this.positionCounter = n4 + n2;
        }

        protected final int keyPosition() {
            return this.positionCounter & Int2IntHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int[] nArray = Int2IntHashMap.this.entries;
            int n2 = Int2IntHashMap.this.missingValue;
            int n3 = nArray.length - 1;
            int n4 = this.stopCounter;
            for (int i2 = this.positionCounter - 2; i2 >= n4; i2 -= 2) {
                int n5 = i2 & n3;
                if (n2 == nArray[n5 + 1]) continue;
                this.isPositionValid = true;
                this.positionCounter = i2;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int n2 = this.keyPosition();
            ((Int2IntHashMap)Int2IntHashMap.this).entries[n2 + 1] = Int2IntHashMap.this.missingValue;
            --Int2IntHashMap.this.size;
            Int2IntHashMap.this.compactChain(n2);
            this.isPositionValid = false;
        }
    }
}

