/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.IntIntConsumer;

public class Int2IntCounterMap {
    private static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final int initialValue;
    private int resizeThreshold;
    private int size = 0;
    private int[] entries;

    public Int2IntCounterMap(int n2) {
        this(8, 0.65f, n2);
    }

    public Int2IntCounterMap(int n2, float f2, int n3) {
        CollectionUtil.validateLoadFactor(f2);
        this.loadFactor = f2;
        this.initialValue = n3;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public int initialValue() {
        return this.initialValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public int get(int n2) {
        int n3;
        int n4 = this.initialValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = Hashing.evenHash(n2, n5);
        while (n4 != (n3 = nArray[n6 + 1]) && n2 != nArray[n6]) {
            n6 = Int2IntCounterMap.next(n6, n5);
        }
        return n3;
    }

    public int put(int n2, int n3) {
        int n4;
        int n5 = this.initialValue;
        if (n5 == n3) {
            throw new IllegalArgumentException("cannot accept initialValue");
        }
        int[] nArray = this.entries;
        int n6 = nArray.length - 1;
        int n7 = Hashing.evenHash(n2, n6);
        while (n5 != (n4 = nArray[n7 + 1]) && n2 != nArray[n7]) {
            n7 = Int2IntCounterMap.next(n7, n6);
        }
        if (n5 == n4) {
            ++this.size;
            nArray[n7] = n2;
        }
        nArray[n7 + 1] = n3;
        this.increaseCapacity();
        return n4;
    }

    public int incrementAndGet(int n2) {
        return this.addAndGet(n2, 1);
    }

    public int decrementAndGet(int n2) {
        return this.addAndGet(n2, -1);
    }

    public int addAndGet(int n2, int n3) {
        return this.getAndAdd(n2, n3) + n3;
    }

    public int getAndIncrement(int n2) {
        return this.getAndAdd(n2, 1);
    }

    public int getAndDecrement(int n2) {
        return this.getAndAdd(n2, -1);
    }

    public int getAndAdd(int n2, int n3) {
        int n4;
        int n5 = this.initialValue;
        int[] nArray = this.entries;
        int n6 = nArray.length - 1;
        int n7 = Hashing.evenHash(n2, n6);
        while (n5 != (n4 = nArray[n7 + 1]) && n2 != nArray[n7]) {
            n7 = Int2IntCounterMap.next(n7, n6);
        }
        if (n3 != 0) {
            int n8;
            nArray[n7 + 1] = n8 = n4 + n3;
            if (n5 == n4) {
                ++this.size;
                nArray[n7] = n2;
                this.increaseCapacity();
            } else if (n5 == n8) {
                --this.size;
                this.compactChain(n7);
            }
        }
        return n4;
    }

    public void forEach(IntIntConsumer intIntConsumer) {
        int n2 = this.initialValue;
        int[] nArray = this.entries;
        int n3 = nArray.length;
        int n4 = this.size;
        for (int i2 = 1; n4 > 0 && i2 < n3; i2 += 2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            intIntConsumer.accept(nArray[i2 - 1], n5);
            --n4;
        }
    }

    public boolean containsKey(int n2) {
        return this.initialValue != this.get(n2);
    }

    public boolean containsValue(int n2) {
        boolean bl2 = false;
        if (this.initialValue != n2) {
            int[] nArray = this.entries;
            int n3 = nArray.length;
            for (int i2 = 1; i2 < n3; i2 += 2) {
                if (n2 != nArray[i2]) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.initialValue);
            this.size = 0;
        }
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    public int computeIfAbsent(int n2, IntUnaryOperator intUnaryOperator) {
        int n3 = this.get(n2);
        if (this.initialValue == n3 && this.initialValue != (n3 = intUnaryOperator.applyAsInt(n2))) {
            this.put(n2, n3);
        }
        return n3;
    }

    public int remove(int n2) {
        int n3;
        int n4 = this.initialValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = Hashing.evenHash(n2, n5);
        while (n4 != (n3 = nArray[n6 + 1])) {
            if (n2 == nArray[n6]) {
                nArray[n6 + 1] = n4;
                --this.size;
                this.compactChain(n6);
                break;
            }
            n6 = Int2IntCounterMap.next(n6, n5);
        }
        return n3;
    }

    public int minValue() {
        int n2 = this.initialValue;
        int n3 = 0 == this.size ? n2 : Integer.MAX_VALUE;
        int[] nArray = this.entries;
        int n4 = nArray.length;
        for (int i2 = 1; i2 < n4; i2 += 2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            n3 = Math.min(n3, n5);
        }
        return n3;
    }

    public int maxValue() {
        int n2 = this.initialValue;
        int n3 = 0 == this.size ? n2 : Integer.MIN_VALUE;
        int[] nArray = this.entries;
        int n4 = nArray.length;
        for (int i2 = 1; i2 < n4; i2 += 2) {
            int n5 = nArray[i2];
            if (n2 == n5) continue;
            n3 = Math.max(n3, n5);
        }
        return n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        int n2 = this.initialValue;
        int[] nArray = this.entries;
        int n3 = nArray.length;
        for (int i2 = 1; i2 < n3; i2 += 2) {
            int n4 = nArray[i2];
            if (n2 == n4) continue;
            stringBuilder.append(nArray[i2 - 1]).append('=').append(n4).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static int next(int n2, int n3) {
        return n2 + 2 & n3;
    }

    private void compactChain(int n2) {
        int n3;
        int n4 = this.initialValue;
        int[] nArray = this.entries;
        int n5 = nArray.length - 1;
        int n6 = n2;
        while (n4 != (n3 = nArray[(n6 = Int2IntCounterMap.next(n6, n5)) + 1])) {
            int n7 = nArray[n6];
            int n8 = Hashing.evenHash(n7, n5);
            if ((n6 >= n8 || n8 > n2 && n2 > n6) && (n8 > n2 || n2 > n6)) continue;
            nArray[n2] = n7;
            nArray[n2 + 1] = n3;
            nArray[n6 + 1] = n4;
            n2 = n6;
        }
    }

    private void capacity(int n2) {
        int n3 = n2 * 2;
        if (n3 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        this.entries = new int[n3];
        Arrays.fill(this.entries, this.initialValue);
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int n2 = this.entries.length;
            this.rehash(n2);
        }
    }

    private void rehash(int n2) {
        int n3 = this.initialValue;
        int[] nArray = this.entries;
        int n4 = nArray.length;
        this.capacity(n2);
        int[] nArray2 = this.entries;
        int n5 = nArray2.length - 1;
        for (int i2 = 1; i2 < n4; i2 += 2) {
            int n6 = nArray[i2];
            if (n3 == n6) continue;
            int n7 = nArray[i2 - 1];
            int n8 = Hashing.evenHash(n7, n5);
            while (n3 != nArray2[n8 + 1]) {
                n8 = Int2IntCounterMap.next(n8, n5);
            }
            nArray2[n8] = n7;
            nArray2[n8 + 1] = n6;
        }
    }
}

