/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

public final class SemanticVersion {
    private SemanticVersion() {
    }

    public static int compose(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException("major must be 0-255: " + n2);
        }
        if (n3 < 0 || n3 > 255) {
            throw new IllegalArgumentException("minor must be 0-255: " + n3);
        }
        if (n4 < 0 || n4 > 255) {
            throw new IllegalArgumentException("patch must be 0-255: " + n4);
        }
        if (n2 + n3 + n4 == 0) {
            throw new IllegalArgumentException("all parts cannot be zero");
        }
        return n2 << 16 | n3 << 8 | n4;
    }

    public static int major(int n2) {
        return n2 >> 16 & 0xFF;
    }

    public static int minor(int n2) {
        return n2 >> 8 & 0xFF;
    }

    public static int patch(int n2) {
        return n2 & 0xFF;
    }

    public static String toString(int n2) {
        return SemanticVersion.major(n2) + "." + SemanticVersion.minor(n2) + "." + SemanticVersion.patch(n2);
    }
}

