/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import org.agrona.DirectBuffer;

public final class PrintBufferUtil {
    private static final String NEWLINE;
    private static final String EMPTY_STRING = "";
    private static final String[] BYTE2HEX_PAD;

    private PrintBufferUtil() {
    }

    public static String hexDump(DirectBuffer directBuffer) {
        return PrintBufferUtil.hexDump(directBuffer, 0, directBuffer.capacity());
    }

    public static String hexDump(DirectBuffer directBuffer, int n2, int n3) {
        return HexUtil.hexDump(directBuffer, n2, n3);
    }

    public static String hexDump(byte[] byArray) {
        return PrintBufferUtil.hexDump(byArray, 0, byArray.length);
    }

    public static String hexDump(byte[] byArray, int n2, int n3) {
        return HexUtil.hexDump(byArray, n2, n3);
    }

    public static String prettyHexDump(DirectBuffer directBuffer) {
        return PrintBufferUtil.prettyHexDump(directBuffer, 0, directBuffer.capacity());
    }

    public static String prettyHexDump(DirectBuffer directBuffer, int n2, int n3) {
        return HexUtil.prettyHexDump(directBuffer, n2, n3);
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, DirectBuffer directBuffer) {
        PrintBufferUtil.appendPrettyHexDump(stringBuilder, directBuffer, 0, directBuffer.capacity());
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, DirectBuffer directBuffer, int n2, int n3) {
        HexUtil.appendPrettyHexDump(stringBuilder, directBuffer, n2, n3);
    }

    public static String byteToHexStringPadded(int n2) {
        return BYTE2HEX_PAD[n2 & 0xFF];
    }

    static {
        int n2;
        NEWLINE = System.lineSeparator();
        BYTE2HEX_PAD = new String[256];
        for (n2 = 0; n2 < 10; ++n2) {
            PrintBufferUtil.BYTE2HEX_PAD[n2] = "0" + n2;
        }
        while (n2 < 16) {
            char c2 = (char)(97 + n2 - 10);
            PrintBufferUtil.BYTE2HEX_PAD[n2] = "0" + c2;
            ++n2;
        }
        while (n2 < BYTE2HEX_PAD.length) {
            PrintBufferUtil.BYTE2HEX_PAD[n2] = Integer.toHexString(n2);
            ++n2;
        }
    }

    static final class HexUtil {
        private static final char[] BYTE2CHAR;
        private static final char[] HEXDUMP_TABLE;
        private static final String[] HEX_PADDING;
        private static final String[] HEXDUMP_ROW_PREFIXES;
        private static final String[] BYTE2HEX;
        private static final String[] BYTE_PADDING;

        HexUtil() {
        }

        static short getUnsignedByte(DirectBuffer directBuffer, int n2) {
            return (short)(directBuffer.getByte(n2) & 0xFF);
        }

        static String hexDump(DirectBuffer directBuffer, int n2, int n3) {
            if (n3 < 0) {
                throw new IllegalArgumentException("length: " + n3);
            }
            if (n3 == 0) {
                return PrintBufferUtil.EMPTY_STRING;
            }
            int n4 = n2 + n3;
            char[] cArray = new char[n3 << 1];
            int n5 = 0;
            int n6 = n2;
            while (n6 < n4) {
                System.arraycopy(HEXDUMP_TABLE, HexUtil.getUnsignedByte(directBuffer, n6) << 1, cArray, n5, 2);
                ++n6;
                n5 += 2;
            }
            return new String(cArray);
        }

        static String hexDump(byte[] byArray, int n2, int n3) {
            if (n3 < 0) {
                throw new IllegalArgumentException("length < 0: " + n3);
            }
            if (n3 == 0) {
                return PrintBufferUtil.EMPTY_STRING;
            }
            int n4 = n2 + n3;
            char[] cArray = new char[n3 << 1];
            int n5 = 0;
            int n6 = n2;
            while (n6 < n4) {
                System.arraycopy(HEXDUMP_TABLE, (byArray[n6] & 0xFF) << 1, cArray, n5, 2);
                ++n6;
                n5 += 2;
            }
            return new String(cArray);
        }

        static String prettyHexDump(DirectBuffer directBuffer, int n2, int n3) {
            if (n3 == 0) {
                return PrintBufferUtil.EMPTY_STRING;
            }
            int n4 = n3 / 16 + (n3 % 15 == 0 ? 0 : 1) + 4;
            StringBuilder stringBuilder = new StringBuilder(n4 * 80);
            HexUtil.appendPrettyHexDump(stringBuilder, directBuffer, n2, n3);
            return stringBuilder.toString();
        }

        static boolean isOutOfBounds(int n2, int n3, int n4) {
            return (n2 | n3 | n2 + n3 | n4 - (n2 + n3)) < 0;
        }

        static void appendPrettyHexDump(StringBuilder stringBuilder, DirectBuffer directBuffer, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            if (HexUtil.isOutOfBounds(n2, n3, directBuffer.capacity())) {
                throw new IndexOutOfBoundsException("expected: 0 <= offset(" + n2 + ") <= offset + length(" + n3 + ") <= buffer.capacity(" + directBuffer.capacity() + ')');
            }
            if (n3 == 0) {
                return;
            }
            stringBuilder.append("         +-------------------------------------------------+").append(NEWLINE).append("         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |").append(NEWLINE).append("+--------+-------------------------------------------------+----------------+");
            int n7 = n3 >>> 4;
            int n8 = n3 & 0xF;
            for (n6 = 0; n6 < n7; ++n6) {
                int n9;
                n5 = (n6 << 4) + n2;
                HexUtil.appendHexDumpRowPrefix(stringBuilder, n6, n5);
                n4 = n5 + 16;
                for (n9 = n5; n9 < n4; ++n9) {
                    stringBuilder.append(BYTE2HEX[HexUtil.getUnsignedByte(directBuffer, n9)]);
                }
                stringBuilder.append(" |");
                for (n9 = n5; n9 < n4; ++n9) {
                    stringBuilder.append(BYTE2CHAR[HexUtil.getUnsignedByte(directBuffer, n9)]);
                }
                stringBuilder.append('|');
            }
            if (n8 != 0) {
                n6 = (n7 << 4) + n2;
                HexUtil.appendHexDumpRowPrefix(stringBuilder, n7, n6);
                n5 = n6 + n8;
                for (n4 = n6; n4 < n5; ++n4) {
                    stringBuilder.append(BYTE2HEX[HexUtil.getUnsignedByte(directBuffer, n4)]);
                }
                stringBuilder.append(HEX_PADDING[n8]);
                stringBuilder.append(" |");
                for (n4 = n6; n4 < n5; ++n4) {
                    stringBuilder.append(BYTE2CHAR[HexUtil.getUnsignedByte(directBuffer, n4)]);
                }
                stringBuilder.append(BYTE_PADDING[n8]);
                stringBuilder.append('|');
            }
            stringBuilder.append(NEWLINE).append("+--------+-------------------------------------------------+----------------+");
        }

        static void appendHexDumpRowPrefix(StringBuilder stringBuilder, int n2, int n3) {
            if (n2 < HEXDUMP_ROW_PREFIXES.length) {
                stringBuilder.append(HEXDUMP_ROW_PREFIXES[n2]);
            } else {
                stringBuilder.append(NEWLINE);
                stringBuilder.append(Long.toHexString((long)n3 & 0xFFFFFFFFL | 0x100000000L));
                stringBuilder.setCharAt(stringBuilder.length() - 9, '|');
                stringBuilder.append('|');
            }
        }

        static {
            int n2;
            StringBuilder stringBuilder;
            int n3;
            BYTE2CHAR = new char[256];
            HEXDUMP_TABLE = new char[1024];
            HEX_PADDING = new String[16];
            HEXDUMP_ROW_PREFIXES = new String[4096];
            BYTE2HEX = new String[256];
            BYTE_PADDING = new String[16];
            char[] cArray = "0123456789abcdef".toCharArray();
            for (n3 = 0; n3 < 256; ++n3) {
                HexUtil.HEXDUMP_TABLE[n3 << 1] = cArray[n3 >>> 4 & 0xF];
                HexUtil.HEXDUMP_TABLE[(n3 << 1) + 1] = cArray[n3 & 0xF];
            }
            for (n3 = 0; n3 < HEX_PADDING.length; ++n3) {
                int n4 = HEX_PADDING.length - n3;
                stringBuilder = new StringBuilder(n4 * 3);
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuilder.append("   ");
                }
                HexUtil.HEX_PADDING[n3] = stringBuilder.toString();
            }
            for (n3 = 0; n3 < HEXDUMP_ROW_PREFIXES.length; ++n3) {
                StringBuilder stringBuilder2 = new StringBuilder(12);
                stringBuilder2.append(NEWLINE);
                stringBuilder2.append(Long.toHexString((long)n3 << 4 & 0xFFFFFFFFL | 0x100000000L));
                stringBuilder2.setCharAt(stringBuilder2.length() - 9, '|');
                stringBuilder2.append('|');
                HexUtil.HEXDUMP_ROW_PREFIXES[n3] = stringBuilder2.toString();
            }
            for (n3 = 0; n3 < BYTE2HEX.length; ++n3) {
                HexUtil.BYTE2HEX[n3] = ' ' + PrintBufferUtil.byteToHexStringPadded(n3);
            }
            for (n3 = 0; n3 < BYTE_PADDING.length; ++n3) {
                int n5 = BYTE_PADDING.length - n3;
                stringBuilder = new StringBuilder(n5);
                for (n2 = 0; n2 < n5; ++n2) {
                    stringBuilder.append(' ');
                }
                HexUtil.BYTE_PADDING[n3] = stringBuilder.toString();
            }
            for (n3 = 0; n3 < BYTE2CHAR.length; ++n3) {
                HexUtil.BYTE2CHAR[n3] = (char)(n3 <= 31 || n3 >= 127 ? 46 : (char)n3);
            }
        }
    }
}

