/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.agrona.BufferUtil;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.UnsafeAccess;

public final class IoUtil {
    public static final int BLOCK_SIZE = 4096;
    private static final byte[] FILLER = new byte[4096];
    private static final int MAP_READ_ONLY = 0;
    private static final int MAP_READ_WRITE = 1;
    private static final int MAP_PRIVATE = 2;

    private IoUtil() {
    }

    public static void fill(FileChannel fileChannel, long l2, long l3, byte by2) {
        try {
            byte[] byArray;
            if (0 != by2) {
                byArray = new byte[4096];
                Arrays.fill(byArray, by2);
            } else {
                byArray = FILLER;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            fileChannel.position(l2);
            int n2 = (int)(l3 / 4096L);
            int n3 = (int)(l3 % 4096L);
            for (int i2 = 0; i2 < n2; ++i2) {
                byteBuffer.position(0);
                fileChannel.write(byteBuffer);
            }
            if (n3 > 0) {
                byteBuffer.position(0);
                byteBuffer.limit(n3);
                fileChannel.write(byteBuffer);
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
    }

    public static void delete(File file, boolean bl2) {
        if (file.exists()) {
            File[] fileArray;
            if (file.isDirectory() && null != (fileArray = file.listFiles())) {
                for (File file2 : fileArray) {
                    IoUtil.delete(file2, bl2);
                }
            }
            if (!file.delete() && !bl2) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException iOException) {
                    LangUtil.rethrowUnchecked(iOException);
                }
            }
        }
    }

    public static void delete(File file, ErrorHandler errorHandler) {
        try {
            if (file.exists()) {
                File[] fileArray;
                if (file.isDirectory() && null != (fileArray = file.listFiles())) {
                    for (File file2 : fileArray) {
                        IoUtil.delete(file2, errorHandler);
                    }
                }
                if (!file.delete()) {
                    Files.delete(file.toPath());
                }
            }
        }
        catch (Exception exception) {
            errorHandler.onError(exception);
        }
    }

    public static void ensureDirectoryExists(File file, String string) {
        if (!file.exists() && !file.mkdirs()) {
            throw new IllegalArgumentException("could not create " + string + " directory: " + file);
        }
    }

    public static void ensureDirectoryIsRecreated(File file, String string, BiConsumer<String, String> biConsumer) {
        if (file.exists()) {
            IoUtil.delete(file, false);
            biConsumer.accept(file.getAbsolutePath(), string);
        }
        if (!file.mkdirs()) {
            throw new IllegalArgumentException("could not create " + string + " directory: " + file);
        }
    }

    public static void deleteIfExists(File file) {
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
    }

    public static void deleteIfExists(File file, ErrorHandler errorHandler) {
        try {
            Files.deleteIfExists(file.toPath());
        }
        catch (Exception exception) {
            errorHandler.onError(exception);
        }
    }

    public static FileChannel createEmptyFile(File file, long l2) {
        return IoUtil.createEmptyFile(file, l2, true);
    }

    public static FileChannel createEmptyFile(File file, long l2, boolean bl2) {
        IoUtil.ensureDirectoryExists(file.getParentFile(), file.getParent());
        FileChannel fileChannel = null;
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(l2);
            fileChannel = randomAccessFile.getChannel();
            if (bl2) {
                IoUtil.fill(fileChannel, 0L, l2, (byte)0);
            }
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return fileChannel;
    }

    public static MappedByteBuffer mapExistingFile(File file, String string) {
        return IoUtil.mapExistingFile(file, FileChannel.MapMode.READ_WRITE, string);
    }

    public static MappedByteBuffer mapExistingFile(File file, String string, long l2, long l3) {
        return IoUtil.mapExistingFile(file, FileChannel.MapMode.READ_WRITE, string, l2, l3);
    }

    public static MappedByteBuffer mapExistingFile(File file, FileChannel.MapMode mapMode, String string) {
        IoUtil.checkFileExists(file, string);
        MappedByteBuffer mappedByteBuffer = null;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, IoUtil.getFileMode(mapMode));
             FileChannel fileChannel = randomAccessFile.getChannel();){
            mappedByteBuffer = fileChannel.map(mapMode, 0L, fileChannel.size());
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return mappedByteBuffer;
    }

    public static MappedByteBuffer mapExistingFile(File file, FileChannel.MapMode mapMode, String string, long l2, long l3) {
        IoUtil.checkFileExists(file, string);
        MappedByteBuffer mappedByteBuffer = null;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, IoUtil.getFileMode(mapMode));
             FileChannel fileChannel = randomAccessFile.getChannel();){
            mappedByteBuffer = fileChannel.map(mapMode, l2, l3);
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        return mappedByteBuffer;
    }

    public static MappedByteBuffer mapNewFile(File file, long l2) {
        return IoUtil.mapNewFile(file, l2, true);
    }

    public static MappedByteBuffer mapNewFile(File file, long l2, boolean bl2) {
        Buffer buffer = null;
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            buffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, l2);
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
        if (bl2) {
            int n2 = buffer.capacity();
            for (int i2 = 0; i2 < n2; i2 += 4096) {
                ((ByteBuffer)buffer).put(i2, (byte)0);
            }
        }
        return buffer;
    }

    public static void checkFileExists(File file, String string) {
        if (!file.exists()) {
            String string2 = "missing file for " + string + " : " + file.getAbsolutePath();
            throw new IllegalStateException(string2);
        }
    }

    public static void unmap(MappedByteBuffer mappedByteBuffer) {
        BufferUtil.free(mappedByteBuffer);
    }

    public static long map(FileChannel fileChannel, FileChannel.MapMode mapMode, long l2, long l3) {
        try {
            if (null != MappingMethods.MAP_FILE_DISPATCHER) {
                FileDescriptor fileDescriptor = MappingMethods.GET_FILE_DESCRIPTOR.invoke(fileChannel);
                return MappingMethods.MAP_FILE_DISPATCHER.invoke(MappingMethods.FILE_DISPATCHER, fileDescriptor, IoUtil.getMode(mapMode), l2, l3, false);
            }
            if (null != MappingMethods.MAP_ADDRESS) {
                return MappingMethods.MAP_ADDRESS.invoke(fileChannel, IoUtil.getMode(mapMode), l2, l3);
            }
            return MappingMethods.MAP_WITH_SYNC_ADDRESS.invoke(fileChannel, IoUtil.getMode(mapMode), l2, l3, false);
        }
        catch (Throwable throwable) {
            LangUtil.rethrowUnchecked(throwable);
            return 0L;
        }
    }

    public static void unmap(FileChannel fileChannel, long l2, long l3) {
        try {
            if (null != MappingMethods.UNMAP_FILE_DISPATCHER) {
                MappingMethods.UNMAP_FILE_DISPATCHER.invoke(MappingMethods.FILE_DISPATCHER, l2, l3);
            } else {
                MappingMethods.UNMAP_ADDRESS.invoke(l2, l3);
            }
        }
        catch (Throwable throwable) {
            LangUtil.rethrowUnchecked(throwable);
        }
    }

    public static void unmap(ByteBuffer byteBuffer) {
        if (byteBuffer instanceof MappedByteBuffer) {
            IoUtil.unmap((MappedByteBuffer)byteBuffer);
        }
    }

    public static String tmpDirName() {
        String string = System.getProperty("java.io.tmpdir");
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public static void removeTrailingSlashes(StringBuilder stringBuilder) {
        int n2;
        char c2;
        while (stringBuilder.length() > 1 && ('/' == (c2 = stringBuilder.charAt(n2 = stringBuilder.length() - 1)) || '\\' == c2)) {
            stringBuilder.setLength(n2);
        }
    }

    private static String getFileMode(FileChannel.MapMode mapMode) {
        return mapMode == FileChannel.MapMode.READ_ONLY ? "r" : "rw";
    }

    private static int getMode(FileChannel.MapMode mapMode) {
        if (mapMode == FileChannel.MapMode.READ_ONLY) {
            return 0;
        }
        if (mapMode == FileChannel.MapMode.READ_WRITE) {
            return 1;
        }
        return 2;
    }

    static class MappingMethods {
        static final MethodHandle MAP_FILE_DISPATCHER;
        static final MethodHandle UNMAP_FILE_DISPATCHER;
        static final Object FILE_DISPATCHER;
        static final MethodHandle GET_FILE_DESCRIPTOR;
        static final MethodHandle MAP_WITH_SYNC_ADDRESS;
        static final MethodHandle MAP_ADDRESS;
        static final MethodHandle UNMAP_ADDRESS;

        MappingMethods() {
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) throws NoSuchMethodException {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            return method;
        }

        static {
            try {
                Class<?> clazz = Class.forName("sun.nio.ch.FileChannelImpl");
                Class<?> clazz2 = Class.forName("sun.nio.ch.FileDispatcher");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object object = null;
                MethodHandle methodHandle = null;
                MethodHandle methodHandle2 = null;
                MethodHandle methodHandle3 = null;
                MethodHandle methodHandle4 = null;
                MethodHandle methodHandle5 = null;
                MethodHandle methodHandle6 = null;
                try {
                    Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                    lookup = (MethodHandles.Lookup)UnsafeAccess.UNSAFE.getObject(MethodHandles.Lookup.class, UnsafeAccess.UNSAFE.staticFieldOffset(field));
                    object = lookup.unreflectGetter(clazz.getDeclaredField("nd")).invoke();
                    methodHandle2 = lookup.unreflectGetter(clazz.getDeclaredField("fd"));
                    methodHandle = lookup.unreflect(clazz2.getDeclaredMethod("map", FileDescriptor.class, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE));
                    methodHandle5 = lookup.unreflect(clazz2.getDeclaredMethod("unmap", Long.TYPE, Long.TYPE));
                }
                catch (Throwable throwable) {
                    methodHandle6 = lookup.unreflect(MappingMethods.getMethod(clazz, "unmap0", Long.TYPE, Long.TYPE));
                    try {
                        methodHandle4 = lookup.unreflect(MappingMethods.getMethod(clazz, "map0", Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE));
                    }
                    catch (Exception exception) {
                        methodHandle3 = lookup.unreflect(MappingMethods.getMethod(clazz, "map0", Integer.TYPE, Long.TYPE, Long.TYPE));
                    }
                }
                MAP_FILE_DISPATCHER = methodHandle;
                UNMAP_FILE_DISPATCHER = methodHandle5;
                FILE_DISPATCHER = object;
                GET_FILE_DESCRIPTOR = methodHandle2;
                MAP_WITH_SYNC_ADDRESS = methodHandle4;
                MAP_ADDRESS = methodHandle3;
                UNMAP_ADDRESS = methodHandle6;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

