/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.UnsafeAccess;

public final class BufferUtil {
    public static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
    public static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    public static final long ARRAY_BASE_OFFSET = UnsafeAccess.UNSAFE.arrayBaseOffset(byte[].class);
    public static final long BYTE_BUFFER_HB_FIELD_OFFSET;
    public static final long BYTE_BUFFER_OFFSET_FIELD_OFFSET;
    public static final long BYTE_BUFFER_ADDRESS_FIELD_OFFSET;
    private static final MethodHandle INVOKE_CLEANER;
    private static final MethodHandle GET_CLEANER;
    private static final MethodHandle CLEAN;

    private BufferUtil() {
    }

    public static void boundsCheck(byte[] byArray, long l2, int n2) {
        int n3 = byArray.length;
        long l3 = l2 + (long)n2;
        if (l2 < 0L || l3 > (long)n3) {
            throw new IndexOutOfBoundsException("index=" + l2 + " length=" + n2 + " capacity=" + n3);
        }
    }

    public static void boundsCheck(ByteBuffer byteBuffer, long l2, int n2) {
        int n3 = byteBuffer.capacity();
        long l3 = l2 + (long)n2;
        if (l2 < 0L || l3 > (long)n3) {
            throw new IndexOutOfBoundsException("index=" + l2 + " length=" + n2 + " capacity=" + n3);
        }
    }

    public static long address(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("buffer.isDirect() must be true");
        }
        return UnsafeAccess.UNSAFE.getLong(byteBuffer, BYTE_BUFFER_ADDRESS_FIELD_OFFSET);
    }

    public static byte[] array(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            throw new IllegalArgumentException("buffer must wrap an array");
        }
        return (byte[])UnsafeAccess.UNSAFE.getObject(byteBuffer, BYTE_BUFFER_HB_FIELD_OFFSET);
    }

    public static int arrayOffset(ByteBuffer byteBuffer) {
        return UnsafeAccess.UNSAFE.getInt(byteBuffer, BYTE_BUFFER_OFFSET_FIELD_OFFSET);
    }

    public static ByteBuffer allocateDirectAligned(int n2, int n3) {
        if (!BitUtil.isPowerOfTwo(n3)) {
            throw new IllegalArgumentException("Must be a power of 2: alignment=" + n3);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2 + n3);
        long l2 = BufferUtil.address(byteBuffer);
        int n4 = (int)(l2 & (long)(n3 - 1));
        int n5 = n3 - n4;
        byteBuffer.limit(n2 + n5);
        byteBuffer.position(n5);
        return byteBuffer.slice();
    }

    public static void free(DirectBuffer directBuffer) {
        if (null != directBuffer) {
            BufferUtil.free(directBuffer.byteBuffer());
        }
    }

    public static void free(ByteBuffer byteBuffer) {
        if (null != byteBuffer && byteBuffer.isDirect()) {
            try {
                if (null != INVOKE_CLEANER) {
                    INVOKE_CLEANER.invokeExact(UnsafeAccess.UNSAFE, byteBuffer);
                } else {
                    Object object = GET_CLEANER.invoke(byteBuffer);
                    if (null != object) {
                        CLEAN.invoke(object);
                    }
                }
            }
            catch (Throwable throwable) {
                LangUtil.rethrowUnchecked(throwable);
            }
        }
    }

    static {
        try {
            BYTE_BUFFER_HB_FIELD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("hb"));
            BYTE_BUFFER_OFFSET_FIELD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("offset"));
            BYTE_BUFFER_ADDRESS_FIELD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            MethodHandle methodHandle = null;
            MethodHandle methodHandle2 = null;
            MethodHandle methodHandle3 = null;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                methodHandle = lookup.findVirtual(UnsafeAccess.UNSAFE.getClass(), "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Class<?> clazz = Class.forName("sun.nio.ch.DirectBuffer");
                Class<?> clazz2 = Class.forName("sun.misc.Cleaner");
                methodHandle2 = lookup.findVirtual(clazz, "cleaner", MethodType.methodType(clazz2));
                methodHandle3 = lookup.findVirtual(clazz2, "clean", MethodType.methodType(Void.TYPE));
            }
            INVOKE_CLEANER = methodHandle;
            GET_CLEANER = methodHandle2;
            CLEAN = methodHandle3;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

