/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.PackedHistogram;

public class PackedDoubleHistogram
extends DoubleHistogram {
    public PackedDoubleHistogram(int n2) {
        this(2L, n2);
        this.setAutoResize(true);
    }

    public PackedDoubleHistogram(long l2, int n2) {
        this(l2, n2, PackedHistogram.class);
    }

    public PackedDoubleHistogram(DoubleHistogram doubleHistogram) {
        super(doubleHistogram);
    }

    PackedDoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz) {
        super(l2, n2, clazz);
    }

    PackedDoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz, AbstractHistogram abstractHistogram) {
        super(l2, n2, clazz, abstractHistogram);
    }

    public static PackedDoubleHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        try {
            int n2 = byteBuffer.getInt();
            if (!PackedDoubleHistogram.isNonCompressedDoubleHistogramCookie(n2)) {
                throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
            }
            PackedDoubleHistogram packedDoubleHistogram = PackedDoubleHistogram.constructHistogramFromBuffer(n2, byteBuffer, PackedDoubleHistogram.class, PackedHistogram.class, l2);
            return packedDoubleHistogram;
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(dataFormatException);
        }
    }

    public static PackedDoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        int n2 = byteBuffer.getInt();
        if (!PackedDoubleHistogram.isCompressedDoubleHistogramCookie(n2)) {
            throw new IllegalArgumentException("The buffer does not contain a compressed DoubleHistogram");
        }
        PackedDoubleHistogram packedDoubleHistogram = PackedDoubleHistogram.constructHistogramFromBuffer(n2, byteBuffer, PackedDoubleHistogram.class, PackedHistogram.class, l2);
        return packedDoubleHistogram;
    }
}

