/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static final Timeout NONE = new Timeout(){

        @Override
        public Timeout timeout(long l2, TimeUnit timeUnit) {
            return this;
        }

        @Override
        public Timeout deadlineNanoTime(long l2) {
            return this;
        }

        @Override
        public void throwIfReached() throws IOException {
        }
    };
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;

    public Timeout timeout(long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeout < 0: " + l2);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        this.timeoutNanos = timeUnit.toNanos(l2);
        return this;
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (!this.hasDeadline) {
            throw new IllegalStateException("No deadline");
        }
        return this.deadlineNanoTime;
    }

    public Timeout deadlineNanoTime(long l2) {
        this.hasDeadline = true;
        this.deadlineNanoTime = l2;
        return this;
    }

    public final Timeout deadline(long l2, TimeUnit timeUnit) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("duration <= 0: " + l2);
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException("unit == null");
        }
        return this.deadlineNanoTime(System.nanoTime() + timeUnit.toNanos(l2));
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() throws IOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException("thread interrupted");
        }
        if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
            throw new InterruptedIOException("deadline reached");
        }
    }

    public final void waitUntilNotified(Object object) throws InterruptedIOException {
        try {
            long l2;
            long l3;
            boolean bl2 = this.hasDeadline();
            long l4 = this.timeoutNanos();
            if (!bl2 && l4 == 0L) {
                object.wait();
                return;
            }
            long l5 = System.nanoTime();
            if (bl2 && l4 != 0L) {
                l3 = this.deadlineNanoTime() - l5;
                l2 = Math.min(l4, l3);
            } else {
                l2 = bl2 ? this.deadlineNanoTime() - l5 : l4;
            }
            l3 = 0L;
            if (l2 > 0L) {
                long l6 = l2 / 1000000L;
                object.wait(l6, (int)(l2 - l6 * 1000000L));
                l3 = System.nanoTime() - l5;
            }
            if (l3 >= l2) {
                throw new InterruptedIOException("timeout");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("interrupted");
        }
    }
}

