/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import okio.Buffer;
import okio.ByteString;
import okio.Segment;
import okio.Util;

final class SegmentedByteString
extends ByteString {
    final transient byte[][] segments;
    final transient int[] directory;

    SegmentedByteString(Buffer buffer, int n2) {
        super(null);
        Util.checkOffsetAndCount(buffer.size, 0L, n2);
        int n3 = 0;
        int n4 = 0;
        Segment segment = buffer.head;
        while (n3 < n2) {
            if (segment.limit == segment.pos) {
                throw new AssertionError((Object)"s.limit == s.pos");
            }
            n3 += segment.limit - segment.pos;
            ++n4;
            segment = segment.next;
        }
        this.segments = new byte[n4][];
        this.directory = new int[n4 * 2];
        n3 = 0;
        n4 = 0;
        segment = buffer.head;
        while (n3 < n2) {
            this.segments[n4] = segment.data;
            if ((n3 += segment.limit - segment.pos) > n2) {
                n3 = n2;
            }
            this.directory[n4] = n3;
            this.directory[n4 + this.segments.length] = segment.pos;
            segment.shared = true;
            ++n4;
            segment = segment.next;
        }
    }

    @Override
    public String utf8() {
        return this.toByteString().utf8();
    }

    @Override
    public String string(Charset charset) {
        return this.toByteString().string(charset);
    }

    @Override
    public String base64() {
        return this.toByteString().base64();
    }

    @Override
    public String hex() {
        return this.toByteString().hex();
    }

    @Override
    public ByteString toAsciiLowercase() {
        return this.toByteString().toAsciiLowercase();
    }

    @Override
    public ByteString toAsciiUppercase() {
        return this.toByteString().toAsciiUppercase();
    }

    @Override
    public ByteString md5() {
        return this.toByteString().md5();
    }

    @Override
    public ByteString sha1() {
        return this.toByteString().sha1();
    }

    @Override
    public ByteString sha256() {
        return this.toByteString().sha256();
    }

    @Override
    public ByteString hmacSha1(ByteString byteString) {
        return this.toByteString().hmacSha1(byteString);
    }

    @Override
    public ByteString hmacSha256(ByteString byteString) {
        return this.toByteString().hmacSha256(byteString);
    }

    @Override
    public String base64Url() {
        return this.toByteString().base64Url();
    }

    @Override
    public ByteString substring(int n2) {
        return this.toByteString().substring(n2);
    }

    @Override
    public ByteString substring(int n2, int n3) {
        return this.toByteString().substring(n2, n3);
    }

    @Override
    public byte getByte(int n2) {
        Util.checkOffsetAndCount(this.directory[this.segments.length - 1], n2, 1L);
        int n3 = this.segment(n2);
        int n4 = n3 == 0 ? 0 : this.directory[n3 - 1];
        int n5 = this.directory[n3 + this.segments.length];
        return this.segments[n3][n2 - n4 + n5];
    }

    private int segment(int n2) {
        int n3 = Arrays.binarySearch(this.directory, 0, this.segments.length, n2 + 1);
        return n3 >= 0 ? n3 : ~n3;
    }

    @Override
    public int size() {
        return this.directory[this.segments.length - 1];
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = new byte[this.directory[this.segments.length - 1]];
        int n2 = 0;
        int n3 = this.segments.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.directory[n3 + i2];
            int n5 = this.directory[i2];
            System.arraycopy(this.segments[i2], n4, byArray, n2, n5 - n2);
            n2 = n5;
        }
        return byArray;
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.toByteArray()).asReadOnlyBuffer();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("out == null");
        }
        int n2 = 0;
        int n3 = this.segments.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.directory[n3 + i2];
            int n5 = this.directory[i2];
            outputStream.write(this.segments[i2], n4, n5 - n2);
            n2 = n5;
        }
    }

    @Override
    void write(Buffer buffer) {
        int n2 = 0;
        int n3 = this.segments.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.directory[n3 + i2];
            int n5 = this.directory[i2];
            Segment segment = new Segment(this.segments[i2], n4, n4 + n5 - n2, true, false);
            if (buffer.head == null) {
                segment.next = segment.prev = segment;
                buffer.head = segment.prev;
            } else {
                buffer.head.prev.push(segment);
            }
            n2 = n5;
        }
        buffer.size += (long)n2;
    }

    @Override
    public boolean rangeEquals(int n2, ByteString byteString, int n3, int n4) {
        if (n2 < 0 || n2 > this.size() - n4) {
            return false;
        }
        int n5 = this.segment(n2);
        while (n4 > 0) {
            int n6;
            int n7;
            int n8;
            int n9 = n5 == 0 ? 0 : this.directory[n5 - 1];
            int n10 = n2 - n9 + (n8 = this.directory[this.segments.length + n5]);
            if (!byteString.rangeEquals(n3, this.segments[n5], n10, n7 = Math.min(n4, n9 + (n6 = this.directory[n5] - n9) - n2))) {
                return false;
            }
            n2 += n7;
            n3 += n7;
            n4 -= n7;
            ++n5;
        }
        return true;
    }

    @Override
    public boolean rangeEquals(int n2, byte[] byArray, int n3, int n4) {
        if (n2 < 0 || n2 > this.size() - n4 || n3 < 0 || n3 > byArray.length - n4) {
            return false;
        }
        int n5 = this.segment(n2);
        while (n4 > 0) {
            int n6;
            int n7;
            int n8;
            int n9 = n5 == 0 ? 0 : this.directory[n5 - 1];
            int n10 = n2 - n9 + (n8 = this.directory[this.segments.length + n5]);
            if (!Util.arrayRangeEquals(this.segments[n5], n10, byArray, n3, n7 = Math.min(n4, n9 + (n6 = this.directory[n5] - n9) - n2))) {
                return false;
            }
            n2 += n7;
            n3 += n7;
            n4 -= n7;
            ++n5;
        }
        return true;
    }

    @Override
    public int indexOf(byte[] byArray, int n2) {
        return this.toByteString().indexOf(byArray, n2);
    }

    @Override
    public int lastIndexOf(byte[] byArray, int n2) {
        return this.toByteString().lastIndexOf(byArray, n2);
    }

    private ByteString toByteString() {
        return new ByteString(this.toByteArray());
    }

    @Override
    byte[] internalArray() {
        return this.toByteArray();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof ByteString && ((ByteString)object).size() == this.size() && this.rangeEquals(0, (ByteString)object, 0, this.size());
    }

    @Override
    public int hashCode() {
        int n2 = this.hashCode;
        if (n2 != 0) {
            return n2;
        }
        n2 = 1;
        int n3 = 0;
        int n4 = this.segments.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            byte[] byArray = this.segments[i2];
            int n5 = this.directory[n4 + i2];
            int n6 = this.directory[i2];
            int n7 = n6 - n3;
            int n8 = n5 + n7;
            for (int i3 = n5; i3 < n8; ++i3) {
                n2 = 31 * n2 + byArray[i3];
            }
            n3 = n6;
        }
        this.hashCode = n2;
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toByteString().toString();
    }

    private Object writeReplace() {
        return this.toByteString();
    }
}

