/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.IOException;
import java.net.ProtocolException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.StreamAllocation;
import okhttp3.internal.http.HttpCodec;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    public CallServerInterceptor(boolean bl2) {
        this.forWebSocket = bl2;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        int n2;
        RealInterceptorChain realInterceptorChain = (RealInterceptorChain)chain;
        HttpCodec httpCodec = realInterceptorChain.httpStream();
        StreamAllocation streamAllocation = realInterceptorChain.streamAllocation();
        RealConnection realConnection = (RealConnection)realInterceptorChain.connection();
        Request request = realInterceptorChain.request();
        long l2 = System.currentTimeMillis();
        realInterceptorChain.eventListener().requestHeadersStart(realInterceptorChain.call());
        httpCodec.writeRequestHeaders(request);
        realInterceptorChain.eventListener().requestHeadersEnd(realInterceptorChain.call(), request);
        Response.Builder builder = null;
        if (HttpMethod.permitsRequestBody(request.method()) && request.body() != null) {
            if ("100-continue".equalsIgnoreCase(request.header("Expect"))) {
                httpCodec.flushRequest();
                realInterceptorChain.eventListener().responseHeadersStart(realInterceptorChain.call());
                builder = httpCodec.readResponseHeaders(true);
            }
            if (builder == null) {
                realInterceptorChain.eventListener().requestBodyStart(realInterceptorChain.call());
                long l3 = request.body().contentLength();
                CountingSink countingSink = new CountingSink(httpCodec.createRequestBody(request, l3));
                BufferedSink bufferedSink = Okio.buffer(countingSink);
                request.body().writeTo(bufferedSink);
                bufferedSink.close();
                realInterceptorChain.eventListener().requestBodyEnd(realInterceptorChain.call(), countingSink.successfulCount);
            } else if (!realConnection.isMultiplexed()) {
                streamAllocation.noNewStreams();
            }
        }
        httpCodec.finishRequest();
        if (builder == null) {
            realInterceptorChain.eventListener().responseHeadersStart(realInterceptorChain.call());
            builder = httpCodec.readResponseHeaders(false);
        }
        if ((n2 = (response = builder.request(request).handshake(streamAllocation.connection().handshake()).sentRequestAtMillis(l2).receivedResponseAtMillis(System.currentTimeMillis()).build()).code()) == 100) {
            builder = httpCodec.readResponseHeaders(false);
            response = builder.request(request).handshake(streamAllocation.connection().handshake()).sentRequestAtMillis(l2).receivedResponseAtMillis(System.currentTimeMillis()).build();
            n2 = response.code();
        }
        realInterceptorChain.eventListener().responseHeadersEnd(realInterceptorChain.call(), response);
        response = this.forWebSocket && n2 == 101 ? response.newBuilder().body(Util.EMPTY_RESPONSE).build() : response.newBuilder().body(httpCodec.openResponseBody(response)).build();
        if ("close".equalsIgnoreCase(response.request().header("Connection")) || "close".equalsIgnoreCase(response.header("Connection"))) {
            streamAllocation.noNewStreams();
        }
        if ((n2 == 204 || n2 == 205) && response.body().contentLength() > 0L) {
            throw new ProtocolException("HTTP " + n2 + " had non-zero Content-Length: " + response.body().contentLength());
        }
        return response;
    }

    static final class CountingSink
    extends ForwardingSink {
        long successfulCount;

        CountingSink(Sink sink) {
            super(sink);
        }

        @Override
        public void write(Buffer buffer, long l2) throws IOException {
            super.write(buffer, l2);
            this.successfulCount += l2;
        }
    }
}

