/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final ResponseBody EMPTY_RESPONSE = ResponseBody.create(null, EMPTY_BYTE_ARRAY);
    public static final RequestBody EMPTY_REQUEST = RequestBody.create(null, EMPTY_BYTE_ARRAY);
    private static final ByteString UTF_8_BOM = ByteString.decodeHex("efbbbf");
    private static final ByteString UTF_16_BE_BOM = ByteString.decodeHex("feff");
    private static final ByteString UTF_16_LE_BOM = ByteString.decodeHex("fffe");
    private static final ByteString UTF_32_BE_BOM = ByteString.decodeHex("0000ffff");
    private static final ByteString UTF_32_LE_BOM = ByteString.decodeHex("ffff0000");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final Charset UTF_16_BE = Charset.forName("UTF-16BE");
    private static final Charset UTF_16_LE = Charset.forName("UTF-16LE");
    private static final Charset UTF_32_BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32_LE = Charset.forName("UTF-32LE");
    public static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    public static final Comparator<String> NATURAL_ORDER = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return string.compareTo(string2);
        }
    };
    private static final Pattern VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    private Util() {
    }

    public static void checkOffsetAndCount(long l2, long l3, long l4) {
        if ((l3 | l4) < 0L || l3 > l2 || l2 - l3 < l4) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (AssertionError assertionError) {
                if (!Util.isAndroidGetsocknameError(assertionError)) {
                    throw assertionError;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean discard(Source source, int n2, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, n2, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean skipAll(Source source, int n2, TimeUnit timeUnit) throws IOException {
        long l2 = System.nanoTime();
        long l3 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l2 : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(l2 + Math.min(l3, timeUnit.toNanos(n2)));
        try {
            Buffer buffer = new Buffer();
            while (source.read(buffer, 8192L) != -1L) {
                buffer.clear();
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (InterruptedIOException interruptedIOException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (l3 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(l2 + l3);
            }
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static ThreadFactory threadFactory(final String string, final boolean bl2) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, string);
                thread.setDaemon(bl2);
                return thread;
            }
        };
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (comparator.compare(string, string2) != 0) continue;
                arrayList.add(string);
                continue block0;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length == 0 || stringArray2.length == 0) {
            return false;
        }
        for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (comparator.compare(string, string2) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl2) {
        String string = httpUrl.host().contains(":") ? "[" + httpUrl.host() + "]" : httpUrl.host();
        return bl2 || httpUrl.port() != HttpUrl.defaultPort(httpUrl.scheme()) ? string + ":" + httpUrl.port() : string;
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }

    public static int indexOf(Comparator<String> comparator, String[] stringArray, String string) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (comparator.compare(stringArray[i2], string) != 0) continue;
            return i2;
        }
        return -1;
    }

    public static String[] concat(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray2.length - 1] = string;
        return stringArray2;
    }

    public static int skipLeadingAsciiWhitespace(String string, int n2, int n3) {
        block3: for (int i2 = n2; i2 < n3; ++i2) {
            switch (string.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i2;
                }
            }
        }
        return n3;
    }

    public static int skipTrailingAsciiWhitespace(String string, int n2, int n3) {
        block3: for (int i2 = n3 - 1; i2 >= n2; --i2) {
            switch (string.charAt(i2)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i2 + 1;
                }
            }
        }
        return n2;
    }

    public static String trimSubstring(String string, int n2, int n3) {
        int n4 = Util.skipLeadingAsciiWhitespace(string, n2, n3);
        int n5 = Util.skipTrailingAsciiWhitespace(string, n4, n3);
        return string.substring(n4, n5);
    }

    public static int delimiterOffset(String string, int n2, int n3, String string2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (string2.indexOf(string.charAt(i2)) == -1) continue;
            return i2;
        }
        return n3;
    }

    public static int delimiterOffset(String string, int n2, int n3, char c2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (string.charAt(i2) != c2) continue;
            return i2;
        }
        return n3;
    }

    public static String canonicalizeHost(String string) {
        if (string.contains(":")) {
            InetAddress inetAddress;
            InetAddress inetAddress2 = inetAddress = string.startsWith("[") && string.endsWith("]") ? Util.decodeIpv6(string, 1, string.length() - 1) : Util.decodeIpv6(string, 0, string.length());
            if (inetAddress == null) {
                return null;
            }
            byte[] byArray = inetAddress.getAddress();
            if (byArray.length == 16) {
                return Util.inet6AddressToAscii(byArray);
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + string + "'"));
        }
        try {
            String string2 = IDN.toASCII(string).toLowerCase(Locale.US);
            if (string2.isEmpty()) {
                return null;
            }
            if (Util.containsInvalidHostnameAsciiCodes(string2)) {
                return null;
            }
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static boolean containsInvalidHostnameAsciiCodes(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u001f' || c2 >= '\u007f') {
                return true;
            }
            if (" #%/:?@[\\]".indexOf(c2) == -1) continue;
            return true;
        }
        return false;
    }

    public static int indexOfControlOrNonAscii(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u001f' && c2 < '\u007f') continue;
            return i2;
        }
        return -1;
    }

    public static boolean verifyAsIpAddress(String string) {
        return VERIFY_AS_IP_ADDRESS.matcher(string).matches();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        if (bufferedSource.rangeEquals(0L, UTF_8_BOM)) {
            bufferedSource.skip(UTF_8_BOM.size());
            return UTF_8;
        }
        if (bufferedSource.rangeEquals(0L, UTF_16_BE_BOM)) {
            bufferedSource.skip(UTF_16_BE_BOM.size());
            return UTF_16_BE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_16_LE_BOM)) {
            bufferedSource.skip(UTF_16_LE_BOM.size());
            return UTF_16_LE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_32_BE_BOM)) {
            bufferedSource.skip(UTF_32_BE_BOM.size());
            return UTF_32_BE;
        }
        if (bufferedSource.rangeEquals(0L, UTF_32_LE_BOM)) {
            bufferedSource.skip(UTF_32_LE_BOM.size());
            return UTF_32_LE;
        }
        return charset;
    }

    public static int checkDuration(String string, long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + " < 0");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit == null");
        }
        long l3 = timeUnit.toMillis(l2);
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(string + " too large.");
        }
        if (l3 == 0L && l2 > 0L) {
            throw new IllegalArgumentException(string + " too small.");
        }
        return (int)l3;
    }

    public static AssertionError assertionError(String string, Exception exception) {
        AssertionError assertionError = new AssertionError((Object)string);
        try {
            ((Throwable)((Object)assertionError)).initCause(exception);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return assertionError;
    }

    public static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    @Nullable
    private static InetAddress decodeIpv6(String string, int n2, int n3) {
        byte[] byArray = new byte[16];
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = n2;
        while (n7 < n3) {
            char c2;
            int n8;
            if (n4 == byArray.length) {
                return null;
            }
            if (n7 + 2 <= n3 && string.regionMatches(n7, "::", 0, 2)) {
                if (n5 != -1) {
                    return null;
                }
                n5 = n4 += 2;
                if ((n7 += 2) == n3) {
                    break;
                }
            } else if (n4 != 0 && !string.regionMatches(n7, ":", 0, 1)) {
                if (string.regionMatches(n7, ".", 0, 1)) {
                    if (!Util.decodeIpv4Suffix(string, n6, n3, byArray, n4 - 2)) {
                        return null;
                    }
                    n4 += 2;
                    break;
                }
                return null;
            }
            int n9 = 0;
            n6 = ++n7;
            while (n7 < n3 && (n8 = Util.decodeHexDigit(c2 = string.charAt(n7))) != -1) {
                n9 = (n9 << 4) + n8;
                ++n7;
            }
            c2 = n7 - n6;
            if (c2 == '\u0000' || c2 > '\u0004') {
                return null;
            }
            byArray[n4++] = (byte)(n9 >>> 8 & 0xFF);
            byArray[n4++] = (byte)(n9 & 0xFF);
        }
        if (n4 != byArray.length) {
            if (n5 == -1) {
                return null;
            }
            System.arraycopy(byArray, n5, byArray, byArray.length - (n4 - n5), n4 - n5);
            Arrays.fill(byArray, n5, n5 + (byArray.length - n4), (byte)0);
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    private static boolean decodeIpv4Suffix(String string, int n2, int n3, byte[] byArray, int n4) {
        int n5 = n4;
        int n6 = n2;
        while (n6 < n3) {
            int n7;
            if (n5 == byArray.length) {
                return false;
            }
            if (n5 != n4 && string.charAt(n6) != '.') {
                return false;
            }
            int n8 = 0;
            int n9 = ++n6;
            while (n6 < n3 && (n7 = string.charAt(n6)) >= 48 && n7 <= 57) {
                if (n8 == 0 && n9 != n6) {
                    return false;
                }
                if ((n8 = n8 * 10 + n7 - 48) > 255) {
                    return false;
                }
                ++n6;
            }
            n7 = n6 - n9;
            if (n7 == 0) {
                return false;
            }
            byArray[n5++] = (byte)n8;
        }
        return n5 == n4 + 4;
    }

    private static String inet6AddressToAscii(byte[] byArray) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += 2) {
            n3 = i2;
            while (i2 < 16 && byArray[i2] == 0 && byArray[i2 + 1] == 0) {
                i2 += 2;
            }
            n2 = i2 - n3;
            if (n2 <= n5 || n2 < 4) continue;
            n4 = n3;
            n5 = n2;
        }
        Buffer buffer = new Buffer();
        n3 = 0;
        while (n3 < byArray.length) {
            if (n3 == n4) {
                buffer.writeByte(58);
                if ((n3 += n5) != 16) continue;
                buffer.writeByte(58);
                continue;
            }
            if (n3 > 0) {
                buffer.writeByte(58);
            }
            n2 = (byArray[n3] & 0xFF) << 8 | byArray[n3 + 1] & 0xFF;
            buffer.writeHexadecimalUnsignedLong(n2);
            n3 += 2;
        }
        return buffer.readUtf8();
    }
}

