/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;

public final class Request {
    final HttpUrl url;
    final String method;
    final Headers headers;
    @Nullable
    final RequestBody body;
    final Object tag;
    private volatile CacheControl cacheControl;

    Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.tag = builder.tag != null ? builder.tag : this;
    }

    public HttpUrl url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public Headers headers() {
        return this.headers;
    }

    @Nullable
    public String header(String string) {
        return this.headers.get(string);
    }

    public List<String> headers(String string) {
        return this.headers.values(string);
    }

    @Nullable
    public RequestBody body() {
        return this.body;
    }

    public Object tag() {
        return this.tag;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        return cacheControl != null ? cacheControl : (this.cacheControl = CacheControl.parse(this.headers));
    }

    public boolean isHttps() {
        return this.url.isHttps();
    }

    public String toString() {
        return "Request{method=" + this.method + ", url=" + this.url + ", tag=" + (this.tag != this ? this.tag : null) + '}';
    }

    public static class Builder {
        HttpUrl url;
        String method;
        Headers.Builder headers;
        RequestBody body;
        Object tag;

        public Builder() {
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.body = request.body;
            this.tag = request.tag;
            this.headers = request.headers.newBuilder();
        }

        public Builder url(HttpUrl httpUrl) {
            if (httpUrl == null) {
                throw new NullPointerException("url == null");
            }
            this.url = httpUrl;
            return this;
        }

        public Builder url(String string) {
            if (string == null) {
                throw new NullPointerException("url == null");
            }
            if (string.regionMatches(true, 0, "ws:", 0, 3)) {
                string = "http:" + string.substring(3);
            } else if (string.regionMatches(true, 0, "wss:", 0, 4)) {
                string = "https:" + string.substring(4);
            }
            HttpUrl httpUrl = HttpUrl.parse(string);
            if (httpUrl == null) {
                throw new IllegalArgumentException("unexpected url: " + string);
            }
            return this.url(httpUrl);
        }

        public Builder url(URL uRL) {
            if (uRL == null) {
                throw new NullPointerException("url == null");
            }
            HttpUrl httpUrl = HttpUrl.get(uRL);
            if (httpUrl == null) {
                throw new IllegalArgumentException("unexpected url: " + uRL);
            }
            return this.url(httpUrl);
        }

        public Builder header(String string, String string2) {
            this.headers.set(string, string2);
            return this;
        }

        public Builder addHeader(String string, String string2) {
            this.headers.add(string, string2);
            return this;
        }

        public Builder removeHeader(String string) {
            this.headers.removeAll(string);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder cacheControl(CacheControl cacheControl) {
            String string = cacheControl.toString();
            if (string.isEmpty()) {
                return this.removeHeader("Cache-Control");
            }
            return this.header("Cache-Control", string);
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder post(RequestBody requestBody) {
            return this.method("POST", requestBody);
        }

        public Builder delete(@Nullable RequestBody requestBody) {
            return this.method("DELETE", requestBody);
        }

        public Builder delete() {
            return this.delete(Util.EMPTY_REQUEST);
        }

        public Builder put(RequestBody requestBody) {
            return this.method("PUT", requestBody);
        }

        public Builder patch(RequestBody requestBody) {
            return this.method("PATCH", requestBody);
        }

        public Builder method(String string, @Nullable RequestBody requestBody) {
            if (string == null) {
                throw new NullPointerException("method == null");
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("method.length() == 0");
            }
            if (requestBody != null && !HttpMethod.permitsRequestBody(string)) {
                throw new IllegalArgumentException("method " + string + " must not have a request body.");
            }
            if (requestBody == null && HttpMethod.requiresRequestBody(string)) {
                throw new IllegalArgumentException("method " + string + " must have a request body.");
            }
            this.method = string;
            this.body = requestBody;
            return this;
        }

        public Builder tag(Object object) {
            this.tag = object;
            return this;
        }

        public Request build() {
            if (this.url == null) {
                throw new IllegalStateException("url == null");
            }
            return new Request(this);
        }
    }
}

