/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.annotations.EverythingIsNonNull;

@EverythingIsNonNull
public final class JavaNetAuthenticator
implements Authenticator {
    @Override
    public Request authenticate(Route route, Response response) throws IOException {
        List<Challenge> list = response.challenges();
        Request request = response.request();
        HttpUrl httpUrl = request.url();
        boolean bl2 = response.code() == 407;
        Proxy proxy = route.proxy();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            PasswordAuthentication passwordAuthentication;
            Object object;
            Challenge challenge = list.get(i2);
            if (!"Basic".equalsIgnoreCase(challenge.scheme())) continue;
            if (bl2) {
                object = (InetSocketAddress)proxy.address();
                passwordAuthentication = java.net.Authenticator.requestPasswordAuthentication(((InetSocketAddress)object).getHostName(), this.getConnectToInetAddress(proxy, httpUrl), ((InetSocketAddress)object).getPort(), httpUrl.scheme(), challenge.realm(), challenge.scheme(), httpUrl.url(), Authenticator.RequestorType.PROXY);
            } else {
                passwordAuthentication = java.net.Authenticator.requestPasswordAuthentication(httpUrl.host(), this.getConnectToInetAddress(proxy, httpUrl), httpUrl.port(), httpUrl.scheme(), challenge.realm(), challenge.scheme(), httpUrl.url(), Authenticator.RequestorType.SERVER);
            }
            if (passwordAuthentication == null) continue;
            object = Credentials.basic(passwordAuthentication.getUserName(), new String(passwordAuthentication.getPassword()), challenge.charset());
            return request.newBuilder().header(bl2 ? "Proxy-Authorization" : "Authorization", (String)object).build();
        }
        return null;
    }

    private InetAddress getConnectToInetAddress(Proxy proxy, HttpUrl httpUrl) throws IOException {
        return proxy.type() != Proxy.Type.DIRECT ? ((InetSocketAddress)proxy.address()).getAddress() : InetAddress.getByName(httpUrl.host());
    }
}

