/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocket;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;

public final class ConnectionSpec {
    private static final CipherSuite[] APPROVED_CIPHER_SUITES = new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA, CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA, CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA};
    public static final ConnectionSpec MODERN_TLS = new Builder(true).cipherSuites(APPROVED_CIPHER_SUITES).tlsVersions(TlsVersion.TLS_1_3, TlsVersion.TLS_1_2, TlsVersion.TLS_1_1, TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
    public static final ConnectionSpec COMPATIBLE_TLS = new Builder(MODERN_TLS).tlsVersions(TlsVersion.TLS_1_0).supportsTlsExtensions(true).build();
    public static final ConnectionSpec CLEARTEXT = new Builder(false).build();
    final boolean tls;
    final boolean supportsTlsExtensions;
    @Nullable
    final String[] cipherSuites;
    @Nullable
    final String[] tlsVersions;

    ConnectionSpec(Builder builder) {
        this.tls = builder.tls;
        this.cipherSuites = builder.cipherSuites;
        this.tlsVersions = builder.tlsVersions;
        this.supportsTlsExtensions = builder.supportsTlsExtensions;
    }

    public boolean isTls() {
        return this.tls;
    }

    @Nullable
    public List<CipherSuite> cipherSuites() {
        return this.cipherSuites != null ? CipherSuite.forJavaNames(this.cipherSuites) : null;
    }

    @Nullable
    public List<TlsVersion> tlsVersions() {
        return this.tlsVersions != null ? TlsVersion.forJavaNames(this.tlsVersions) : null;
    }

    public boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    void apply(SSLSocket sSLSocket, boolean bl2) {
        ConnectionSpec connectionSpec = this.supportedSpec(sSLSocket, bl2);
        if (connectionSpec.tlsVersions != null) {
            sSLSocket.setEnabledProtocols(connectionSpec.tlsVersions);
        }
        if (connectionSpec.cipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(connectionSpec.cipherSuites);
        }
    }

    private ConnectionSpec supportedSpec(SSLSocket sSLSocket, boolean bl2) {
        String[] stringArray = this.cipherSuites != null ? Util.intersect(CipherSuite.ORDER_BY_NAME, sSLSocket.getEnabledCipherSuites(), this.cipherSuites) : sSLSocket.getEnabledCipherSuites();
        String[] stringArray2 = this.tlsVersions != null ? Util.intersect(Util.NATURAL_ORDER, sSLSocket.getEnabledProtocols(), this.tlsVersions) : sSLSocket.getEnabledProtocols();
        String[] stringArray3 = sSLSocket.getSupportedCipherSuites();
        int n2 = Util.indexOf(CipherSuite.ORDER_BY_NAME, stringArray3, "TLS_FALLBACK_SCSV");
        if (bl2 && n2 != -1) {
            stringArray = Util.concat(stringArray, stringArray3[n2]);
        }
        return new Builder(this).cipherSuites(stringArray).tlsVersions(stringArray2).build();
    }

    public boolean isCompatible(SSLSocket sSLSocket) {
        if (!this.tls) {
            return false;
        }
        if (this.tlsVersions != null && !Util.nonEmptyIntersection(Util.NATURAL_ORDER, this.tlsVersions, sSLSocket.getEnabledProtocols())) {
            return false;
        }
        return this.cipherSuites == null || Util.nonEmptyIntersection(CipherSuite.ORDER_BY_NAME, this.cipherSuites, sSLSocket.getEnabledCipherSuites());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof ConnectionSpec)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ConnectionSpec connectionSpec = (ConnectionSpec)object;
        if (this.tls != connectionSpec.tls) {
            return false;
        }
        if (this.tls) {
            if (!Arrays.equals(this.cipherSuites, connectionSpec.cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersions, connectionSpec.tlsVersions)) {
                return false;
            }
            if (this.supportsTlsExtensions != connectionSpec.supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = 17;
        if (this.tls) {
            n2 = 31 * n2 + Arrays.hashCode(this.cipherSuites);
            n2 = 31 * n2 + Arrays.hashCode(this.tlsVersions);
            n2 = 31 * n2 + (this.supportsTlsExtensions ? 0 : 1);
        }
        return n2;
    }

    public String toString() {
        if (!this.tls) {
            return "ConnectionSpec()";
        }
        String string = this.cipherSuites != null ? this.cipherSuites().toString() : "[all enabled]";
        String string2 = this.tlsVersions != null ? this.tlsVersions().toString() : "[all enabled]";
        return "ConnectionSpec(cipherSuites=" + string + ", tlsVersions=" + string2 + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ")";
    }

    public static final class Builder {
        boolean tls;
        @Nullable
        String[] cipherSuites;
        @Nullable
        String[] tlsVersions;
        boolean supportsTlsExtensions;

        Builder(boolean bl2) {
            this.tls = bl2;
        }

        public Builder(ConnectionSpec connectionSpec) {
            this.tls = connectionSpec.tls;
            this.cipherSuites = connectionSpec.cipherSuites;
            this.tlsVersions = connectionSpec.tlsVersions;
            this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
        }

        public Builder allEnabledCipherSuites() {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            this.cipherSuites = null;
            return this;
        }

        public Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            String[] stringArray = new String[cipherSuiteArray.length];
            for (int i2 = 0; i2 < cipherSuiteArray.length; ++i2) {
                stringArray[i2] = cipherSuiteArray[i2].javaName;
            }
            return this.cipherSuites(stringArray);
        }

        public Builder cipherSuites(String ... stringArray) {
            if (!this.tls) {
                throw new IllegalStateException("no cipher suites for cleartext connections");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one cipher suite is required");
            }
            this.cipherSuites = (String[])stringArray.clone();
            return this;
        }

        public Builder allEnabledTlsVersions() {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            this.tlsVersions = null;
            return this;
        }

        public Builder tlsVersions(TlsVersion ... tlsVersionArray) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            String[] stringArray = new String[tlsVersionArray.length];
            for (int i2 = 0; i2 < tlsVersionArray.length; ++i2) {
                stringArray[i2] = tlsVersionArray[i2].javaName;
            }
            return this.tlsVersions(stringArray);
        }

        public Builder tlsVersions(String ... stringArray) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS versions for cleartext connections");
            }
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("At least one TLS version is required");
            }
            this.tlsVersions = (String[])stringArray.clone();
            return this;
        }

        public Builder supportsTlsExtensions(boolean bl2) {
            if (!this.tls) {
                throw new IllegalStateException("no TLS extensions for cleartext connections");
            }
            this.supportsTlsExtensions = bl2;
            return this;
        }

        public ConnectionSpec build() {
            return new ConnectionSpec(this);
        }
    }
}

