/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.storage;

import io.fair_acc.math.storage.VoxelArrayND;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class DoubleStorageND
implements VoxelArrayND {
    private int fndimIn;
    private int fdimOut;
    private int[] flength;
    private double[][] fdata;

    public DoubleStorageND(DoubleStorageND doubleStorageND) {
        int n2;
        this.fndimIn = doubleStorageND.fndimIn;
        this.fdimOut = doubleStorageND.fdimOut;
        this.flength = Arrays.copyOf(doubleStorageND.flength, doubleStorageND.flength.length);
        int n3 = 1;
        for (n2 = 0; n2 < this.fndimIn; ++n2) {
            n3 *= this.flength[n2];
        }
        this.fdata = new double[n3][this.fdimOut];
        for (n2 = 0; n2 < n3; ++n2) {
            this.fdata[n2] = Arrays.copyOf(doubleStorageND.fdata[n2], doubleStorageND.fdata[n2].length);
        }
    }

    public DoubleStorageND(int[] nArray, int n2) {
        this.fndimIn = nArray.length;
        this.fdimOut = n2;
        this.flength = Arrays.copyOf(nArray, nArray.length);
        int n3 = 1;
        for (int i2 = 0; i2 < this.fndimIn; ++i2) {
            n3 *= this.flength[i2];
        }
        this.fdata = new double[n3][this.fdimOut];
    }

    @Override
    public VoxelArrayND copy() {
        return new DoubleStorageND(this);
    }

    @Override
    public double[] get(int[] nArray) {
        int n2 = this.getLocalIndex(nArray);
        return this.fdata[n2];
    }

    @Override
    public int[] getInverseLocalIndex(int n2) {
        int n3 = n2;
        int[] nArray = new int[this.fndimIn];
        for (int i2 = 0; i2 < this.fndimIn; ++i2) {
            int n4 = 1;
            for (int i3 = i2; i3 < this.fndimIn - 1; ++i3) {
                n4 *= this.flength[i3 + 1];
            }
            nArray[i2] = n3 / n4;
            n3 -= nArray[i2] * n4;
        }
        return nArray;
    }

    @Override
    public double[] getLocal(int n2) {
        return this.fdata[n2];
    }

    @Override
    public int getLocalIndex(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fndimIn; ++i2) {
            int n3 = 1;
            for (int i3 = i2; i3 < this.fndimIn - 1; ++i3) {
                n3 *= this.flength[i3 + 1];
            }
            n2 += n3 * nArray[i2];
        }
        return n2;
    }

    @Override
    public int getLocalStorageDim() {
        return this.fdata.length;
    }

    @Override
    public int getValueDimension() {
        return this.fdimOut;
    }

    @Override
    public void initialiseWithValue(double d2) {
        for (int i2 = 0; i2 < this.fdata.length; ++i2) {
            Arrays.fill(this.fdata[i2], d2);
        }
    }

    @Override
    public void set(int[] nArray, double[] dArray) {
        if (dArray.length != this.fdimOut) {
            throw new InvalidParameterException("invalid value dimension " + dArray.length);
        }
        int n2 = this.getLocalIndex(nArray);
        this.fdata[n2] = dArray;
    }

    @Override
    public void setLocal(int n2, double[] dArray) {
        this.fdata[n2] = dArray;
    }

    public static void main(String[] stringArray) {
        int n2;
        DoubleStorageND doubleStorageND = new DoubleStorageND(new int[]{3, 5}, 10);
        for (int i2 = 0; i2 < 3; ++i2) {
            n2 = 0;
            while (n2 < 5) {
                System.out.printf("1:tupple index (%d,%d) mapped to %d\n", i2, n2, doubleStorageND.getLocalIndex(new int[]{i2, n2++}));
            }
        }
        DoubleStorageND doubleStorageND2 = new DoubleStorageND(new int[]{3, 5, 2}, 10);
        for (n2 = 0; n2 < 3; ++n2) {
            for (int i3 = 0; i3 < 5; ++i3) {
                int n3 = 0;
                while (n3 < 2) {
                    System.out.printf("2:tupple index (%d,%d,%d) mapped to %d\n", n2, i3, n3, doubleStorageND2.getLocalIndex(new int[]{n2, i3, n3++}));
                }
            }
        }
        System.out.println();
        for (n2 = 0; n2 < doubleStorageND2.getLocalStorageDim(); ++n2) {
            int[] nArray = doubleStorageND2.getInverseLocalIndex(n2);
            System.out.printf("2:inverse tupple index %3d mapped to (%d,%d,%d)\n", n2, nArray[0], nArray[1], nArray[2]);
        }
    }
}

