/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.wavelet;

import io.fair_acc.math.spectra.wavelet.Lift;

public class MyWavelet
extends Lift {
    static final double sqrt3 = Math.sqrt(3.0);
    static final double sqrt2 = Math.sqrt(2.0);

    @Override
    public void forwardTrans(double[] dArray) {
        int n2;
        for (int i2 = n2 = dArray.length; i2 > 1; i2 >>= 1) {
            this.split(dArray, i2);
            this.updateOne(dArray, i2, Lift.Direction.forward);
            this.predict(dArray, i2, Lift.Direction.forward);
            this.update(dArray, i2, Lift.Direction.forward);
            this.normalize(dArray, i2, Lift.Direction.forward);
        }
    }

    @Override
    public void inverseTrans(double[] dArray) {
        int n2 = dArray.length;
        for (int i2 = 2; i2 <= n2; i2 <<= 1) {
            this.normalize(dArray, i2, Lift.Direction.inverse);
            this.update(dArray, i2, Lift.Direction.inverse);
            this.predict(dArray, i2, Lift.Direction.inverse);
            this.updateOne(dArray, i2, Lift.Direction.inverse);
            this.merge(dArray, i2);
        }
    }

    protected void normalize(double[] dArray, int n2, Lift.Direction direction) {
        int n3 = n2 >> 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (direction == Lift.Direction.forward) {
                dArray[i2] = (sqrt3 - 1.0) / sqrt2 * dArray[i2];
                dArray[i2 + n3] = (sqrt3 + 1.0) / sqrt2 * dArray[i2 + n3];
                continue;
            }
            dArray[i2] = (sqrt3 + 1.0) / sqrt2 * dArray[i2];
            dArray[i2 + n3] = (sqrt3 - 1.0) / sqrt2 * dArray[i2 + n3];
        }
    }

    @Override
    protected void predict(double[] dArray, int n2, Lift.Direction direction) {
        int n3 = n2 >> 1;
        dArray[n3] = direction == Lift.Direction.forward ? dArray[n3] - sqrt3 / 4.0 * dArray[0] - (sqrt3 - 2.0) / 4.0 * dArray[n3 - 1] : dArray[n3] + sqrt3 / 4.0 * dArray[0] + (sqrt3 - 2.0) / 4.0 * dArray[n3 - 1];
        for (int i2 = 1; i2 < n3; ++i2) {
            dArray[n3 + i2] = direction == Lift.Direction.forward ? dArray[n3 + i2] - sqrt3 / 4.0 * dArray[i2] - (sqrt3 - 2.0) / 4.0 * dArray[i2 - 1] : dArray[n3 + i2] + sqrt3 / 4.0 * dArray[i2] + (sqrt3 - 2.0) / 4.0 * dArray[i2 - 1];
        }
    }

    @Override
    protected void update(double[] dArray, int n2, Lift.Direction direction) {
        int n3 = n2 >> 1;
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            dArray[i2] = direction == Lift.Direction.forward ? dArray[i2] - dArray[n3 + i2 + 1] : dArray[i2] + dArray[n3 + i2 + 1];
        }
        dArray[n3 - 1] = direction == Lift.Direction.forward ? dArray[n3 - 1] - dArray[n3] : dArray[n3 - 1] + dArray[n3];
    }

    protected void updateOne(double[] dArray, int n2, Lift.Direction direction) {
        int n3 = n2 >> 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            double d2 = sqrt3 * dArray[n3 + i2];
            dArray[i2] = direction == Lift.Direction.forward ? dArray[i2] + d2 : dArray[i2] - d2;
        }
    }
}

