/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra.dtft;

import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DiscreteTimeFourierTransform {
    protected int START_THREADS = 128;
    protected boolean DEBUG = false;

    public double[] computeFrequencyRange(double[] dArray) {
        double d2 = Math.maximum(dArray) - Math.minimum(dArray);
        double d3 = Double.MAX_VALUE;
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            double d4 = MathBase.abs(dArray[i2] - dArray[i2 - 1]);
            if (!(d3 > d4) || !(d3 > 0.0)) continue;
            d3 = d4;
        }
        double d5 = 1.0 / d3;
        int n2 = (int)(d2 / d3);
        double[] dArray2 = new double[n2];
        double d6 = 0.5 / (double)n2 * d5;
        for (int i3 = 0; i3 < n2; ++i3) {
            dArray2[i3] = (double)i3 * d6;
        }
        return dArray2;
    }

    public double[] computeMagnitudeSpectrum(double[] dArray, double[] dArray2) {
        return this.computeMagnitudeSpectrum(dArray, dArray2, this.computeFrequencyRange(dArray));
    }

    public double[] computeMagnitudeSpectrum(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = dArray3.length;
        int n3 = dArray.length;
        double[] dArray4 = new double[n2];
        long l2 = System.nanoTime();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && n2 > this.START_THREADS) {
            Future[] futureArray = new Future[n4];
            int n5 = n2 / n4;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n6 = i2 * n5;
                int n7 = i2 == n4 - 1 ? n2 : n6 + n5;
                futureArray[i2] = ConcurrencyUtils.submit(() -> {
                    for (int i2 = n6; i2 < n7; ++i2) {
                        double d2 = java.lang.Math.PI * 2 * dArray3[i2];
                        double d3 = 0.0;
                        double d4 = 0.0;
                        for (int i3 = 0; i3 < n3; ++i3) {
                            d3 += dArray2[i3] * MathBase.cos(d2 * dArray[i3]);
                            d4 += dArray2[i3] * MathBase.sin(d2 * dArray[i3]);
                        }
                        dArray4[i2] = 2.0 * MathBase.sqrt(MathBase.sqr(d3 /= (double)n3) + MathBase.sqr(d4 /= (double)n3));
                    }
                });
            }
        } else {
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i3 = 0; i3 < n2; ++i3) {
                double d4 = java.lang.Math.PI * 2 * dArray3[i3];
                for (int i4 = 0; i4 < dArray.length; ++i4) {
                    d2 += dArray2[i4] * MathBase.cos(d4 * dArray[i4]);
                    d3 += dArray2[i4] * MathBase.sin(d4 * dArray[i4]);
                }
                dArray4[i3] = 2.0 * MathBase.sqrt(MathBase.sqr(d2 /= (double)dArray.length) + MathBase.sqr(d3 /= (double)dArray.length));
            }
        }
        long l3 = System.nanoTime();
        if (this.DEBUG) {
            System.err.printf("computeMagnitudeSpectrum(double[], double[], double[]) - took %f ms\n", (double)(l3 - l2) * 1.0E-6);
        }
        return dArray4;
    }
}

