/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.fitter.NonLinearRegressionFitter;
import io.fair_acc.math.functions.CombFunction;
import io.fair_acc.math.functions.Function1D;
import java.util.Arrays;
import org.jtransforms.fft.DoubleFFT_1D;

public class SpectrumTools {
    public static double[] computeFrequencyScale(int n2) {
        double[] dArray = new double[n2];
        double d2 = 0.5 / (double)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = (double)i2 * d2;
        }
        return dArray;
    }

    public static float[] computeFrequencyScaleFloat(int n2) {
        float[] fArray = new float[n2];
        float f2 = 0.5f / (float)n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = (float)i2 * f2;
        }
        return fArray;
    }

    public static double[] computeMagnitudeSpectrum(double[] dArray) {
        return SpectrumTools.computeMagnitudeSpectrum(dArray, true);
    }

    public static double[] computeMagnitudeSpectrum(double[] dArray, boolean bl2) {
        double[] dArray2 = new double[dArray.length / 2];
        SpectrumTools.computeMagnitudeSpectrum(dArray, 0, dArray.length, dArray2, 0, bl2);
        return dArray2;
    }

    public static void computeMagnitudeSpectrum(double[] dArray, int n2, int n3, double[] dArray2, int n4, boolean bl2) {
        int n5 = n3 / 2;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = i2 + n2 << 1;
            double d2 = dArray[n6];
            double d3 = dArray[n6 + 1];
            dArray2[n4 + i2] = MathBase.sqrt(MathBase.sqr(d2) + MathBase.sqr(d3)) / (double)n5;
        }
        if (bl2) {
            dArray2[n4] = dArray2[n4 + 1];
            dArray2[n4 + n5 - 1] = dArray2[n4 + n5 - 2];
        } else {
            dArray2[n4] = dArray[n2] / (double)n5;
            dArray2[n4 + n5 - 1] = dArray[n2 + 1] / (double)n5;
        }
    }

    public static float[] computeMagnitudeSpectrum(float[] fArray) {
        return SpectrumTools.computeMagnitudeSpectrum(fArray, true);
    }

    public static float[] computeMagnitudeSpectrum(float[] fArray, boolean bl2) {
        float[] fArray2 = new float[fArray.length / 2];
        SpectrumTools.computeMagnitudeSpectrum(fArray, 0, fArray.length, fArray2, 0, bl2);
        return fArray2;
    }

    public static void computeMagnitudeSpectrum(float[] fArray, int n2, int n3, float[] fArray2, int n4, boolean bl2) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = i2 + n2 << 1;
            double d2 = fArray[n5];
            double d3 = fArray[n5 + 1];
            fArray2[i2 + n4] = (float)(MathBase.sqrt(MathBase.sqr(d2) + MathBase.sqr(d3)) / (double)n3);
        }
        if (bl2) {
            fArray2[n4] = fArray2[n4 + 1];
            fArray2[n4 + n3 - 1] = fArray2[n4 + n3 - 2];
        } else {
            fArray2[n4] = fArray[n2] / (float)n3;
            fArray2[n4 + n3 - 1] = fArray[n2 + 1] / (float)n3;
        }
    }

    public static double[] computeMagnitudeSpectrum_dB(double[] dArray, boolean bl2) {
        int n2 = dArray.length / 2;
        double[] dArray2 = new double[n2];
        SpectrumTools.computeMagnitudeSpectrum_dB(dArray, 0, dArray.length, dArray2, 0, bl2);
        return dArray2;
    }

    public static void computeMagnitudeSpectrum_dB(double[] dArray, int n2, int n3, double[] dArray2, int n4, boolean bl2) {
        int n5 = n3 / 2;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = i2 + n2 << 1;
            double d2 = dArray[n6];
            double d3 = dArray[n6 + 1];
            dArray2[i2 + n4] = 10.0 * MathBase.log10(MathBase.sqr(d2 / (double)n5) + MathBase.sqr(d3 / (double)n5));
        }
        if (bl2) {
            dArray2[n4] = dArray2[n4 + 1];
            dArray2[n4 + n5 - 1] = dArray2[n4 + n5 - 2];
        } else {
            dArray2[n4] = dArray[n2];
            dArray2[n4 + n5 - 1] = dArray[n2 + 1];
        }
    }

    public static float[] computeMagnitudeSpectrum_dB(float[] fArray, boolean bl2) {
        float[] fArray2 = new float[fArray.length / 2];
        SpectrumTools.computeMagnitudeSpectrum_dB(fArray, 0, fArray.length, fArray2, 0, bl2);
        return fArray2;
    }

    public static void computeMagnitudeSpectrum_dB(float[] fArray, int n2, int n3, float[] fArray2, int n4, boolean bl2) {
        int n5 = n3 / 2;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = i2 + n2 << 1;
            double d2 = fArray[n6];
            double d3 = fArray[n6 + 1];
            fArray2[n4 + i2] = (float)(10.0 * MathBase.log10((MathBase.sqr(d2) + MathBase.sqr(d3)) / (double)n5));
        }
        if (bl2) {
            fArray2[n4] = fArray2[n4 + 1];
            fArray2[n4 + n5 - 1] = fArray2[n4 + n5 - 2];
        } else {
            fArray2[n4] = fArray[n2];
            fArray2[n4 + n5 - 1] = fArray[n2 + 1];
        }
    }

    public static double[][] computeMaxima(double[] dArray) {
        int n2 = dArray.length;
        double[][] dArray2 = new double[2][2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        dArray3[0] = 0.0;
        dArray4[0] = dArray[1];
        int n3 = 1;
        for (int i2 = 1; i2 < n2 - 1; ++i2) {
            if (!(dArray[i2 - 1] <= dArray[i2] & dArray[i2] >= dArray[i2 + 1])) continue;
            dArray3[n3] = i2;
            dArray4[n3] = dArray[i2];
            ++n3;
        }
        dArray3[n3] = n2 - 1;
        dArray4[n3] = dArray[n2 - 1];
        if (n3 >= 3) {
            double d2;
            double d3;
            double d4 = (dArray4[1] - dArray4[2]) / (dArray3[1] - dArray3[2]);
            double d5 = d4 * (dArray3[0] - dArray3[1]) + dArray4[1];
            if (d5 > dArray4[0]) {
                dArray4[0] = d5;
            }
            if ((d3 = (d2 = (dArray4[n3 - 1] - dArray4[n3 - 2]) / (dArray3[n3 - 1] - dArray3[n3 - 2])) * (dArray3[n3] - dArray3[n3 - 1]) + dArray4[n3 - 1]) > dArray4[n3]) {
                dArray4[n3] = d3;
            }
        }
        dArray2[0] = Arrays.copyOf(dArray3, ++n3);
        dArray2[1] = Arrays.copyOf(dArray4, n3);
        return dArray2;
    }

    public static double[][] computeMinima(double[] dArray) {
        int n2 = dArray.length;
        double[][] dArray2 = new double[2][2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n2];
        dArray3[0] = 0.0;
        dArray4[0] = dArray[0];
        int n3 = 1;
        for (int i2 = 2; i2 < n2 - 1; ++i2) {
            if (!(dArray[i2 - 1] >= dArray[i2]) || !(dArray[i2] <= dArray[i2 + 1])) continue;
            dArray3[n3] = i2;
            dArray4[n3] = dArray[i2];
            ++n3;
        }
        dArray3[n3] = n2 - 1;
        dArray4[n3] = dArray[n2 - 1];
        if (n3 >= 3) {
            double d2;
            double d3;
            double d4 = (dArray4[1] - dArray4[2]) / (dArray3[1] - dArray3[2]);
            double d5 = d4 * (dArray3[0] - dArray3[1]) + dArray4[1];
            if (d5 < dArray4[0]) {
                dArray4[0] = d5;
            }
            if ((d3 = (d2 = (dArray4[n3 - 1] - dArray4[n3 - 2]) / (dArray3[n3 - 1] - dArray3[n3 - 2])) * (dArray3[n3] - dArray3[n3 - 1]) + dArray4[n3 - 1]) < dArray4[n3]) {
                dArray4[n3] = d3;
            }
        }
        dArray2[0] = Arrays.copyOf(dArray3, ++n3);
        dArray2[1] = Arrays.copyOf(dArray4, n3);
        return dArray2;
    }

    public static double[] computePhaseSpectrum(double[] dArray) {
        double[] dArray2 = new double[dArray.length / 2];
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            int n2 = i2 << 1;
            double d2 = dArray[n2];
            double d3 = dArray[n2 + 1];
            dArray2[i2] = MathBase.aTan2(d3, d2);
        }
        dArray2[0] = dArray2[1];
        dArray2[dArray2.length - 1] = dArray2[dArray2.length - 2];
        return dArray2;
    }

    public static float[] computePhaseSpectrum(float[] fArray) {
        float[] fArray2 = new float[fArray.length / 2];
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            int n2 = i2 << 1;
            double d2 = fArray[n2];
            double d3 = fArray[n2 + 1];
            fArray2[i2] = (float)MathBase.aTan2(d3, d2);
        }
        fArray2[0] = fArray2[1];
        fArray2[fArray2.length - 1] = fArray2[fArray2.length - 2];
        return fArray2;
    }

    public static double[][] filterPeaksHarmonics(double[][] dArray, double[] dArray2, double d2, boolean bl2) {
        int n2;
        int n3;
        double[] dArray3 = new double[dArray2.length];
        double[] dArray4 = new double[dArray2.length];
        double[][] dArrayArray = new double[][]{Arrays.copyOf(dArray[0], dArray[0].length), Arrays.copyOf(dArray[1], dArray[1].length)};
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            dArray3[n3] = n3;
        }
        for (n3 = 0; n3 < dArray[0].length; ++n3) {
            int n4 = (int)dArray[0][n3];
            if (n4 <= 0) continue;
            if (bl2) {
                dArray4[n4 - 1] = 0.5 * dArray2[n4];
                dArray4[n4] = dArray2[n4];
                dArray4[n4 + 1] = 0.5 * dArray2[n4];
                continue;
            }
            dArray4[n4 - 1] = 0.5;
            dArray4[n4] = 1.0;
            dArray4[n4 + 1] = 0.5;
        }
        CombFunction combFunction = new CombFunction("myCombFunction", new double[]{d2, 1.0, 1.2 / (double)(2 * dArray2.length)});
        combFunction.fixParameter(1, true);
        combFunction.fixParameter(2, true);
        NonLinearRegressionFitter nonLinearRegressionFitter = new NonLinearRegressionFitter(dArray3, dArray4);
        double[] dArray5 = new double[]{d2, 1.0, 1.5 / (double)(2 * dArray2.length)};
        double[] dArray6 = new double[]{1.0E-5, 0.1, 1.0E-5};
        nonLinearRegressionFitter.simplex((Function1D)combFunction, dArray5, dArray6);
        double[] dArray7 = nonLinearRegressionFitter.getBestEstimates();
        for (n2 = 0; n2 < dArray7.length; ++n2) {
            System.out.printf("parameter %d = %f\n", n2, dArray7[n2]);
        }
        d2 = dArray7[0];
        System.err.println("set estimate to " + d2);
        n2 = 0;
        for (int i2 = 0; i2 < dArray[0].length; ++i2) {
            double d3 = combFunction.getValue(dArray[0][i2]);
            if (!(d3 > 0.0)) continue;
            dArrayArray[0][n2] = dArray[0][i2];
            dArrayArray[1][n2] = dArray[1][i2];
            ++n2;
        }
        System.err.println("filtered " + n2);
        dArrayArray[0] = Arrays.copyOf(dArrayArray[0], n2);
        dArrayArray[1] = Arrays.copyOf(dArrayArray[1], n2);
        return dArrayArray;
    }

    public static double[][] filterPeaksSignalToNoise(double[][] dArray, double d2, boolean bl2) {
        double[][] dArray2 = new double[2][dArray[0].length];
        double[] dArray3 = dArray[0];
        double[] dArray4 = dArray[1];
        int n2 = 0;
        double d3 = Math.maximum(dArray4);
        if (!bl2) {
            for (int i2 = 0; i2 < dArray[0].length; ++i2) {
                if (!(dArray4[i2] > d3 / d2)) continue;
                dArray2[0][n2] = dArray3[i2];
                dArray2[1][n2] = dArray4[i2];
                ++n2;
            }
        } else {
            for (int i3 = 0; i3 < dArray[0].length; ++i3) {
                if (!(dArray4[i3] > d3 - d2)) continue;
                dArray2[0][n2] = dArray3[i3];
                dArray2[1][n2] = dArray4[i3];
                ++n2;
            }
        }
        dArray2[0] = Arrays.copyOf(dArray2[0], n2);
        dArray2[1] = Arrays.copyOf(dArray2[1], n2);
        return dArray2;
    }

    public static double interpolateBaryCentre(double[] dArray, int n2) {
        double d2 = 1.0 / (2.0 * (double)dArray.length);
        if (n2 > 0 && n2 < dArray.length - 1) {
            double d3 = Math.pow(dArray[n2 - 1], 1.0);
            d3 += Math.pow(dArray[n2], 1.0);
            double d4 = dArray[n2 - 1] * (double)(n2 - 1);
            d4 += dArray[n2] * (double)n2;
            d4 += dArray[n2 + 1] * (double)(n2 + 1);
            return (d4 /= (d3 += Math.pow(dArray[n2 + 1], 1.0))) * d2;
        }
        return (double)n2 * d2;
    }

    public static double interpolateGaussian(double[] dArray, int n2) {
        double d2 = 1.0 / (double)(2 * dArray.length);
        if (n2 > 0 && n2 < dArray.length - 1) {
            double d3 = Math.pow(dArray[n2 - 1], 1.0);
            double d4 = Math.pow(dArray[n2], 1.0);
            double d5 = Math.pow(dArray[n2 + 1], 1.0);
            double d6 = n2;
            return (d6 += 0.5 * Math.log(d5 / d3) / Math.log(Math.pow(d4, 2.0) / (d3 * d5))) * d2;
        }
        return (double)n2 * d2;
    }

    public static double interpolateNAFF(double[] dArray, int n2) {
        double d2 = (double)n2 / (double)(2 * dArray.length);
        if (n2 > 0 && n2 < dArray.length - 1) {
            double d3 = java.lang.Math.PI / (double)dArray.length;
            double d4 = Math.pow(dArray[n2 - 1], 1.0);
            double d5 = Math.pow(dArray[n2], 1.0);
            double d6 = Math.pow(dArray[n2 + 1], 1.0);
            if (d4 < d6) {
                return d2 + MathBase.aTan2(d6 * MathBase.sin(d3), d5 + d6 * MathBase.cos(d3)) / java.lang.Math.PI;
            }
            return d2 - MathBase.aTan2(d4 * MathBase.sin(d3), d5 + d4 * MathBase.cos(d3)) / java.lang.Math.PI;
        }
        return d2;
    }

    public static double interpolateParabolic(double[] dArray, int n2) {
        double d2 = 1.0 / (2.0 * (double)dArray.length);
        if (n2 > 0 && n2 < dArray.length - 1) {
            double d3 = Math.pow(dArray[n2 - 1], 1.0);
            double d4 = Math.pow(dArray[n2], 1.0);
            double d5 = Math.pow(dArray[n2 + 1], 1.0);
            return ((double)n2 + 0.5 * (d5 - d3) / (2.0 * d4 - d3 - d5)) * d2;
        }
        return dArray[n2] * d2;
    }

    public static synchronized double[] interpolateSpectrum(double[] dArray, int n2) {
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D((long)dArray.length);
        doubleFFT_1D.realInverse(dArray2, true);
        double[] dArray3 = new double[n2 * dArray2.length];
        System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length - 2);
        int n3 = n2 * dArray.length;
        doubleFFT_1D = new DoubleFFT_1D((long)n3);
        doubleFFT_1D.realForward(dArray3);
        int n4 = 0;
        while (n4 < dArray3.length) {
            int n5 = n4++;
            dArray3[n5] = dArray3[n5] * (double)n2;
        }
        return dArray3;
    }

    public static void main(String[] stringArray) {
        double d2;
        int n2;
        double[] dArray = new double[1024];
        double d3 = 128.12345678912345;
        double d4 = 1.2;
        for (n2 = 0; n2 < 1024; ++n2) {
            d2 = n2;
            dArray[n2] = Math.gauss(d2, 128.12345678912345, 1.2, true);
        }
        n2 = (int)Math.locationMaximum(dArray, dArray.length);
        System.out.println("found highest peak at bin = " + n2);
        d2 = SpectrumTools.interpolateGaussian(dArray, n2) * 2.0 * (double)dArray.length;
        double d5 = SpectrumTools.interpolateBaryCentre(dArray, n2) * 2.0 * (double)dArray.length;
        double d6 = SpectrumTools.interpolateParabolic(dArray, n2) * 2.0 * (double)dArray.length;
        double d7 = SpectrumTools.interpolateNAFF(dArray, n2) * 2.0 * (double)dArray.length;
        System.out.println(" ");
        System.out.printf("no interpolation                 f=%f [bins], abs. error = %e[bins]\n", n2, Math.abs((double)n2 - 128.12345678912345));
        System.out.printf("Gaussian peak frequency estimate f=%f [bins], abs. error = %e[bins]\n", d2, Math.abs(d2 - 128.12345678912345));
        System.out.printf("Bary-centre frequency estimate   f=%f [bins], abs. error = %e[bins]\n", d5, Math.abs(d5 - 128.12345678912345));
        System.out.printf("Parabolic frequency estimate     f=%f [bins], abs. error = %e[bins]\n", d6, Math.abs(d6 - 128.12345678912345));
        System.out.printf("'NAFF'/'SUSSIX'-type estimate    f=%f [bins], abs. error = %e[bins]\n", d7, Math.abs(d7 - 128.12345678912345));
        System.out.println(" ");
    }
}

