/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.functions;

import io.fair_acc.math.functions.AbstractFunction1D;
import io.fair_acc.math.functions.Function1D;

public class PolynomialFunction
extends AbstractFunction1D
implements Function1D {
    public PolynomialFunction(String string, double[] dArray) {
        super(string, dArray);
        this.setParameterNames();
        this.setErrorEstimateComputation(true);
    }

    public PolynomialFunction(String string, double[] dArray, String[] stringArray) {
        super(string, dArray, stringArray);
        this.setErrorEstimateComputation(true);
    }

    public PolynomialFunction(String string, int n2) {
        super(string, n2);
        this.setParameterNames();
        this.setErrorEstimateComputation(true);
    }

    @Override
    public double getValue(double d2) {
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.getParameterCount(); ++i2) {
            d3 += this.getParameterValue(i2) * Math.pow(d2, i2);
        }
        return d3;
    }

    @Override
    public void setParameterCount(int n2) {
        super.setParameterCount(n2);
        this.setParameterNames();
    }

    private void setParameterNames() {
        for (int i2 = 0; i2 < this.getParameterCount(); ++i2) {
            this.setParameterName(i2, "p" + i2);
        }
    }

    public static void main(String[] stringArray) {
        PolynomialFunction polynomialFunction = new PolynomialFunction("poly1", new double[]{0.5, 1.0, 2.0, 0.6});
        for (int i2 = -3; i2 <= 3; ++i2) {
            double d2 = i2;
            System.out.printf("%+2d: poly(%+4.2f) = %f\n", i2, d2, polynomialFunction.getValue(d2));
        }
        polynomialFunction.printParameters(true);
    }
}

