/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.fitter;

import io.fair_acc.math.ArrayConversion;
import io.fair_acc.math.ArrayMath;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.fitter.NonLinearRegressionFitter;
import io.fair_acc.math.functions.Function;
import io.fair_acc.math.functions.Function1D;
import io.fair_acc.math.functions.FunctionND;
import io.fair_acc.math.matrix.MatrixD;
import io.fair_acc.math.storage.DoubleStorage1D;
import io.fair_acc.math.storage.VoxelArrayND;
import java.util.ArrayList;

@Deprecated
public class NonLinearRegressionFitter2 {
    protected static double histTol = 1.0001;
    protected int nData = 0;
    protected int nYarrays = 1;
    protected int nTerms = 0;
    protected int degreesOfFreedom = 0;
    protected VoxelArrayND xData = null;
    protected VoxelArrayND yData = null;
    protected VoxelArrayND yCalc = null;
    protected VoxelArrayND weight = null;
    protected VoxelArrayND residual = null;
    protected VoxelArrayND residualW = null;
    protected boolean weightOpt = false;
    protected int weightFlag = 0;
    protected double[] best = null;
    protected double[] bestSd = null;
    protected double[] pseudoSd = null;
    protected double[] tValues = null;
    protected double[] pValues = null;
    protected double chiSquare = Double.NaN;
    protected double reducedChiSquare = Double.NaN;
    protected double sumOfSquares = Double.NaN;
    protected double lastSSnoConstraint = 0.0;
    protected double[][] covar = null;
    protected double[][] corrCoeff = null;
    protected boolean linNonLin = true;
    protected boolean trueFreq = false;
    protected boolean nlrStatus = true;
    protected int scaleOpt = 0;
    protected double[] fscale = null;
    protected boolean zeroCheck = false;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected double constraintTolerance = 1.0E-4;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double[] constraints = null;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected int nMax = 3000;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fMin = -1.0;
    protected double fTol = 1.0E-9;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] step = null;
    protected double dStep = 0.5;
    protected double[][] grad = null;
    protected double delta = 1.0E-4;
    protected boolean invertFlag = true;
    protected boolean posVarFlag = true;
    protected int minTest = 0;
    protected double simplexSd = 0.0;
    protected boolean statFlag = true;
    protected boolean multipleY = false;
    protected double[] values = null;
    protected boolean[] fixed = null;
    protected boolean ignoreDofFcheck = false;
    protected boolean nFactorOption = false;

    public NonLinearRegressionFitter2(double[] dArray, double[] dArray2, double[] dArray3) {
        this.setData(dArray, dArray2, dArray3);
    }

    public NonLinearRegressionFitter2(VoxelArrayND voxelArrayND, VoxelArrayND voxelArrayND2, VoxelArrayND voxelArrayND3) {
        this.setData(voxelArrayND, voxelArrayND2, voxelArrayND3);
    }

    public void addConstraint(int n2, int n3, double d2) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(this.constraintMethod);
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(1);
        } else {
            int n4 = (Integer)this.penalties.get(1);
            this.penalties.set(1, ++n4);
        }
        this.penalties.add(n2);
        this.penalties.add(n3);
        this.penalties.add(d2);
        if (n2 > this.maxConstraintIndex) {
            this.maxConstraintIndex = n2;
        }
    }

    public void addConstraint(int[] nArray, double[] dArray, int n2, double d2) {
        int n3;
        int n4 = nArray.length;
        int n5 = dArray.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("num of parameters, " + n4 + ", does not equal number of parameter signs, " + n5);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(this.constraintMethod);
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(1);
        } else {
            n3 = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, ++n3);
        }
        this.sumPenalties.add(n4);
        this.sumPenalties.add(nArray);
        this.sumPenalties.add(dArray);
        this.sumPenalties.add(n2);
        this.sumPenalties.add(d2);
        n3 = Math.maximum(nArray);
        if (n3 > this.maxConstraintIndex) {
            this.maxConstraintIndex = n3;
        }
    }

    public void addConstraint(int[] nArray, int[] nArray2, int n2, double d2) {
        double[] dArray = ArrayConversion.getDoubleArray(nArray2);
        this.addConstraint(nArray, dArray, n2, d2);
    }

    protected VoxelArrayND checkForZeroWeights(VoxelArrayND voxelArrayND) {
        this.weightOpt = true;
        int n2 = 0;
        if (voxelArrayND == null) {
            throw new IllegalArgumentException("weights are null");
        }
        for (int i2 = 0; i2 < voxelArrayND.getLocalStorageDim(); ++i2) {
            double[] dArray = voxelArrayND.getLocal(i2);
            for (int i3 = 0; i3 < dArray.length; ++i3) {
                if (!(dArray[i3] <= 0.0)) continue;
                ++n2;
            }
        }
        double d2 = 100.0 * (double)n2 / (double)voxelArrayND.getLocalStorageDim();
        if (d2 > 40.0) {
            System.out.println(d2 + "% of the weights are zero or less; all weights set to 1.0");
            this.weight.initialiseWithValue(1.0);
            this.weightOpt = false;
        } else if (d2 > 0.0) {
            this.weight.initialiseWithValue(1.0);
        }
        return this.weight;
    }

    public void checkZeroNeg(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = 0;
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.nData; ++i2) {
            if (!(dArray2[i2] <= 0.0)) continue;
            if (i2 <= n2) {
                bl2 = true;
                n2 = i2;
                while (bl2) {
                    if (++n2 >= this.nData) {
                        throw new ArithmeticException("all zero cumulative data!!");
                    }
                    if (!(dArray2[n2] > 0.0)) continue;
                    dArray2[i2] = dArray2[n2];
                    dArray[i2] = dArray[n2];
                    dArray3[i2] = dArray3[n2];
                    bl2 = false;
                }
                continue;
            }
            if (i2 == this.nData - 1) {
                dArray2[i2] = dArray2[i2 - 1];
                dArray[i2] = dArray[i2 - 1];
                dArray3[i2] = dArray3[i2 - 1];
                continue;
            }
            dArray2[i2] = (dArray2[i2 - 1] + dArray2[i2 + 1]) / 2.0;
            dArray[i2] = (dArray[i2 - 1] + dArray[i2 + 1]) / 2.0;
            dArray3[i2] = (dArray3[i2 - 1] + dArray3[i2 + 1]) / 2.0;
        }
    }

    public double[] getBestEstimates() {
        return (double[])this.best.clone();
    }

    public double[] getBestEstimatesErrors() {
        return (double[])this.bestSd.clone();
    }

    public double[] getbestestimatesStandardDeviations() {
        return (double[])this.bestSd.clone();
    }

    public double[] getBestEstimatesStandardDeviations() {
        return (double[])this.bestSd.clone();
    }

    public double getChiSquare() {
        double d2 = 0.0;
        if (this.weightOpt) {
            d2 = this.chiSquare;
        } else {
            System.out.println("Chi Square cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Chi Square");
            d2 = -1.0;
        }
        return d2;
    }

    public double getchiSquareProb() {
        double d2 = 0.0;
        if (this.weightOpt) {
            d2 = 1.0 - Math.chisquareQuantile(this.chiSquare, this.nData - 1);
        } else {
            System.out.println("A Chi Square probablity cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Reduced Chi Square");
            d2 = -1.0;
        }
        return d2;
    }

    public double[] getCoeff() {
        return (double[])this.best.clone();
    }

    public double[] getCoeffSd() {
        return (double[])this.bestSd.clone();
    }

    public double[] getCoeffVar() {
        double[] dArray = new double[this.nTerms];
        for (int i2 = 0; i2 < this.nTerms; ++i2) {
            dArray[i2] = this.bestSd[i2] * 100.0 / this.best[i2];
        }
        return dArray;
    }

    public double[][] getCorrCoeffMatrix() {
        return this.corrCoeff;
    }

    public double[][] getCovMatrix() {
        return this.covar;
    }

    public double getDegFree() {
        return this.degreesOfFreedom;
    }

    public double getDelta() {
        return this.delta;
    }

    public double[][] getGrad() {
        return this.grad;
    }

    public boolean getInversionCheck() {
        return this.invertFlag;
    }

    public int getMinTest() {
        return this.minTest;
    }

    public int getNiter() {
        return this.nIter;
    }

    public boolean getNlrStatus() {
        return this.nlrStatus;
    }

    public int getNmax() {
        return this.nMax;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public boolean getPosVarCheck() {
        return this.posVarFlag;
    }

    public double[] getPseudoErrors() {
        return (double[])this.pseudoSd.clone();
    }

    public double[] getPseudoSd() {
        return (double[])this.pseudoSd.clone();
    }

    public double[] getPvalues() {
        return (double[])this.pValues.clone();
    }

    public double getReducedChiSquare() {
        double d2 = 0.0;
        if (this.weightOpt) {
            d2 = this.reducedChiSquare;
        } else {
            System.out.println("A Reduced Chi Square cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Reduced Chi Square");
            d2 = -1.0;
        }
        return d2;
    }

    public double[] getResiduals() {
        double[] dArray = new double[this.nData];
        for (int i2 = 0; i2 < this.nData; ++i2) {
        }
        return dArray;
    }

    public double[] getScale() {
        return this.fscale;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public double getTolerance() {
        return this.fTol;
    }

    public boolean getTrueFreq() {
        return this.trueFreq;
    }

    public double[] getTvalues() {
        return (double[])this.tValues.clone();
    }

    public double[] getWeightedResiduals() {
        double[] dArray = new double[this.nData];
        for (int i2 = 0; i2 < this.nData; ++i2) {
        }
        return dArray;
    }

    public double[] getXdata() {
        if (this.xData instanceof DoubleStorage1D) {
            return (double[])((DoubleStorage1D)this.xData).getArray().clone();
        }
        return null;
    }

    public double[] getYcalc() {
        if (this.yCalc instanceof DoubleStorage1D) {
            return (double[])((DoubleStorage1D)this.yCalc).getArray().clone();
        }
        return null;
    }

    public double[] getYdata() {
        if (this.yData instanceof DoubleStorage1D) {
            return (double[])((DoubleStorage1D)this.yData).getArray().clone();
        }
        return null;
    }

    public void ignoreDofFcheck() {
        this.ignoreDofFcheck = true;
    }

    protected void nelderMead(Object object, double[] dArray, double[] dArray2, double d2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object2;
        int n8;
        int n9;
        int n10 = dArray.length;
        if (this.maxConstraintIndex >= n10) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + n10 + ")");
        }
        this.nlrStatus = true;
        this.nTerms = n10;
        int n11 = n10 + 1;
        this.lastSSnoConstraint = 0.0;
        if (this.scaleOpt < 2) {
            this.fscale = new double[n10];
        }
        if (this.scaleOpt == 2 && this.fscale.length != dArray.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("step array length " + dArray2.length + " and initial estimate array length " + dArray.length + " are of different");
        }
        for (n9 = 0; n9 < n10; ++n9) {
            if (dArray2[n9] != 0.0) continue;
            throw new IllegalArgumentException("step " + n9 + " size is zero");
        }
        if (this.ignoreDofFcheck) {
            this.bestSd = new double[this.nTerms];
            this.pseudoSd = new double[this.nTerms];
            this.tValues = new double[this.nTerms];
            this.pValues = new double[this.nTerms];
            this.covar = new double[this.nTerms][this.nTerms];
            this.corrCoeff = new double[this.nTerms][this.nTerms];
            for (n9 = 0; n9 < this.nTerms; ++n9) {
                this.bestSd[n9] = Double.NaN;
                this.pseudoSd[n9] = Double.NaN;
                for (int i2 = 0; i2 < this.nTerms; ++i2) {
                    this.covar[n9][i2] = Double.NaN;
                    this.corrCoeff[n9][i2] = Double.NaN;
                }
            }
        }
        this.startH = new double[n10];
        this.step = new double[n10];
        double[] dArray3 = new double[n10];
        this.best = new double[n10];
        this.bestSd = new double[n10];
        this.tValues = new double[n10];
        this.pValues = new double[n10];
        double[][] dArray4 = new double[n11][n11];
        double[] dArray5 = new double[n11];
        double[] dArray6 = new double[n11];
        double[] dArray7 = new double[n11];
        double[] dArray8 = new double[n11];
        double d3 = 0.0;
        int n12 = 0;
        for (n8 = 0; n8 < this.yData.getLocalStorageDim(); ++n8) {
            object2 = this.yData.getLocal(n8);
            for (n7 = 0; n7 < ((double[])object2).length; ++n7) {
                d3 += Math.abs(object2[n7]);
                ++n12;
            }
        }
        double d4 = d3 = n12 == 0 ? 0.0 : d3 / (double)n12;
        if (this.penalty) {
            Integer n13 = (Integer)this.penalties.get(1);
            this.nConstraints = n13;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            object2 = null;
            n7 = 2;
            for (n6 = 0; n6 < this.nConstraints; ++n6) {
                n13 = (Integer)this.penalties.get(n7);
                this.penaltyParam[n6] = n13;
                n13 = (Integer)this.penalties.get(++n7);
                this.penaltyCheck[n6] = n13;
                object2 = (Double)this.penalties.get(++n7);
                this.constraints[n6] = object2.doubleValue();
                ++n7;
            }
        }
        if (this.sumPenalty) {
            Integer n14 = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = n14;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            object2 = null;
            double[] dArray9 = null;
            Double d5 = null;
            n5 = 2;
            for (int i3 = 0; i3 < this.nSumConstraints; ++i3) {
                n14 = (Integer)this.sumPenalties.get(n5);
                this.sumPenaltyNumber[i3] = n14;
                object2 = (int[])this.sumPenalties.get(++n5);
                this.sumPenaltyParam[i3] = (int[])object2;
                dArray9 = (double[])this.sumPenalties.get(++n5);
                this.sumPlusOrMinus[i3] = dArray9;
                n14 = (Integer)this.sumPenalties.get(++n5);
                this.sumPenaltyCheck[i3] = n14;
                d5 = (Double)this.sumPenalties.get(++n5);
                this.sumConstraints[i3] = d5;
                ++n5;
            }
        }
        System.arraycopy(dArray, 0, this.startH, 0, n10);
        if (this.scaleOpt > 0) {
            n8 = 0;
            for (int i4 = 0; i4 < n10; ++i4) {
                if (dArray[i4] != 0.0) continue;
                n8 = 1;
                break;
            }
            if (n8 != 0) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                for (n8 = 0; n8 < n10; ++n8) {
                    this.fscale[n8] = 1.0;
                }
                break;
            }
            case 1: {
                for (n8 = 0; n8 < n10; ++n8) {
                    this.fscale[n8] = 1.0 / dArray[n8];
                    dArray2[n8] = dArray2[n8] / dArray[n8];
                    dArray[n8] = 1.0;
                }
                break;
            }
            case 2: {
                for (n8 = 0; n8 < n10; ++n8) {
                    int n15 = n8;
                    dArray2[n15] = dArray2[n15] * this.fscale[n8];
                    int n16 = n8;
                    dArray[n16] = dArray[n16] * this.fscale[n8];
                }
                break;
            }
        }
        this.fTol = d2;
        this.nMax = n2;
        this.nIter = 0;
        for (n8 = 0; n8 < n10; ++n8) {
            this.step[n8] = dArray2[n8];
            this.fscale[n8] = this.fscale[n8];
        }
        double d6 = 0.0;
        for (n4 = 0; n4 < n10; ++n4) {
            dArray7[n4] = d6 = dArray[n4];
            dArray8[n4] = d6;
            dArray3[n4] = d6;
        }
        n4 = this.konvge;
        for (n6 = 0; n6 < n10; ++n6) {
            dArray4[n6][n11 - 1] = dArray[n6];
        }
        dArray5[n11 - 1] = this.sumSquares(object, dArray);
        for (n6 = 0; n6 < n10; ++n6) {
            int n17 = n6;
            dArray[n17] = dArray[n17] + dArray2[n6];
            for (n5 = 0; n5 < n10; ++n5) {
                dArray4[n5][n6] = dArray[n5];
            }
            dArray5[n6] = this.sumSquares(object, dArray);
            int n18 = n6;
            dArray[n18] = dArray[n18] - dArray2[n6];
        }
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n22;
            d7 = d10 = dArray5[0];
            n19 = 0;
            n20 = 0;
            for (n3 = 1; n3 < n11; ++n3) {
                if (dArray5[n3] < d10) {
                    d10 = dArray5[n3];
                    n19 = n3;
                }
                if (!(dArray5[n3] > d7)) continue;
                d7 = dArray5[n3];
                n20 = n3;
            }
            for (n3 = 0; n3 < n10; ++n3) {
                d14 = 0.0;
                for (n22 = 0; n22 < n11; ++n22) {
                    d14 += dArray4[n3][n22];
                }
                dArray6[n3] = (d14 -= dArray4[n3][n20]) / (double)n10;
            }
            for (n3 = 0; n3 < n10; ++n3) {
                dArray7[n3] = (1.0 + this.rCoeff) * dArray6[n3] - this.rCoeff * dArray4[n3][n20];
            }
            d8 = this.sumSquares(object, dArray7);
            ++this.nIter;
            if (d8 < d10) {
                for (n3 = 0; n3 < n10; ++n3) {
                    dArray8[n3] = dArray7[n3] * (1.0 + this.eCoeff) - this.eCoeff * dArray6[n3];
                }
                d9 = this.sumSquares(object, dArray8);
                ++this.nIter;
                if (d9 < d10) {
                    for (n3 = 0; n3 < n10; ++n3) {
                        dArray4[n3][n20] = dArray8[n3];
                    }
                    dArray5[n20] = d9;
                } else {
                    for (n3 = 0; n3 < n10; ++n3) {
                        dArray4[n3][n20] = dArray7[n3];
                    }
                    dArray5[n20] = d8;
                }
            } else {
                n21 = 0;
                for (n3 = 0; n3 < n11; ++n3) {
                    if (n3 == n20 || !(d8 > dArray5[n3])) continue;
                    ++n21;
                }
                if (n21 == n10) {
                    if (d8 <= dArray5[n20]) {
                        for (n3 = 0; n3 < n10; ++n3) {
                            dArray4[n3][n20] = dArray7[n3];
                        }
                        dArray5[n20] = d8;
                    }
                    for (n3 = 0; n3 < n10; ++n3) {
                        dArray8[n3] = this.cCoeff * dArray4[n3][n20] + (1.0 - this.cCoeff) * dArray6[n3];
                    }
                    d9 = this.sumSquares(object, dArray8);
                    ++this.nIter;
                    if (d9 > dArray5[n20]) {
                        for (n3 = 0; n3 < n11; ++n3) {
                            for (n22 = 0; n22 < n10; ++n22) {
                                dArray4[n22][n3] = 0.5 * (dArray4[n22][n3] + dArray4[n22][n19]);
                                dArray3[n22] = dArray4[n22][n3];
                            }
                            dArray5[n3] = this.sumSquares(object, dArray3);
                        }
                        this.nIter += n11;
                    } else {
                        for (n3 = 0; n3 < n10; ++n3) {
                            dArray4[n3][n20] = dArray8[n3];
                        }
                        dArray5[n20] = d9;
                    }
                } else {
                    for (n3 = 0; n3 < n10; ++n3) {
                        dArray4[n3][n20] = dArray7[n3];
                    }
                    dArray5[n20] = d8;
                }
            }
            d12 = 0.0;
            d7 = dArray5[0];
            n19 = 0;
            for (n3 = 0; n3 < n11; ++n3) {
                d12 += dArray5[n3];
                if (!(d7 > dArray5[n3])) continue;
                d7 = dArray5[n3];
                n19 = n3;
            }
            d12 /= (double)n11;
            d13 = 0.0;
            for (n3 = 0; n3 < n11; ++n3) {
                d14 = dArray5[n3] - d12;
                d13 += d14 * d14;
            }
            d11 = Math.sqrt(d13 / (double)n10);
            switch (this.minTest) {
                case 0: {
                    if (!(d11 < d2)) break;
                    bl2 = false;
                    break;
                }
                case 1: {
                    if (!(Math.sqrt(d7 / (double)this.degreesOfFreedom) < d3 * d2)) break;
                    bl2 = false;
                }
            }
            this.sumOfSquares = d7;
            if (!bl2) {
                for (n3 = 0; n3 < n10; ++n3) {
                    dArray3[n3] = dArray4[n3][n19];
                }
                dArray5[n11 - 1] = d7;
                this.simplexSd = d11;
                if (--n4 > 0) {
                    bl2 = true;
                    for (n3 = 0; n3 < n10; ++n3) {
                        dArray3[n3] = dArray3[n3] + dArray2[n3];
                        for (n22 = 0; n22 < n10; ++n22) {
                            dArray4[n22][n3] = dArray3[n22];
                        }
                        dArray5[n3] = this.sumSquares(object, dArray3);
                        dArray3[n3] = dArray3[n3] - dArray2[n3];
                    }
                }
            }
            if (!bl2 || this.nIter <= this.nMax) continue;
            System.out.println("Maximum iteration number reached, in Regression.simplex(...)");
            System.out.println("without the convergence criterion being satisfied");
            System.out.println("Current parameter estimates and sum of squares values returned");
            this.nlrStatus = false;
            for (n3 = 0; n3 < n10; ++n3) {
                dArray3[n3] = dArray4[n3][n19];
            }
            dArray5[n11 - 1] = d7;
            bl2 = false;
        }
        for (n3 = 0; n3 < n10; ++n3) {
            dArray3[n3] = dArray4[n3][n19];
            this.best[n3] = dArray3[n3] / this.fscale[n3];
            this.fscale[n3] = 1.0;
        }
        this.fMin = d7;
        this.kRestart = this.konvge - n4;
        if (this.statFlag) {
            if (!this.ignoreDofFcheck) {
                this.pseudoLinearStats(object);
            }
        } else {
            for (n3 = 0; n3 < n10; ++n3) {
                this.bestSd[n3] = Double.NaN;
            }
        }
    }

    protected int pseudoLinearStats(Object object) {
        int n2;
        double[] dArray;
        double[] dArray2;
        int n3;
        int n4;
        int n5;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n6 = 0;
        int n7 = this.nTerms;
        double[] dArray3 = new double[n7];
        double[] dArray4 = new double[n7];
        double[] dArray5 = new double[n7];
        double[][] dArray6 = new double[n7][n7];
        this.pseudoSd = new double[n7];
        this.grad = new double[n7][2];
        this.covar = new double[n7][n7];
        this.corrCoeff = new double[n7][n7];
        dArray4 = (double[])this.best.clone();
        double d6 = 1.0;
        double d7 = 1.0;
        for (n5 = 0; n5 < n7; ++n5) {
            System.arraycopy(dArray4, 0, dArray3, 0, n7);
            d6 = dArray4[n5];
            if (d6 == 0.0) {
                d6 = this.step[n5];
                this.zeroCheck = true;
            }
            dArray3[n5] = d6 * (1.0 - this.delta);
            this.lastSSnoConstraint = this.sumOfSquares;
            d2 = this.sumSquares(object, dArray3);
            dArray3[n5] = d6 * (1.0 + this.delta);
            this.lastSSnoConstraint = this.sumOfSquares;
            d3 = this.sumSquares(object, dArray3);
            this.grad[n5][0] = (this.fMin - d2) / Math.abs(this.delta * d6);
            this.grad[n5][1] = (d3 - this.fMin) / Math.abs(this.delta * d6);
        }
        this.lastSSnoConstraint = this.sumOfSquares;
        for (n5 = 0; n5 < n7; ++n5) {
            for (n4 = 0; n4 < n7; ++n4) {
                System.arraycopy(dArray4, 0, dArray3, 0, n7);
                d6 = dArray3[n5];
                if (d6 == 0.0) {
                    d6 = this.step[n5];
                    this.zeroCheck = true;
                }
                dArray3[n5] = d6 * (1.0 + this.delta / 2.0);
                d6 = dArray3[n4];
                if (d6 == 0.0) {
                    d6 = this.step[n4];
                    this.zeroCheck = true;
                }
                dArray3[n4] = d6 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                d2 = this.sumSquares(object, dArray3);
                dArray3[n5] = dArray4[n5];
                dArray3[n4] = dArray4[n4];
                d6 = dArray3[n5];
                if (d6 == 0.0) {
                    d6 = this.step[n5];
                    this.zeroCheck = true;
                }
                dArray3[n5] = d6 * (1.0 - this.delta / 2.0);
                d6 = dArray3[n4];
                if (d6 == 0.0) {
                    d6 = this.step[n4];
                    this.zeroCheck = true;
                }
                dArray3[n4] = d6 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                d3 = this.sumSquares(object, dArray3);
                dArray3[n5] = dArray4[n5];
                dArray3[n4] = dArray4[n4];
                d6 = dArray3[n5];
                if (d6 == 0.0) {
                    d6 = this.step[n5];
                    this.zeroCheck = true;
                }
                dArray3[n5] = d6 * (1.0 + this.delta / 2.0);
                d6 = dArray3[n4];
                if (d6 == 0.0) {
                    d6 = this.step[n4];
                    this.zeroCheck = true;
                }
                dArray3[n4] = d6 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                d4 = this.sumSquares(object, dArray3);
                dArray3[n5] = dArray4[n5];
                dArray3[n4] = dArray4[n4];
                d6 = dArray3[n5];
                if (d6 == 0.0) {
                    d6 = this.step[n5];
                    this.zeroCheck = true;
                }
                dArray3[n5] = d6 * (1.0 - this.delta / 2.0);
                d6 = dArray3[n4];
                if (d6 == 0.0) {
                    d6 = this.step[n4];
                    this.zeroCheck = true;
                }
                dArray3[n4] = d6 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                d5 = this.sumSquares(object, dArray3);
                dArray6[n5][n4] = (d2 - d3 - d4 + d5) / (this.delta * this.delta);
            }
        }
        if (object instanceof Function) {
            ((Function)object).setFitterMode(true);
            Function function = (Function)object;
            for (n4 = 0; n4 < function.getParameterCount(); ++n4) {
                if (function.isParameterFixed(n4)) continue;
                function.setParameterValue(n4, dArray4[n4]);
            }
        }
        double d8 = 0.0;
        double d9 = 0.0;
        for (n3 = 0; n3 < this.yCalc.getLocalStorageDim(); ++n3) {
            if (object instanceof FunctionND) {
                dArray2 = this.xData.getLocal(n3);
                dArray = ((FunctionND)object).getValue(dArray2);
                this.yCalc.setLocal(n3, dArray);
                continue;
            }
            if (!(object instanceof Function1D)) continue;
            dArray2 = ((DoubleStorage1D)this.xData).getArray();
            dArray = ((DoubleStorage1D)this.yCalc).getArray();
            for (int i2 = 0; i2 < dArray2.length; ++i2) {
                dArray[i2] = ((Function1D)object).getValue(dArray2[i2]);
            }
        }
        for (n3 = 0; n3 < this.yCalc.getLocalStorageDim(); ++n3) {
            dArray2 = ArrayMath.subtract(this.yCalc.getLocal(n3), this.yData.getLocal(n3));
            dArray = this.residualW.getLocal(n3);
            double[] dArray7 = this.weight.getLocal(n3);
            this.residual.setLocal(n3, dArray2);
            for (n2 = 0; n2 < dArray2.length; ++n2) {
                d8 += MathBase.sqr(dArray2[n2]);
                dArray[n2] = dArray2[n2] / dArray7[n2];
                d9 += MathBase.sqr(dArray[n2]);
            }
        }
        if (object instanceof Function) {
            ((Function)object).setFitterMode(false);
        }
        this.sumOfSquares = d8;
        if (this.weightOpt || this.trueFreq) {
            this.chiSquare = d9;
            this.reducedChiSquare = d9 / (double)(this.nData - n7);
        }
        double d10 = 1.0;
        if (!this.weightOpt && !this.trueFreq) {
            d10 = this.sumOfSquares / (double)(this.nData - n7);
        }
        for (int i3 = 0; i3 < n7; ++i3) {
            this.pseudoSd[i3] = 2.0 * this.delta * d10 * Math.abs(dArray4[i3]) / (this.grad[i3][1] - this.grad[i3][0]);
            this.pseudoSd[i3] = this.pseudoSd[i3] >= 0.0 ? Math.sqrt(this.pseudoSd[i3]) : Double.NaN;
        }
        if (n7 == 1) {
            d6 = dArray4[0];
            if (d6 == 0.0) {
                d6 = this.step[0];
            }
            dArray6[0][0] = 1.0 / dArray6[0][0];
            this.covar[0][0] = dArray6[0][0] * d10 * d6 * d6;
            if (this.covar[0][0] >= 0.0) {
                dArray5[0] = Math.sqrt(this.covar[0][0]);
                this.corrCoeff[0][0] = 1.0;
            } else {
                dArray5[0] = Double.NaN;
                this.corrCoeff[0][0] = Double.NaN;
                this.posVarFlag = false;
            }
        } else {
            MatrixD matrixD = new MatrixD(dArray6);
            this.invertFlag = true;
            matrixD.print(5, 5);
            matrixD = matrixD.pseudoInverse(1.0E12);
            matrixD.print(5, 5);
            if (!this.invertFlag) {
                --n6;
            }
            dArray6 = matrixD.getArrayCopy();
            this.posVarFlag = true;
            if (this.invertFlag) {
                int n8;
                for (n8 = 0; n8 < n7; ++n8) {
                    d6 = dArray4[n8];
                    if (d6 == 0.0) {
                        d6 = this.step[n8];
                    }
                    for (n2 = n8; n2 < n7; ++n2) {
                        d7 = dArray4[n2];
                        if (d7 == 0.0) {
                            d7 = this.step[n2];
                        }
                        this.covar[n8][n2] = 2.0 * dArray6[n8][n2] * d10 * d6 * d7;
                        this.covar[n2][n8] = this.covar[n8][n2];
                    }
                    if (this.covar[n8][n8] >= 0.0) {
                        dArray5[n8] = Math.sqrt(this.covar[n8][n8]);
                        continue;
                    }
                    dArray5[n8] = Double.NaN;
                    this.posVarFlag = false;
                }
                for (n8 = 0; n8 < n7; ++n8) {
                    for (n2 = 0; n2 < n7; ++n2) {
                        this.corrCoeff[n8][n2] = Double.isFinite(dArray5[n8]) && Double.isFinite(dArray5[n2]) ? this.covar[n8][n2] / (dArray5[n8] * dArray5[n2]) : Double.NaN;
                    }
                }
            } else {
                for (int i4 = 0; i4 < n7; ++i4) {
                    for (n2 = 0; n2 < n7; ++n2) {
                        this.covar[i4][n2] = Double.NaN;
                        this.corrCoeff[i4][n2] = Double.NaN;
                    }
                    dArray5[i4] = Double.NaN;
                    this.posVarFlag = false;
                }
            }
        }
        if (!this.posVarFlag) {
            --n6;
        }
        for (int i5 = 0; i5 < this.nTerms; ++i5) {
            this.bestSd[i5] = dArray5[i5];
            this.tValues[i5] = this.best[i5] / this.bestSd[i5];
            double d11 = Math.abs(this.tValues[i5]);
            this.pValues[i5] = 1.0 - Math.student(d11, this.degreesOfFreedom);
        }
        return n6;
    }

    public void removeConstraints() {
        int n2;
        if (!this.penalties.isEmpty()) {
            n2 = this.penalties.size();
            this.penalties.subList(0, n2).clear();
        }
        this.penalty = false;
        this.nConstraints = 0;
        if (!this.sumPenalties.isEmpty()) {
            n2 = this.sumPenalties.size();
            this.sumPenalties.subList(0, n2).clear();
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
    }

    public void setConstraintTolerance(double d2) {
        this.constraintTolerance = d2;
    }

    public void setData(double[] dArray, double[] dArray2, double[] dArray3) {
        DoubleStorage1D doubleStorage1D = new DoubleStorage1D(dArray);
        DoubleStorage1D doubleStorage1D2 = new DoubleStorage1D(dArray);
        DoubleStorage1D doubleStorage1D3 = new DoubleStorage1D(dArray3);
        this.setData(doubleStorage1D, doubleStorage1D2, doubleStorage1D3);
    }

    public void setData(VoxelArrayND voxelArrayND, VoxelArrayND voxelArrayND2, VoxelArrayND voxelArrayND3) {
        this.weight = this.checkForZeroWeights(voxelArrayND3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.xData = voxelArrayND;
        this.yData = voxelArrayND2;
        this.weight = voxelArrayND3;
        this.yCalc = voxelArrayND2.copy();
        this.residual = voxelArrayND2.copy();
        this.residualW = voxelArrayND2.copy();
    }

    public void setDelta(double d2) {
        this.delta = d2;
    }

    public void setMinTest(int n2) {
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("minTest must be 0 or 1");
        }
        this.minTest = n2;
    }

    public void setNmax(int n2) {
        this.nMax = n2;
    }

    public void setNMcontract(double d2) {
        this.cCoeff = d2;
    }

    public void setNMextend(double d2) {
        this.eCoeff = d2;
    }

    public void setNMreflect(double d2) {
        this.rCoeff = d2;
    }

    public void setNrestartsMax(int n2) {
        this.konvge = n2;
    }

    public void setScale(double[] dArray) {
        this.fscale = dArray;
        this.scaleOpt = 2;
    }

    public void setScale(int n2) {
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n2;
    }

    public void setTolerance(double d2) {
        this.fTol = d2;
    }

    public void setTrueFreq(boolean bl2) {
        boolean bl3 = this.trueFreq;
        this.trueFreq = bl2;
        if (bl2) {
            boolean bl4 = NonLinearRegressionFitter2.setTrueFreqWeights(this.yData, this.weight);
            if (bl4) {
                this.trueFreq = true;
                this.weightOpt = true;
            } else {
                this.trueFreq = false;
                this.weightOpt = false;
            }
        } else if (bl3) {
            this.weight.initialiseWithValue(1.0);
            this.weightOpt = false;
        }
    }

    public void simplex(Function1D function1D, double[] dArray) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D function1D2 = function1D;
        int n2 = dArray.length;
        int n3 = this.nMax;
        double d2 = this.fTol;
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D2, dArray, dArray2, d2, n3);
    }

    public void simplex(Function1D function1D, double[] dArray, double d2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D function1D2 = function1D;
        int n2 = dArray.length;
        int n3 = this.nMax;
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D2, dArray, dArray2, d2, n3);
    }

    public void simplex(Function1D function1D, double[] dArray, double d2, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D function1D2 = function1D;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D2, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, double[] dArray2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D function1D2 = function1D;
        double d2 = this.fTol;
        int n2 = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D2, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, double[] dArray2, double d2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D function1D2 = function1D;
        int n2 = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D2, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, double[] dArray2, double d2, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D function1D2 = function1D;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D2, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, double[] dArray2, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D function1D2 = function1D;
        double d2 = this.fTol;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D2, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D function1D2 = function1D;
        int n3 = dArray.length;
        double d2 = this.fTol;
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D2, dArray, dArray2, d2, n2);
    }

    public void simplex2(FunctionND functionND, double[] dArray) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND functionND2 = functionND;
        int n2 = dArray.length;
        int n3 = this.nMax;
        double d2 = this.fTol;
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND2, dArray, dArray2, d2, n3);
    }

    public void simplex2(FunctionND functionND, double[] dArray, double d2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND functionND2 = functionND;
        int n2 = dArray.length;
        int n3 = this.nMax;
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND2, dArray, dArray2, d2, n3);
    }

    public void simplex2(FunctionND functionND, double[] dArray, double d2, int n2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND functionND2 = functionND;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND2, dArray, dArray2, d2, n2);
    }

    public void simplex2(FunctionND functionND, double[] dArray, double[] dArray2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND functionND2 = functionND;
        double d2 = this.fTol;
        int n2 = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND2, dArray, dArray2, d2, n2);
    }

    public void simplex2(FunctionND functionND, double[] dArray, double[] dArray2, double d2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND functionND2 = functionND;
        int n2 = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND2, dArray, dArray2, d2, n2);
    }

    public void simplex2(FunctionND functionND, double[] dArray, double[] dArray2, double d2, int n2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND functionND2 = functionND;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND2, dArray, dArray2, d2, n2);
    }

    public void simplex2(FunctionND functionND, double[] dArray, double[] dArray2, int n2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND functionND2 = functionND;
        double d2 = this.fTol;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND2, dArray, dArray2, d2, n2);
    }

    public void simplex2(FunctionND functionND, double[] dArray, int n2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND functionND2 = functionND;
        int n3 = dArray.length;
        double d2 = this.fTol;
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND2, dArray, dArray2, d2, n2);
    }

    protected double sumSquares(Object object, double[] dArray) {
        int n2;
        int n3;
        int n4;
        double d2 = -3.0;
        double[] dArray2 = new double[this.nTerms];
        for (int i2 = 0; i2 < this.nTerms; ++i2) {
            dArray2[i2] = dArray[i2] / this.fscale[i2];
        }
        double d3 = this.lastSSnoConstraint;
        boolean bl2 = true;
        if (this.penalty) {
            n4 = 0;
            block11: for (n3 = 0; n3 < this.nConstraints; ++n3) {
                n4 = this.penaltyParam[n3];
                switch (this.penaltyCheck[n3]) {
                    case -1: {
                        if (!(dArray2[n4] < this.constraints[n3])) continue block11;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(this.constraints[n3] - dArray2[n4]);
                        bl2 = false;
                        continue block11;
                    }
                    case 0: {
                        if (dArray2[n4] < this.constraints[n3] * (1.0 - this.constraintTolerance)) {
                            d2 = d3 + this.penaltyWeight * MathBase.sqr(this.constraints[n3] * (1.0 - this.constraintTolerance) - dArray2[n4]);
                            bl2 = false;
                        }
                        if (!(dArray2[n4] > this.constraints[n3] * (1.0 + this.constraintTolerance))) continue block11;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(dArray2[n4] - this.constraints[n3] * (1.0 + this.constraintTolerance));
                        bl2 = false;
                        continue block11;
                    }
                    case 1: {
                        if (!(dArray2[n4] > this.constraints[n3])) continue block11;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(dArray2[n4] - this.constraints[n3]);
                        bl2 = false;
                    }
                }
            }
        }
        if (this.sumPenalty) {
            n4 = 0;
            double d4 = 0.0;
            double d5 = 0.0;
            block12: for (int i3 = 0; i3 < this.nSumConstraints; ++i3) {
                for (n2 = 0; n2 < this.sumPenaltyNumber[i3]; ++n2) {
                    n4 = this.sumPenaltyParam[i3][n2];
                    d4 = this.sumPlusOrMinus[i3][n2];
                    d5 += dArray2[n4] * d4;
                }
                switch (this.sumPenaltyCheck[i3]) {
                    case -1: {
                        if (!(d5 < this.sumConstraints[i3])) continue block12;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(this.sumConstraints[i3] - d5);
                        bl2 = false;
                        continue block12;
                    }
                    case 0: {
                        if (d5 < this.sumConstraints[i3] * (1.0 - this.constraintTolerance)) {
                            d2 = d3 + this.penaltyWeight * MathBase.sqr(this.sumConstraints[i3] * (1.0 - this.constraintTolerance) - d5);
                            bl2 = false;
                        }
                        if (!(d5 > this.sumConstraints[i3] * (1.0 + this.constraintTolerance))) continue block12;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(d5 - this.sumConstraints[i3] * (1.0 + this.constraintTolerance));
                        bl2 = false;
                        continue block12;
                    }
                    case 1: {
                        if (!(d5 > this.sumConstraints[i3])) continue block12;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(d5 - this.sumConstraints[i3]);
                        bl2 = false;
                    }
                }
            }
        }
        if (bl2) {
            if (object instanceof Function) {
                ((Function)object).setFitterMode(true);
                Function function = (Function)object;
                for (n3 = 0; n3 < function.getParameterCount(); ++n3) {
                    if (function.isParameterFixed(n3)) continue;
                    function.setParameterValue(n3, dArray2[n3]);
                }
            }
            d2 = 0.0;
            if (object instanceof Function1D) {
                Function1D function1D = (Function1D)object;
                double[] dArray3 = null;
                if (!(this.xData instanceof DoubleStorage1D)) {
                    throw new RuntimeException("x-data storage is not a 1D array");
                }
                double[] dArray4 = ((DoubleStorage1D)this.xData).getArray();
                if (!(this.yData instanceof DoubleStorage1D)) {
                    throw new RuntimeException("y-data storage is not a 1D array");
                }
                double[] dArray5 = ((DoubleStorage1D)this.yData).getArray();
                if (!(this.weight instanceof DoubleStorage1D)) {
                    throw new RuntimeException("weight-data storage is not a 1D array");
                }
                dArray3 = ((DoubleStorage1D)this.weight).getArray();
                for (int i4 = 0; i4 < dArray5.length; ++i4) {
                    d2 += MathBase.sqr((dArray5[i4] - function1D.getValue(dArray4[i4])) / dArray3[i4]);
                }
            } else {
                FunctionND functionND = (FunctionND)object;
                double[] dArray6 = new double[this.xData.getValueDimension()];
                double[] dArray7 = new double[this.yData.getValueDimension()];
                double[] dArray8 = new double[this.yData.getValueDimension()];
                for (int i5 = 0; i5 < this.xData.getLocalStorageDim(); ++i5) {
                    dArray6 = this.xData.getLocal(i5);
                    dArray7 = this.yData.getLocal(i5);
                    dArray8 = this.weight.getLocal(i5);
                    double[] dArray9 = functionND.getValue(dArray6);
                    n2 = dArray9.length;
                    for (int i6 = 0; i6 < n2; ++i6) {
                        d2 += MathBase.sqr((dArray7[i6] - dArray9[i6]) / dArray8[i6]);
                    }
                }
            }
            this.lastSSnoConstraint = d2;
            if (object instanceof Function) {
                ((Function)object).setFitterMode(false);
            }
        }
        return d2;
    }

    protected static double halfWidth(double[] dArray, double[] dArray2) {
        double d2 = dArray2[0];
        int n2 = 0;
        int n3 = dArray.length;
        for (int i2 = 1; i2 < n3; ++i2) {
            if (!(dArray2[i2] > d2)) continue;
            d2 = dArray2[i2];
            n2 = i2;
        }
        d2 /= 2.0;
        double d3 = -1.0;
        double d4 = -1.0;
        int n4 = -1;
        if (n2 > 0) {
            n4 = n2 - 1;
            d3 = Math.abs(d2 - dArray2[n4]);
            for (int i3 = n2 - 2; i3 >= 0; --i3) {
                d4 = Math.abs(d2 - dArray2[i3]);
                if (!(d4 < d3)) continue;
                d3 = d4;
                n4 = i3;
            }
            d3 = Math.abs(dArray[n4] - dArray[n2]);
        }
        double d5 = -1.0;
        d4 = -1.0;
        int n5 = -1;
        if (n2 < n3 - 1) {
            n5 = n2 + 1;
            d5 = Math.abs(d2 - dArray2[n5]);
            for (int i4 = n2 + 2; i4 < n3; ++i4) {
                d4 = Math.abs(d2 - dArray2[i4]);
                if (!(d4 < d5)) continue;
                d5 = d4;
                n5 = i4;
            }
            d5 = Math.abs(dArray[n5] - dArray[n2]);
        }
        double d6 = 0.0;
        int n6 = 0;
        if (n4 != -1) {
            d6 += d3;
            ++n6;
        }
        if (n5 != -1) {
            d6 += d5;
            ++n6;
        }
        if (n6 == 0) {
            return Double.NaN;
        }
        return d6 /= (double)n6;
    }

    public static double[][] histogramBins(double[] dArray, double d2, double d3) {
        int n2;
        int n3;
        int n4;
        double d4 = Math.maximum(dArray);
        int n5 = (int)Math.ceil((d4 - d3) / d2);
        if (d3 + (double)n5 * d2 > d4) {
            ++n5;
        }
        int n6 = dArray.length;
        int[] nArray = new int[n6];
        for (int i2 = 0; i2 < n6; ++i2) {
            nArray[i2] = 0;
        }
        double[] dArray2 = new double[n5 + 1];
        dArray2[0] = d3;
        for (int i3 = 1; i3 <= n5; ++i3) {
            dArray2[i3] = dArray2[i3 - 1] + d2;
        }
        double[][] dArray3 = new double[2][n5];
        for (n4 = 0; n4 < n5; ++n4) {
            dArray3[0][n4] = (dArray2[n4] + dArray2[n4 + 1]) / 2.0;
            dArray3[1][n4] = 0.0;
        }
        n4 = 1;
        for (n3 = 0; n3 < n6; ++n3) {
            n4 = 1;
            n2 = 0;
            while (n4 != 0) {
                if (n2 == n5 - 1) {
                    if (dArray[n3] >= dArray2[n2] && dArray[n3] <= dArray2[n2 + 1] * (1.0 + NonLinearRegressionFitter.histTol)) {
                        double[] dArray4 = dArray3[1];
                        int n7 = n2;
                        dArray4[n7] = dArray4[n7] + 1.0;
                        nArray[n3] = 1;
                        n4 = 0;
                    }
                } else if (dArray[n3] >= dArray2[n2] && dArray[n3] < dArray2[n2 + 1]) {
                    double[] dArray5 = dArray3[1];
                    int n8 = n2;
                    dArray5[n8] = dArray5[n8] + 1.0;
                    nArray[n3] = 1;
                    n4 = 0;
                }
                if (n4 == 0) continue;
                if (n2 == n5 - 1) {
                    n4 = 0;
                    continue;
                }
                ++n2;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < n6; ++n2) {
            if (nArray[n2] != 0) continue;
            ++n3;
            System.out.println("p " + n2 + " " + dArray[n2] + " " + dArray2[0] + " " + dArray2[n5]);
        }
        if (n3 > 0) {
            System.out.println(n3 + " data points, outside histogram limits, excluded in histogramBins");
        }
        return dArray3;
    }

    public static double[][] histogramBins(double[] dArray, double d2, double d3, double d4) {
        int n2 = 0;
        int n3 = dArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(dArray[i2] <= d4)) continue;
            ++n2;
        }
        if (n2 != n3) {
            double[] dArray2 = new double[n2];
            int n4 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!(dArray[i3] <= d4)) continue;
                dArray2[n4] = dArray[i3];
                ++n4;
            }
            System.out.println(n3 - n2 + " data points, above histogram upper limit, excluded in histogramBins");
            return NonLinearRegressionFitter2.histogramBins(dArray2, d2, d3);
        }
        return NonLinearRegressionFitter2.histogramBins(dArray, d2, d3);
    }

    protected static boolean setTrueFreqWeights(VoxelArrayND voxelArrayND, VoxelArrayND voxelArrayND2) {
        int n2;
        boolean bl2 = true;
        for (n2 = 0; n2 < voxelArrayND.getLocalStorageDim(); ++n2) {
        }
        for (n2 = 0; n2 < voxelArrayND.getLocalStorageDim(); ++n2) {
            double d2 = 0.0;
            double d3 = 0.0;
        }
        return true;
    }

    protected static void sort(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = 0;
        int n3 = -1;
        int n4 = dArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (n3 < n4 - 1) {
            n2 = n3 + 1;
            for (int i2 = n3 + 2; i2 < n4; ++i2) {
                if (!(dArray[i2] < dArray[n2])) continue;
                n2 = i2;
            }
            d2 = dArray[n2];
            dArray[n2] = dArray[++n3];
            dArray[n3] = d2;
            d3 = dArray2[n2];
            dArray2[n2] = dArray2[n3];
            dArray2[n3] = d3;
            d4 = dArray3[n2];
            dArray3[n2] = dArray3[n3];
            dArray3[n3] = d4;
        }
    }
}

