/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.fitter;

import io.fair_acc.math.ArrayConversion;
import io.fair_acc.math.Math;
import io.fair_acc.math.MathBase;
import io.fair_acc.math.functions.Function;
import io.fair_acc.math.functions.Function1D;
import io.fair_acc.math.functions.FunctionND;
import io.fair_acc.math.matrix.MatrixD;
import java.util.ArrayList;
import java.util.Arrays;

public class NonLinearRegressionFitter {
    protected static double histTol = 1.0001;
    protected int nData0;
    protected int nData = 0;
    protected int nXarrays = 1;
    protected int nYarrays = 1;
    protected int nTerms = 0;
    protected int degreesOfFreedom = 0;
    protected double[][] xData = null;
    protected double[] yData = null;
    protected double[] yCalc = null;
    protected double[] weight = null;
    protected double[] residual = null;
    protected double[] residualW = null;
    protected boolean weightOpt = false;
    protected int weightFlag = 0;
    protected double[] best = null;
    protected double[] bestSd = null;
    protected double[] pseudoSd = null;
    protected double[] tValues = null;
    protected double[] pValues = null;
    protected double chiSquare = Double.NaN;
    protected double reducedChiSquare = Double.NaN;
    protected double sumOfSquares = Double.NaN;
    protected double lastSSnoConstraint = 0.0;
    protected double[][] covar = null;
    protected double[][] corrCoeff = null;
    protected double sampleR = Double.NaN;
    protected double sampleR2 = Double.NaN;
    protected double adjustedR = Double.NaN;
    protected double adjustedR2 = Double.NaN;
    protected double multipleF = Double.NaN;
    protected double adjustedF = Double.NaN;
    protected boolean linNonLin = true;
    protected boolean trueFreq = false;
    protected boolean nlrStatus = true;
    protected int scaleOpt = 0;
    protected double[] fscale = null;
    protected boolean zeroCheck = false;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected double constraintTolerance = 1.0E-4;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double[] constraints = null;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected int nMax = 3000;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fMin = -1.0;
    protected double fTol = 1.0E-9;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] step = null;
    protected double dStep = 0.5;
    protected double[][] grad = null;
    protected double delta = 1.0E-4;
    protected boolean invertFlag = true;
    protected boolean posVarFlag = true;
    protected int minTest = 0;
    protected double simplexSd = 0.0;
    protected boolean statFlag = true;
    protected boolean multipleY = false;
    protected double[] values = null;
    protected boolean[] fixed = null;
    protected boolean ignoreDofFcheck = false;
    protected boolean nFactorOption = false;

    public NonLinearRegressionFitter(double[] dArray, double[] dArray2) {
        this.nData0 = dArray2.length;
        int n2 = dArray.length;
        double[][] dArray3 = new double[1][n2];
        double[] dArray4 = new double[n2];
        System.arraycopy(dArray, 0, dArray3[0], 0, n2);
        this.weightOpt = false;
        this.weightFlag = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray4[i2] = 1.0;
        }
        this.setDefaultValues(dArray3, dArray2, dArray4);
    }

    public NonLinearRegressionFitter(double[] dArray, double[] dArray2, double[] dArray3) {
        this.nData0 = dArray2.length;
        int n2 = dArray.length;
        double[][] dArray4 = new double[1][n2];
        System.arraycopy(dArray, 0, dArray4[0], 0, n2);
        dArray3 = this.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray4, dArray2, dArray3);
    }

    public NonLinearRegressionFitter(double[] dArray, double[][] dArray2) {
        int n2;
        int n3;
        int n4;
        this.multipleY = true;
        this.nYarrays = n4 = dArray2.length;
        this.nData0 = n3 = dArray2[0].length;
        double[] dArray3 = new double[n4 * n3];
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = dArray2[i2].length;
            if (n6 != n3) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (n2 = 0; n2 < n3; ++n2) {
                dArray3[n5] = dArray2[i2][n2];
                ++n5;
            }
        }
        double[][] dArray4 = new double[1][n4 * n3];
        double[] dArray5 = new double[n4 * n3];
        n5 = 0;
        n2 = dArray.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            for (int i4 = 0; i4 < n2; ++i4) {
                dArray4[0][n5] = dArray[i4];
                dArray5[n5] = 1.0;
                ++n5;
            }
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        this.setDefaultValues(dArray4, dArray3, dArray5);
    }

    public NonLinearRegressionFitter(double[] dArray, double[][] dArray2, double[][] dArray3) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.multipleY = true;
        this.nYarrays = n5 = dArray2.length;
        this.nData0 = n4 = dArray2[0].length;
        double[] dArray4 = new double[n5 * n4];
        double[] dArray5 = new double[n5 * n4];
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = dArray2[n3].length;
            if (n7 != n4) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (n2 = 0; n2 < n4; ++n2) {
                dArray4[n6] = dArray2[n3][n2];
                dArray5[n6] = dArray3[n3][n2];
                ++n6;
            }
        }
        n3 = dArray.length;
        if (n3 != n4) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] dArray6 = new double[1][n5 * n3];
        n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                dArray6[0][n6] = dArray[i2];
                ++n6;
            }
        }
        dArray5 = this.checkForZeroWeights(dArray5);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray6, dArray4, dArray5);
    }

    public NonLinearRegressionFitter(double[][] dArray, double[] dArray2) {
        this.nData0 = dArray2.length;
        int n2 = dArray2.length;
        double[] dArray3 = new double[n2];
        this.weightOpt = false;
        this.weightFlag = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray3[i2] = 1.0;
        }
        this.setDefaultValues(dArray, dArray2, dArray3);
    }

    public NonLinearRegressionFitter(double[][] dArray, double[] dArray2, double[] dArray3) {
        this.nData0 = dArray2.length;
        dArray3 = this.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray, dArray2, dArray3);
    }

    public NonLinearRegressionFitter(double[][] dArray, double[][] dArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.multipleY = true;
        this.nYarrays = n5 = dArray2.length;
        this.nData0 = n4 = dArray2[0].length;
        int n6 = dArray.length;
        double[] dArray3 = new double[n5 * n4];
        if (n5 != n6) {
            throw new IllegalArgumentException("Multiple xData and yData arrays of different overall dimensions not supported");
        }
        double[][] dArray4 = new double[1][n5 * n4];
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            int n8 = dArray2[n3].length;
            if (n8 != n4) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            n2 = dArray[n3].length;
            if (n8 != n2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                dArray3[n7] = dArray2[n3][i2];
                dArray4[0][n7] = dArray[n3][i2];
                ++n7;
            }
        }
        n3 = dArray3.length;
        double[] dArray5 = new double[n3];
        this.weightOpt = false;
        for (n2 = 0; n2 < n3; ++n2) {
            dArray5[n2] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(dArray4, dArray3, dArray5);
    }

    public NonLinearRegressionFitter(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        this.multipleY = true;
        int n2 = dArray2.length;
        int n3 = dArray2[0].length;
        this.nYarrays = n2;
        this.nData0 = n3;
        int n4 = dArray.length;
        double[] dArray4 = new double[n2 * n3];
        double[] dArray5 = new double[n2 * n3];
        double[][] dArray6 = new double[n2 * n3][n4];
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = dArray2[i2].length;
            if (n6 != n3) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int n7 = dArray[i2].length;
            if (n6 != n7) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int i3 = 0; i3 < n3; ++i3) {
                dArray4[n5] = dArray2[i2][i3];
                dArray6[n5][i2] = dArray[i2][i3];
                dArray5[n5] = dArray3[i2][i3];
                ++n5;
            }
        }
        dArray5 = this.checkForZeroWeights(dArray5);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray6, dArray4, dArray5);
    }

    public void addConstraint(int n2, int n3, double d2) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(this.constraintMethod);
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(1);
        } else {
            int n4 = (Integer)this.penalties.get(1);
            this.penalties.set(1, ++n4);
        }
        this.penalties.add(n2);
        this.penalties.add(n3);
        this.penalties.add(d2);
        if (n2 > this.maxConstraintIndex) {
            this.maxConstraintIndex = n2;
        }
    }

    public void addConstraint(int[] nArray, double[] dArray, int n2, double d2) {
        int n3;
        int n4 = nArray.length;
        int n5 = dArray.length;
        if (n4 != n5) {
            throw new IllegalArgumentException("num of parameters, " + n4 + ", does not equal number of parameter signs, " + n5);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(this.constraintMethod);
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(1);
        } else {
            n3 = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, ++n3);
        }
        this.sumPenalties.add(n4);
        this.sumPenalties.add(nArray);
        this.sumPenalties.add(dArray);
        this.sumPenalties.add(n2);
        this.sumPenalties.add(d2);
        n3 = Math.maximum(nArray);
        if (n3 > this.maxConstraintIndex) {
            this.maxConstraintIndex = n3;
        }
    }

    public void addConstraint(int[] nArray, int[] nArray2, int n2, double d2) {
        double[] dArray = ArrayConversion.getDoubleArray(nArray2);
        this.addConstraint(nArray, dArray, n2, d2);
    }

    protected double[] checkForZeroWeights(double[] dArray) {
        this.weightOpt = true;
        int n2 = 0;
        int n3 = dArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(dArray[i2] <= 0.0)) continue;
            ++n2;
        }
        double d2 = 100.0 * (double)n2 / (double)n3;
        if (d2 > 40.0) {
            System.out.println(d2 + "% of the weights are zero or less; all weights set to 1.0");
            for (int i3 = 0; i3 < n3; ++i3) {
                dArray[i3] = 1.0;
            }
            this.weightOpt = false;
        } else if (d2 > 0.0) {
            for (int i4 = 0; i4 < n3; ++i4) {
                double d3;
                boolean bl2;
                int n4;
                if (!(dArray[i4] <= 0.0)) continue;
                if (i4 == 0) {
                    n4 = 1;
                    bl2 = true;
                    while (bl2) {
                        if (dArray[n4] > 0.0) {
                            d3 = dArray[0];
                            dArray[0] = dArray[n4];
                            System.out.println("weight at point " + i4 + ", " + d3 + ", replaced by " + dArray[i4]);
                            bl2 = false;
                            continue;
                        }
                        ++n4;
                    }
                }
                if (i4 == n3 - 1) {
                    n4 = n3 - 2;
                    bl2 = true;
                    while (bl2) {
                        if (dArray[n4] > 0.0) {
                            d3 = dArray[i4];
                            dArray[i4] = dArray[n4];
                            System.out.println("weight at point " + i4 + ", " + d3 + ", replaced by " + dArray[i4]);
                            bl2 = false;
                            continue;
                        }
                        --n4;
                    }
                }
                if (i4 <= 0 || i4 >= n3 - 2) continue;
                double d4 = 0.0;
                d3 = 0.0;
                int n5 = i4 - 1;
                boolean bl3 = true;
                while (bl3) {
                    if (dArray[n5] > 0.0) {
                        d4 = dArray[n5];
                        bl3 = false;
                        continue;
                    }
                    if (--n5 != 0) continue;
                    bl3 = false;
                }
                n5 = i4 + 1;
                bl3 = true;
                while (bl3) {
                    if (dArray[n5] > 0.0) {
                        d3 = dArray[n5];
                        bl3 = false;
                        continue;
                    }
                    if (++n5 != n3 - 1) continue;
                    bl3 = false;
                }
                double d5 = dArray[i4];
                dArray[i4] = d4 == 0.0 ? d3 : (d3 == 0.0 ? d4 : (d4 + d3) / 2.0);
                System.out.println("weight at point " + i4 + ", " + d5 + ", replaced by " + dArray[i4]);
            }
        }
        return dArray;
    }

    public double checkYallSmall(double d2, String string) {
        double d3 = 1.0;
        double d4 = (double)((int)(1.0 / d2 * 10000.0)) * 1.0E-4;
        if (d2 < 1.0E-4) {
            System.out.println(string + " fitting: The ordinate axis (y axis) has been rescaled by " + d4 + " to reduce rounding errors");
            for (int i2 = 0; i2 < this.nData; ++i2) {
                int n2 = i2;
                this.yData[n2] = this.yData[n2] * d4;
                if (!this.weightOpt) continue;
                int n3 = i2;
                this.weight[n3] = this.weight[n3] * d4;
            }
            d3 = d4;
        }
        return d3;
    }

    public void checkZeroNeg(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.nData; ++i2) {
            if (!(dArray2[i2] <= 0.0)) continue;
            if (i2 <= n2) {
                boolean bl2 = true;
                n2 = i2;
                while (bl2) {
                    if (++n2 >= this.nData) {
                        throw new ArithmeticException("all zero cumulative data!!");
                    }
                    if (!(dArray2[n2] > 0.0)) continue;
                    dArray2[i2] = dArray2[n2];
                    dArray[i2] = dArray[n2];
                    dArray3[i2] = dArray3[n2];
                    bl2 = false;
                }
                continue;
            }
            if (i2 == this.nData - 1) {
                dArray2[i2] = dArray2[i2 - 1];
                dArray[i2] = dArray[i2 - 1];
                dArray3[i2] = dArray3[i2 - 1];
                continue;
            }
            dArray2[i2] = (dArray2[i2 - 1] + dArray2[i2 + 1]) / 2.0;
            dArray[i2] = (dArray[i2 - 1] + dArray[i2 + 1]) / 2.0;
            dArray3[i2] = (dArray3[i2 - 1] + dArray3[i2 + 1]) / 2.0;
        }
    }

    public void enterData(double[] dArray, double[] dArray2) {
        this.nData0 = dArray2.length;
        int n2 = dArray.length;
        double[][] dArray3 = new double[1][n2];
        double[] dArray4 = new double[n2];
        System.arraycopy(dArray, 0, dArray3[0], 0, n2);
        this.weightOpt = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray4[i2] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(dArray3, dArray2, dArray4);
    }

    public void enterData(double[] dArray, double[] dArray2, double[] dArray3) {
        this.nData0 = dArray2.length;
        int n2 = dArray.length;
        double[][] dArray4 = new double[1][n2];
        System.arraycopy(dArray, 0, dArray4[0], 0, n2);
        dArray3 = this.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray4, dArray2, dArray3);
    }

    public void enterData(double[] dArray, double[][] dArray2) {
        int n2;
        this.multipleY = true;
        int n3 = dArray2.length;
        int n4 = dArray2[0].length;
        this.nYarrays = n3;
        this.nData0 = n4;
        double[] dArray3 = new double[n3 * n4];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = dArray2[i2].length;
            if (n6 != n4) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (n2 = 0; n2 < n4; ++n2) {
                dArray3[n5] = dArray2[i2][n2];
                ++n5;
            }
        }
        double[][] dArray4 = new double[1][n3 * n4];
        double[] dArray5 = new double[n3 * n4];
        n5 = 0;
        n2 = dArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i4 = 0; i4 < n2; ++i4) {
                dArray4[0][n5] = dArray[i4];
                dArray5[n5] = 1.0;
                ++n5;
            }
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        this.setDefaultValues(dArray4, dArray3, dArray5);
    }

    public void enterData(double[] dArray, double[][] dArray2, double[][] dArray3) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.multipleY = true;
        this.nYarrays = n5 = dArray2.length;
        this.nData0 = n4 = dArray2[0].length;
        double[] dArray4 = new double[n5 * n4];
        double[] dArray5 = new double[n5 * n4];
        int n6 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = dArray2[n3].length;
            if (n7 != n4) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (n2 = 0; n2 < n4; ++n2) {
                dArray4[n6] = dArray2[n3][n2];
                dArray5[n6] = dArray3[n3][n2];
                ++n6;
            }
        }
        n3 = dArray.length;
        if (n3 != n4) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] dArray6 = new double[1][n5 * n3];
        n6 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                dArray6[0][n6] = dArray[i2];
                ++n6;
            }
        }
        dArray5 = this.checkForZeroWeights(dArray5);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray6, dArray4, dArray5);
    }

    public void enterData(double[][] dArray, double[] dArray2) {
        this.nData0 = dArray2.length;
        int n2 = dArray2.length;
        double[] dArray3 = new double[n2];
        this.weightOpt = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray3[i2] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(dArray, dArray2, dArray3);
    }

    public void enterData(double[][] dArray, double[] dArray2, double[] dArray3) {
        this.nData0 = dArray2.length;
        this.weightOpt = true;
        dArray3 = this.checkForZeroWeights(dArray3);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray, dArray2, dArray3);
    }

    public void enterData(double[][] dArray, double[][] dArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.multipleY = true;
        this.nYarrays = n5 = dArray2.length;
        this.nData0 = n4 = dArray2[0].length;
        int n6 = dArray.length;
        double[] dArray3 = new double[n5 * n4];
        double[][] dArray4 = new double[n5 * n4][n6];
        int n7 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            int n8 = dArray2[n3].length;
            if (n8 != n4) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            n2 = dArray[n3].length;
            if (n8 != n2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                dArray3[n7] = dArray2[n3][i2];
                dArray4[n7][n3] = dArray[n3][i2];
                ++n7;
            }
        }
        n3 = dArray3.length;
        double[] dArray5 = new double[n3];
        this.weightOpt = false;
        for (n2 = 0; n2 < n3; ++n2) {
            dArray5[n2] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(dArray4, dArray3, dArray5);
    }

    public void enterData(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        int n2;
        int n3;
        this.multipleY = true;
        this.nYarrays = n3 = dArray2.length;
        this.nData0 = n2 = dArray2[0].length;
        int n4 = dArray.length;
        double[] dArray4 = new double[n3 * n2];
        double[] dArray5 = new double[n3 * n2];
        double[][] dArray6 = new double[n3 * n2][n4];
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = dArray2[i2].length;
            if (n6 != n2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int n7 = dArray[i2].length;
            if (n6 != n7) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray4[n5] = dArray2[i2][i3];
                dArray6[n5][i2] = dArray[i2][i3];
                dArray5[n5] = dArray3[i2][i3];
                ++n5;
            }
        }
        dArray5 = this.checkForZeroWeights(dArray5);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(dArray6, dArray4, dArray5);
    }

    protected void generalLinearStats(double[][] dArray) {
        int n2;
        double[][] dArray2 = new double[this.nTerms][this.nTerms];
        this.covar = new double[this.nTerms][this.nTerms];
        this.corrCoeff = new double[this.nTerms][this.nTerms];
        double[] dArray3 = new double[this.nTerms];
        double[] dArray4 = new double[this.nTerms];
        if (this.nTerms >= 0) {
            System.arraycopy(this.best, 0, dArray4, 0, this.nTerms);
        }
        if (this.weightOpt) {
            this.chiSquare = 0.0;
        }
        this.sumOfSquares = 0.0;
        for (int i2 = 0; i2 < this.nData; ++i2) {
            double d2 = 0.0;
            for (int i3 = 0; i3 < this.nTerms; ++i3) {
                d2 += dArray4[i3] * dArray[i3][i2];
            }
            this.yCalc[i2] = d2;
            this.residual[i2] = d2 -= this.yData[i2];
            this.residualW[i2] = d2 / this.weight[i2];
            if (this.weightOpt) {
                this.chiSquare += MathBase.sqr(d2 / this.weight[i2]);
            }
            this.sumOfSquares += d2 * d2;
        }
        if (this.weightOpt || this.trueFreq) {
            this.reducedChiSquare = this.chiSquare / (double)this.degreesOfFreedom;
        }
        double d3 = this.sumOfSquares / (double)this.degreesOfFreedom;
        double d4 = Math.sqrt(d3);
        if (this.sumOfSquares == 0.0) {
            for (n2 = 0; n2 < this.nTerms; ++n2) {
                dArray3[n2] = 0.0;
                for (var17_13 = 0; var17_13 < this.nTerms; ++var17_13) {
                    this.covar[n2][var17_13] = 0.0;
                    this.corrCoeff[n2][var17_13] = n2 == var17_13 ? 1.0 : 0.0;
                }
            }
        } else {
            int n3;
            for (int i4 = 0; i4 < this.nTerms; ++i4) {
                for (var17_13 = 0; var17_13 < this.nTerms; ++var17_13) {
                    double d5 = 0.0;
                    for (n3 = 0; n3 < this.nData; ++n3) {
                        double d6 = this.weightOpt ? this.weight[n3] : d4;
                        d5 += dArray[i4][n3] * dArray[var17_13][n3] / (d6 * d6);
                    }
                    dArray2[var17_13][i4] = d5;
                }
            }
            MatrixD matrixD = new MatrixD(dArray2);
            matrixD = matrixD.inverse();
            double[][] dArray5 = matrixD.getArrayCopy();
            for (var17_13 = 0; var17_13 < this.nTerms; ++var17_13) {
                dArray3[var17_13] = Math.sqrt(dArray5[var17_13][var17_13]);
            }
            for (var17_13 = 0; var17_13 < this.nTerms; ++var17_13) {
                System.arraycopy(dArray5[var17_13], 0, this.covar[var17_13], 0, this.nTerms);
            }
            for (var17_13 = 0; var17_13 < this.nTerms; ++var17_13) {
                for (n3 = 0; n3 < this.nTerms; ++n3) {
                    this.corrCoeff[var17_13][n3] = var17_13 == n3 ? 1.0 : this.covar[var17_13][n3] / (dArray3[var17_13] * dArray3[n3]);
                }
            }
        }
        for (n2 = 0; n2 < this.nTerms; ++n2) {
            this.bestSd[n2] = dArray3[n2];
            this.tValues[n2] = this.best[n2] / this.bestSd[n2];
            double d7 = Math.abs(this.tValues[n2]);
            this.pValues[n2] = 1.0 - Math.student(d7, this.degreesOfFreedom);
        }
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            this.sampleR = Math.correlationCoefficient(this.xData[0], this.yData, this.weight);
            this.sampleR2 = this.sampleR * this.sampleR;
            this.adjustedR = this.sampleR;
            this.adjustedR2 = this.sampleR2;
        } else {
            this.multCorrelCoeff(this.yData, this.yCalc, this.weight);
        }
    }

    public double getAdjustedR() {
        return this.adjustedR;
    }

    public double getAdjustedR2() {
        return this.adjustedR2;
    }

    public double[] getBestEstimates() {
        return (double[])this.best.clone();
    }

    public double[] getBestEstimatesErrors() {
        return (double[])this.bestSd.clone();
    }

    public double[] getBestEstimatesStandardDeviations() {
        return (double[])this.bestSd.clone();
    }

    public double getChiSquare() {
        double d2;
        if (this.weightOpt) {
            d2 = this.chiSquare;
        } else {
            System.out.println("Chi Square cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Chi Square");
            d2 = -1.0;
        }
        return d2;
    }

    public double getchiSquareProb() {
        double d2;
        if (this.weightOpt) {
            d2 = 1.0 - Math.chisquareQuantile(this.chiSquare, this.nData - this.nXarrays);
        } else {
            System.out.println("A Chi Square probability cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Reduced Chi Square");
            d2 = -1.0;
        }
        return d2;
    }

    public double[] getCoeff() {
        return (double[])this.best.clone();
    }

    public double[] getCoeffSd() {
        return (double[])this.bestSd.clone();
    }

    public double[] getCoeffVar() {
        double[] dArray = new double[this.nTerms];
        for (int i2 = 0; i2 < this.nTerms; ++i2) {
            dArray[i2] = this.bestSd[i2] * 100.0 / this.best[i2];
        }
        return dArray;
    }

    public double[][] getCorrCoeffMatrix() {
        return this.corrCoeff;
    }

    public double[][] getCovMatrix() {
        return this.covar;
    }

    public double getDegFree() {
        return this.degreesOfFreedom;
    }

    public double getDelta() {
        return this.delta;
    }

    public double[][] getGrad() {
        return this.grad;
    }

    public boolean getInversionCheck() {
        return this.invertFlag;
    }

    public int getMinTest() {
        return this.minTest;
    }

    public double getMultipleF() {
        if (this.nXarrays == 1) {
            System.out.println("NonLinearRegression.getMultipleF - The regression is not a multiple regression: NaN returned");
        }
        return this.multipleF;
    }

    public int getNiter() {
        return this.nIter;
    }

    public boolean getNlrStatus() {
        return this.nlrStatus;
    }

    public int getNmax() {
        return this.nMax;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public boolean getPosVarCheck() {
        return this.posVarFlag;
    }

    public double[] getPseudoErrors() {
        return (double[])this.pseudoSd.clone();
    }

    public double[] getPseudoSd() {
        return (double[])this.pseudoSd.clone();
    }

    public double[] getPvalues() {
        return (double[])this.pValues.clone();
    }

    public double getReducedChiSquare() {
        double d2;
        if (this.weightOpt) {
            d2 = this.reducedChiSquare;
        } else {
            System.out.println("A Reduced Chi Square cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Reduced Chi Square");
            d2 = -1.0;
        }
        return d2;
    }

    public double[] getResiduals() {
        double[] dArray = new double[this.nData];
        for (int i2 = 0; i2 < this.nData; ++i2) {
            dArray[i2] = this.yData[i2] - this.yCalc[i2];
        }
        return dArray;
    }

    public double getSampleR() {
        return this.sampleR;
    }

    public double getSampleR2() {
        return this.sampleR2;
    }

    public double[] getScale() {
        return this.fscale;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public double getTolerance() {
        return this.fTol;
    }

    public boolean getTrueFreq() {
        return this.trueFreq;
    }

    public double[] getTvalues() {
        return (double[])this.tValues.clone();
    }

    public double[] getWeightedResiduals() {
        double[] dArray = new double[this.nData];
        for (int i2 = 0; i2 < this.nData; ++i2) {
            dArray[i2] = (this.yData[i2] - this.yCalc[i2]) / this.weight[i2];
        }
        return dArray;
    }

    public double[][] getXdata() {
        return (double[][])this.xData.clone();
    }

    public double[] getYcalc() {
        double[] dArray = new double[this.nData];
        if (this.nData >= 0) {
            System.arraycopy(this.yCalc, 0, dArray, 0, this.nData);
        }
        return dArray;
    }

    public double[] getYdata() {
        return (double[])this.yData.clone();
    }

    public void ignoreDofFcheck() {
        this.ignoreDofFcheck = true;
    }

    public boolean infinityCheck(double d2, int n2) {
        boolean bl2 = false;
        if (d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
            int n3 = n2 + 1;
            if (n2 == this.nData - 1) {
                n3 = n2 - 1;
            }
            this.xData[0][n2] = this.xData[0][n3];
            this.yData[n2] = this.yData[n3];
            this.weight[n2] = this.weight[n3];
            System.out.println("An infinty has been removed at point " + n2);
            bl2 = true;
        }
        return bl2;
    }

    protected void multCorrelCoeff(double[] dArray, double[] dArray2, double[] dArray3) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.nData; ++i2) {
            d2 += 1.0 / MathBase.sqr(dArray3[i2]);
        }
        double d3 = 0.0;
        for (int i3 = 0; i3 < this.nData; ++i3) {
            d3 += dArray[i3] / MathBase.sqr(dArray3[i3]);
        }
        d3 /= d2;
        double d4 = 0.0;
        double[] dArray4 = new double[this.nData];
        for (int i4 = 0; i4 < this.nData; ++i4) {
            dArray4[i4] = dArray[i4] - dArray2[i4];
            d4 += dArray4[i4] / MathBase.sqr(dArray3[i4]);
        }
        d4 /= d2;
        double d5 = 0.0;
        for (int i5 = 0; i5 < this.nData; ++i5) {
            d5 += MathBase.sqr((dArray[i5] - d3) / dArray3[i5]);
        }
        double d6 = 0.0;
        for (int i6 = 0; i6 < this.nData; ++i6) {
            d6 += MathBase.sqr((dArray4[i6] - d4) / dArray3[i6]);
        }
        this.sampleR2 = 1.0 - d6 / d5;
        this.sampleR = Math.sqrt(this.sampleR2);
        this.adjustedR2 = ((double)(this.nData - 1) * this.sampleR2 - (double)this.nXarrays) / (double)(this.nData - this.nXarrays - 1);
        this.adjustedR = Math.sqrt(this.adjustedR2);
        if (this.nXarrays > 1) {
            this.multipleF = this.sampleR2 * (double)(this.nData - this.nXarrays) / ((1.0 - this.sampleR2) * (double)(this.nXarrays - 1));
            this.adjustedF = this.adjustedR2 * (double)(this.nData - this.nXarrays) / ((1.0 - this.adjustedR2) * (double)(this.nXarrays - 1));
        }
    }

    protected void nelderMead(Object object, double[] dArray, double[] dArray2, double d2, int n2) {
        int n3;
        int n4;
        Object object2;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = dArray.length;
        if (this.maxConstraintIndex >= n9) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + n9 + ")");
        }
        this.nlrStatus = true;
        this.nTerms = n9;
        int n10 = n9 + 1;
        this.lastSSnoConstraint = 0.0;
        if (this.scaleOpt < 2) {
            this.fscale = new double[n9];
        }
        if (this.scaleOpt == 2 && this.fscale.length != dArray.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("step array length " + dArray2.length + " and initial estimate array length " + dArray.length + " are of different");
        }
        for (n8 = 0; n8 < n9; ++n8) {
            if (dArray2[n8] != 0.0) continue;
            throw new IllegalArgumentException("step " + n8 + " size is zero");
        }
        if (this.ignoreDofFcheck) {
            this.bestSd = new double[this.nTerms];
            this.pseudoSd = new double[this.nTerms];
            this.tValues = new double[this.nTerms];
            this.pValues = new double[this.nTerms];
            this.covar = new double[this.nTerms][this.nTerms];
            this.corrCoeff = new double[this.nTerms][this.nTerms];
            for (n8 = 0; n8 < this.nTerms; ++n8) {
                this.bestSd[n8] = Double.NaN;
                this.pseudoSd[n8] = Double.NaN;
                for (int i2 = 0; i2 < this.nTerms; ++i2) {
                    this.covar[n8][i2] = Double.NaN;
                    this.corrCoeff[n8][i2] = Double.NaN;
                }
            }
        }
        this.startH = new double[n9];
        this.step = new double[n9];
        double[] dArray3 = new double[n9];
        this.best = new double[n9];
        this.bestSd = new double[n9];
        this.tValues = new double[n9];
        this.pValues = new double[n9];
        double[][] dArray4 = new double[n10][n10];
        double[] dArray5 = new double[n10];
        double[] dArray6 = new double[n10];
        double[] dArray7 = new double[n10];
        double[] dArray8 = new double[n10];
        double d3 = 0.0;
        for (n7 = 0; n7 < this.nData; ++n7) {
            d3 += Math.abs(this.yData[n7]);
        }
        d3 /= (double)this.nData;
        if (this.penalty) {
            Integer n11 = (Integer)this.penalties.get(1);
            this.nConstraints = n11;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            n6 = 2;
            for (n5 = 0; n5 < this.nConstraints; ++n5) {
                n11 = (Integer)this.penalties.get(n6);
                this.penaltyParam[n5] = n11;
                n11 = (Integer)this.penalties.get(++n6);
                this.penaltyCheck[n5] = n11;
                object2 = (Double)this.penalties.get(++n6);
                this.constraints[n5] = (Double)object2;
                ++n6;
            }
        }
        if (this.sumPenalty) {
            Integer n12 = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = n12;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            n4 = 2;
            for (int i3 = 0; i3 < this.nSumConstraints; ++i3) {
                n12 = (Integer)this.sumPenalties.get(n4);
                this.sumPenaltyNumber[i3] = n12;
                object2 = (int[])this.sumPenalties.get(++n4);
                this.sumPenaltyParam[i3] = (int[])object2;
                double[] dArray9 = (double[])this.sumPenalties.get(++n4);
                this.sumPlusOrMinus[i3] = dArray9;
                n12 = (Integer)this.sumPenalties.get(++n4);
                this.sumPenaltyCheck[i3] = n12;
                Double d4 = (Double)this.sumPenalties.get(++n4);
                this.sumConstraints[i3] = d4;
                ++n4;
            }
        }
        System.arraycopy(dArray, 0, this.startH, 0, n9);
        if (this.scaleOpt > 0) {
            n7 = 0;
            for (int i4 = 0; i4 < n9; ++i4) {
                if (dArray[i4] != 0.0) continue;
                n7 = 1;
                break;
            }
            if (n7 != 0) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                for (n7 = 0; n7 < n9; ++n7) {
                    this.fscale[n7] = 1.0;
                }
                break;
            }
            case 1: {
                for (n7 = 0; n7 < n9; ++n7) {
                    this.fscale[n7] = 1.0 / dArray[n7];
                    dArray2[n7] = dArray2[n7] / dArray[n7];
                    dArray[n7] = 1.0;
                }
                break;
            }
            case 2: {
                for (n7 = 0; n7 < n9; ++n7) {
                    int n13 = n7;
                    dArray2[n13] = dArray2[n13] * this.fscale[n7];
                    int n14 = n7;
                    dArray[n14] = dArray[n14] * this.fscale[n7];
                }
                break;
            }
        }
        this.fTol = d2;
        this.nMax = n2;
        this.nIter = 0;
        for (n7 = 0; n7 < n9; ++n7) {
            this.step[n7] = dArray2[n7];
            this.fscale[n7] = this.fscale[n7];
        }
        for (n6 = 0; n6 < n9; ++n6) {
            double d5;
            dArray7[n6] = d5 = dArray[n6];
            dArray8[n6] = d5;
            dArray3[n6] = d5;
        }
        n6 = this.konvge;
        for (n5 = 0; n5 < n9; ++n5) {
            dArray4[n5][n10 - 1] = dArray[n5];
        }
        dArray5[n10 - 1] = this.sumSquares(object, dArray);
        for (n5 = 0; n5 < n9; ++n5) {
            dArray[n5] = dArray[n5] + dArray2[n5];
            for (n4 = 0; n4 < n9; ++n4) {
                dArray4[n4][n5] = dArray[n4];
            }
            dArray5[n5] = this.sumSquares(object, dArray);
            dArray[n5] = dArray[n5] - dArray2[n5];
        }
        double d6 = 0.0;
        int n15 = 0;
        boolean bl2 = true;
        while (bl2) {
            int n16;
            double d7;
            double d8;
            d6 = d8 = dArray5[0];
            n15 = 0;
            int n17 = 0;
            for (n3 = 1; n3 < n10; ++n3) {
                if (dArray5[n3] < d8) {
                    d8 = dArray5[n3];
                    n15 = n3;
                }
                if (!(dArray5[n3] > d6)) continue;
                d6 = dArray5[n3];
                n17 = n3;
            }
            for (n3 = 0; n3 < n9; ++n3) {
                d7 = 0.0;
                for (n16 = 0; n16 < n10; ++n16) {
                    d7 += dArray4[n3][n16];
                }
                dArray6[n3] = (d7 -= dArray4[n3][n17]) / (double)n9;
            }
            for (n3 = 0; n3 < n9; ++n3) {
                dArray7[n3] = (1.0 + this.rCoeff) * dArray6[n3] - this.rCoeff * dArray4[n3][n17];
            }
            double d9 = this.sumSquares(object, dArray7);
            ++this.nIter;
            if (d9 < d8) {
                for (n3 = 0; n3 < n9; ++n3) {
                    dArray8[n3] = dArray7[n3] * (1.0 + this.eCoeff) - this.eCoeff * dArray6[n3];
                }
                var24_33 = this.sumSquares(object, dArray8);
                ++this.nIter;
                if (var24_33 < d8) {
                    for (n3 = 0; n3 < n9; ++n3) {
                        dArray4[n3][n17] = dArray8[n3];
                    }
                    dArray5[n17] = var24_33;
                } else {
                    for (n3 = 0; n3 < n9; ++n3) {
                        dArray4[n3][n17] = dArray7[n3];
                    }
                    dArray5[n17] = d9;
                }
            } else {
                int n18 = 0;
                for (n3 = 0; n3 < n10; ++n3) {
                    if (n3 == n17 || !(d9 > dArray5[n3])) continue;
                    ++n18;
                }
                if (n18 == n9) {
                    if (d9 <= dArray5[n17]) {
                        for (n3 = 0; n3 < n9; ++n3) {
                            dArray4[n3][n17] = dArray7[n3];
                        }
                        dArray5[n17] = d9;
                    }
                    for (n3 = 0; n3 < n9; ++n3) {
                        dArray8[n3] = this.cCoeff * dArray4[n3][n17] + (1.0 - this.cCoeff) * dArray6[n3];
                    }
                    var24_33 = this.sumSquares(object, dArray8);
                    ++this.nIter;
                    if (var24_33 > dArray5[n17]) {
                        for (n3 = 0; n3 < n10; ++n3) {
                            for (n16 = 0; n16 < n9; ++n16) {
                                dArray4[n16][n3] = 0.5 * (dArray4[n16][n3] + dArray4[n16][n15]);
                                dArray3[n16] = dArray4[n16][n3];
                            }
                            dArray5[n3] = this.sumSquares(object, dArray3);
                        }
                        this.nIter += n10;
                    } else {
                        for (n3 = 0; n3 < n9; ++n3) {
                            dArray4[n3][n17] = dArray8[n3];
                        }
                        dArray5[n17] = var24_33;
                    }
                } else {
                    for (n3 = 0; n3 < n9; ++n3) {
                        dArray4[n3][n17] = dArray7[n3];
                    }
                    dArray5[n17] = d9;
                }
            }
            double d10 = 0.0;
            d6 = dArray5[0];
            n15 = 0;
            for (n3 = 0; n3 < n10; ++n3) {
                d10 += dArray5[n3];
                if (!(d6 > dArray5[n3])) continue;
                d6 = dArray5[n3];
                n15 = n3;
            }
            d10 /= (double)n10;
            double d11 = 0.0;
            for (n3 = 0; n3 < n10; ++n3) {
                d7 = dArray5[n3] - d10;
                d11 += d7 * d7;
            }
            double d12 = Math.sqrt(d11 / (double)n9);
            switch (this.minTest) {
                case 0: {
                    if (!(d12 < d2)) break;
                    bl2 = false;
                    break;
                }
                case 1: {
                    if (!(Math.sqrt(d6 / (double)this.degreesOfFreedom) < d3 * d2)) break;
                    bl2 = false;
                }
            }
            this.sumOfSquares = d6;
            if (!bl2) {
                for (n3 = 0; n3 < n9; ++n3) {
                    dArray3[n3] = dArray4[n3][n15];
                }
                dArray5[n10 - 1] = d6;
                this.simplexSd = d12;
                if (--n6 > 0) {
                    bl2 = true;
                    for (n3 = 0; n3 < n9; ++n3) {
                        dArray3[n3] = dArray3[n3] + dArray2[n3];
                        for (n16 = 0; n16 < n9; ++n16) {
                            dArray4[n16][n3] = dArray3[n16];
                        }
                        dArray5[n3] = this.sumSquares(object, dArray3);
                        dArray3[n3] = dArray3[n3] - dArray2[n3];
                    }
                }
            }
            if (!bl2 || this.nIter <= this.nMax) continue;
            System.out.println("Maximum iteration number reached, in Regression.simplex(...)");
            System.out.println("without the convergence criterion being satisfied");
            System.out.println("Current parameter estimates and sum of squares values returned");
            this.nlrStatus = false;
            for (n3 = 0; n3 < n9; ++n3) {
                dArray3[n3] = dArray4[n3][n15];
            }
            dArray5[n10 - 1] = d6;
            bl2 = false;
        }
        for (n3 = 0; n3 < n9; ++n3) {
            dArray3[n3] = dArray4[n3][n15];
            this.best[n3] = dArray3[n3] / this.fscale[n3];
            this.fscale[n3] = 1.0;
        }
        this.fMin = d6;
        this.kRestart = this.konvge - n6;
        if (this.statFlag) {
            if (!this.ignoreDofFcheck) {
                this.pseudoLinearStats(object);
            }
        } else {
            for (n3 = 0; n3 < n9; ++n3) {
                this.bestSd[n3] = Double.NaN;
            }
        }
    }

    protected int pseudoLinearStats(Object object) {
        int n2;
        int n3;
        double d2;
        double d3;
        double d4;
        int n4;
        int n5 = 0;
        int n6 = this.nTerms;
        double[] dArray = new double[n6];
        double[] dArray2 = new double[n6];
        double[] dArray3 = new double[this.nXarrays];
        double[][] dArray4 = new double[n6][n6];
        this.pseudoSd = new double[n6];
        this.grad = new double[n6][2];
        this.covar = new double[n6][n6];
        this.corrCoeff = new double[n6][n6];
        double[] dArray5 = (double[])this.best.clone();
        for (n4 = 0; n4 < n6; ++n4) {
            System.arraycopy(dArray5, 0, dArray, 0, n6);
            d4 = dArray5[n4];
            if (d4 == 0.0) {
                d4 = this.step[n4];
                this.zeroCheck = true;
            }
            dArray[n4] = d4 * (1.0 - this.delta);
            this.lastSSnoConstraint = this.sumOfSquares;
            d3 = this.sumSquares(object, dArray);
            dArray[n4] = d4 * (1.0 + this.delta);
            this.lastSSnoConstraint = this.sumOfSquares;
            d2 = this.sumSquares(object, dArray);
            this.grad[n4][0] = (this.fMin - d3) / Math.abs(this.delta * d4);
            this.grad[n4][1] = (d2 - this.fMin) / Math.abs(this.delta * d4);
        }
        this.lastSSnoConstraint = this.sumOfSquares;
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                System.arraycopy(dArray5, 0, dArray, 0, n6);
                d4 = dArray[n4];
                if (d4 == 0.0) {
                    d4 = this.step[n4];
                    this.zeroCheck = true;
                }
                dArray[n4] = d4 * (1.0 + this.delta / 2.0);
                d4 = dArray[n3];
                if (d4 == 0.0) {
                    d4 = this.step[n3];
                    this.zeroCheck = true;
                }
                dArray[n3] = d4 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                d3 = this.sumSquares(object, dArray);
                dArray[n4] = dArray5[n4];
                dArray[n3] = dArray5[n3];
                d4 = dArray[n4];
                if (d4 == 0.0) {
                    d4 = this.step[n4];
                    this.zeroCheck = true;
                }
                dArray[n4] = d4 * (1.0 - this.delta / 2.0);
                d4 = dArray[n3];
                if (d4 == 0.0) {
                    d4 = this.step[n3];
                    this.zeroCheck = true;
                }
                dArray[n3] = d4 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                d2 = this.sumSquares(object, dArray);
                dArray[n4] = dArray5[n4];
                dArray[n3] = dArray5[n3];
                d4 = dArray[n4];
                if (d4 == 0.0) {
                    d4 = this.step[n4];
                    this.zeroCheck = true;
                }
                dArray[n4] = d4 * (1.0 + this.delta / 2.0);
                d4 = dArray[n3];
                if (d4 == 0.0) {
                    d4 = this.step[n3];
                    this.zeroCheck = true;
                }
                dArray[n3] = d4 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                double d5 = this.sumSquares(object, dArray);
                dArray[n4] = dArray5[n4];
                dArray[n3] = dArray5[n3];
                d4 = dArray[n4];
                if (d4 == 0.0) {
                    d4 = this.step[n4];
                    this.zeroCheck = true;
                }
                dArray[n4] = d4 * (1.0 - this.delta / 2.0);
                d4 = dArray[n3];
                if (d4 == 0.0) {
                    d4 = this.step[n3];
                    this.zeroCheck = true;
                }
                dArray[n3] = d4 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                double d6 = this.sumSquares(object, dArray);
                dArray4[n4][n3] = (d3 - d2 - d5 + d6) / (this.delta * this.delta);
            }
        }
        if (object instanceof Function) {
            ((Function)object).setFitterMode(true);
            Function function = (Function)object;
            for (n3 = 0; n3 < function.getParameterCount(); ++n3) {
                if (function.isParameterFixed(n3)) continue;
                function.setParameterValue(n3, dArray5[n3]);
            }
        }
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i2 = 0; i2 < this.nData; ++i2) {
            for (int i3 = 0; i3 < this.nXarrays; ++i3) {
                dArray3[i3] = this.xData[i3][i2];
            }
            this.yCalc[i2] = this.multipleY ? ((FunctionND)object).getValue(dArray3, i2) : ((Function1D)object).getValue(dArray3[0]);
            this.residual[i2] = this.yCalc[i2] - this.yData[i2];
            d7 += MathBase.sqr(this.residual[i2]);
            this.residualW[i2] = this.residual[i2] / this.weight[i2];
            d8 += MathBase.sqr(this.residualW[i2]);
        }
        if (object instanceof Function) {
            ((Function)object).setFitterMode(false);
        }
        this.sumOfSquares = d7;
        if (this.weightOpt || this.trueFreq) {
            this.chiSquare = d8;
            this.reducedChiSquare = d8 / (double)(this.nData - n6);
        }
        double d9 = 1.0;
        if (!this.weightOpt && !this.trueFreq) {
            d9 = this.sumOfSquares / (double)(this.nData - n6);
        }
        for (n2 = 0; n2 < n6; ++n2) {
            this.pseudoSd[n2] = 2.0 * this.delta * d9 * Math.abs(dArray5[n2]) / (this.grad[n2][1] - this.grad[n2][0]);
            this.pseudoSd[n2] = this.pseudoSd[n2] >= 0.0 ? Math.sqrt(this.pseudoSd[n2]) : Double.NaN;
        }
        if (n6 == 1) {
            d4 = dArray5[0];
            if (d4 == 0.0) {
                d4 = this.step[0];
            }
            dArray4[0][0] = 1.0 / dArray4[0][0];
            this.covar[0][0] = dArray4[0][0] * d9 * d4 * d4;
            if (this.covar[0][0] >= 0.0) {
                dArray2[0] = Math.sqrt(this.covar[0][0]);
                this.corrCoeff[0][0] = 1.0;
            } else {
                dArray2[0] = Double.NaN;
                this.corrCoeff[0][0] = Double.NaN;
                this.posVarFlag = false;
            }
        } else {
            MatrixD matrixD = new MatrixD(dArray4);
            this.invertFlag = true;
            matrixD = matrixD.pseudoInverse(1.0E12);
            if (!this.invertFlag) {
                --n5;
            }
            dArray4 = matrixD.getArrayCopy();
            this.posVarFlag = true;
            if (this.invertFlag) {
                for (var28_24 = 0; var28_24 < n6; ++var28_24) {
                    d4 = dArray5[var28_24];
                    if (d4 == 0.0) {
                        d4 = this.step[var28_24];
                    }
                    for (var29_27 = var28_24; var29_27 < n6; ++var29_27) {
                        double d10 = dArray5[var29_27];
                        if (d10 == 0.0) {
                            d10 = this.step[var29_27];
                        }
                        this.covar[var28_24][var29_27] = 2.0 * dArray4[var28_24][var29_27] * d9 * d4 * d10;
                        this.covar[var29_27][var28_24] = this.covar[var28_24][var29_27];
                    }
                    if (this.covar[var28_24][var28_24] >= 0.0) {
                        dArray2[var28_24] = Math.sqrt(this.covar[var28_24][var28_24]);
                        continue;
                    }
                    dArray2[var28_24] = Double.NaN;
                    this.posVarFlag = false;
                }
                for (var28_24 = 0; var28_24 < n6; ++var28_24) {
                    for (var29_27 = 0; var29_27 < n6; ++var29_27) {
                        this.corrCoeff[var28_24][var29_27] = Double.isFinite(dArray2[var28_24]) && Double.isFinite(dArray2[var29_27]) ? this.covar[var28_24][var29_27] / (dArray2[var28_24] * dArray2[var29_27]) : Double.NaN;
                    }
                }
            } else {
                for (var28_24 = 0; var28_24 < n6; ++var28_24) {
                    for (var29_27 = 0; var29_27 < n6; ++var29_27) {
                        this.covar[var28_24][var29_27] = Double.NaN;
                        this.corrCoeff[var28_24][var29_27] = Double.NaN;
                    }
                    dArray2[var28_24] = Double.NaN;
                    this.posVarFlag = false;
                }
            }
        }
        if (!this.posVarFlag) {
            --n5;
        }
        for (n2 = 0; n2 < this.nTerms; ++n2) {
            this.bestSd[n2] = dArray2[n2];
            this.tValues[n2] = this.best[n2] / this.bestSd[n2];
            double d11 = Math.abs(this.tValues[n2]);
            this.pValues[n2] = 1.0 - Math.student(d11, this.degreesOfFreedom);
        }
        this.multCorrelCoeff(this.yData, this.yCalc, this.weight);
        return n5;
    }

    public void removeConstraints() {
        int n2;
        if (!this.penalties.isEmpty()) {
            n2 = this.penalties.size();
            this.penalties.subList(0, n2).clear();
        }
        this.penalty = false;
        this.nConstraints = 0;
        if (!this.sumPenalties.isEmpty()) {
            n2 = this.sumPenalties.size();
            this.sumPenalties.subList(0, n2).clear();
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
    }

    public void setConstraintTolerance(double d2) {
        this.constraintTolerance = d2;
    }

    protected void setDefaultValues(double[][] dArray, double[] dArray2, double[] dArray3) {
        int n2;
        this.nData = dArray2.length;
        this.nTerms = this.nXarrays = dArray.length;
        this.yData = new double[this.nData];
        this.yCalc = new double[this.nData];
        this.weight = new double[this.nData];
        this.residual = new double[this.nData];
        this.residualW = new double[this.nData];
        this.xData = new double[this.nXarrays][this.nData];
        int n3 = dArray3.length;
        if (n3 != this.nData) {
            throw new IllegalArgumentException("The weight and the y data lengths do not agree");
        }
        for (n2 = 0; n2 < this.nData; ++n2) {
            this.yData[n2] = dArray2[n2];
            this.weight[n2] = dArray3[n2];
        }
        for (n2 = 0; n2 < this.nXarrays; ++n2) {
            n3 = dArray[n2].length;
            if (n3 != this.nData) {
                throw new IllegalArgumentException("An x [" + n2 + "] length " + n3 + " and the y data length, " + this.nData + ", do not agree");
            }
            System.arraycopy(dArray[n2], 0, this.xData[n2], 0, this.nData);
        }
    }

    public void setDelta(double d2) {
        this.delta = d2;
    }

    public void setMinTest(int n2) {
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("minTest must be 0 or 1");
        }
        this.minTest = n2;
    }

    public void setNmax(int n2) {
        this.nMax = n2;
    }

    public void setNMcontract(double d2) {
        this.cCoeff = d2;
    }

    public void setNMextend(double d2) {
        this.eCoeff = d2;
    }

    public void setNMreflect(double d2) {
        this.rCoeff = d2;
    }

    public void setNrestartsMax(int n2) {
        this.konvge = n2;
    }

    public void setScale(double[] dArray) {
        this.fscale = dArray;
        this.scaleOpt = 2;
    }

    public void setScale(int n2) {
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n2;
    }

    public void setTolerance(double d2) {
        this.fTol = d2;
    }

    public void setTrueFreq(boolean bl2) {
        boolean bl3 = this.trueFreq;
        this.trueFreq = bl2;
        if (bl2) {
            boolean bl4 = NonLinearRegressionFitter.setTrueFreqWeights(this.yData, this.weight);
            if (bl4) {
                this.trueFreq = true;
                this.weightOpt = true;
            } else {
                this.trueFreq = false;
                this.weightOpt = false;
            }
        } else if (bl3) {
            Arrays.fill(this.weight, 1.0);
            this.weightOpt = false;
        }
    }

    public void simplex(Function1D function1D, double[] dArray) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        int n2 = dArray.length;
        int n3 = this.nMax;
        double d2 = this.fTol;
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D, dArray, dArray2, d2, n3);
    }

    public void simplex(Function1D function1D, double[] dArray, double d2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        int n2 = dArray.length;
        int n3 = this.nMax;
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D, dArray, dArray2, d2, n3);
    }

    public void simplex(Function1D function1D, double[] dArray, double d2, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, double[] dArray2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        double d2 = this.fTol;
        int n2 = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, double[] dArray2, double d2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        int n2 = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, double[] dArray2, double d2, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, double[] dArray2, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        double d2 = this.fTol;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D, dArray, dArray2, d2, n2);
    }

    public void simplex(Function1D function1D, double[] dArray, int n2) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        int n3 = dArray.length;
        double d2 = this.fTol;
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(function1D, dArray, dArray2, d2, n2);
    }

    @Deprecated
    public void simplex2(FunctionND functionND, double[] dArray) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        int n2 = dArray.length;
        int n3 = this.nMax;
        double d2 = this.fTol;
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND, dArray, dArray2, d2, n3);
    }

    @Deprecated
    public void simplex2(FunctionND functionND, double[] dArray, double d2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        int n2 = dArray.length;
        int n3 = this.nMax;
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND, dArray, dArray2, d2, n3);
    }

    @Deprecated
    public void simplex2(FunctionND functionND, double[] dArray, double d2, int n2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND, dArray, dArray2, d2, n2);
    }

    @Deprecated
    public void simplex2(FunctionND functionND, double[] dArray, double[] dArray2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        double d2 = this.fTol;
        int n2 = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND, dArray, dArray2, d2, n2);
    }

    @Deprecated
    public void simplex2(FunctionND functionND, double[] dArray, double[] dArray2, double d2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        int n2 = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND, dArray, dArray2, d2, n2);
    }

    @Deprecated
    public void simplex2(FunctionND functionND, double[] dArray, double[] dArray2, double d2, int n2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND, dArray, dArray2, d2, n2);
    }

    @Deprecated
    public void simplex2(FunctionND functionND, double[] dArray, double[] dArray2, int n2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        double d2 = this.fTol;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND, dArray, dArray2, d2, n2);
    }

    @Deprecated
    public void simplex2(FunctionND functionND, double[] dArray, int n2) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        int n3 = dArray.length;
        double d2 = this.fTol;
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray2[i2] = this.dStep * dArray[i2];
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - dArray.length;
        this.nelderMead(functionND, dArray, dArray2, d2, n2);
    }

    protected double sumSquares(Object object, double[] dArray) {
        int n2;
        int n3;
        double d2 = -3.0;
        double[] dArray2 = new double[this.nTerms];
        double[] dArray3 = new double[this.nXarrays];
        for (int i2 = 0; i2 < this.nTerms; ++i2) {
            dArray2[i2] = dArray[i2] / this.fscale[i2];
        }
        double d3 = this.lastSSnoConstraint;
        boolean bl2 = true;
        if (this.penalty) {
            block11: for (n3 = 0; n3 < this.nConstraints; ++n3) {
                n2 = this.penaltyParam[n3];
                switch (this.penaltyCheck[n3]) {
                    case -1: {
                        if (!(dArray2[n2] < this.constraints[n3])) continue block11;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(this.constraints[n3] - dArray2[n2]);
                        bl2 = false;
                        continue block11;
                    }
                    case 0: {
                        if (dArray2[n2] < this.constraints[n3] * (1.0 - this.constraintTolerance)) {
                            d2 = d3 + this.penaltyWeight * MathBase.sqr(this.constraints[n3] * (1.0 - this.constraintTolerance) - dArray2[n2]);
                            bl2 = false;
                        }
                        if (!(dArray2[n2] > this.constraints[n3] * (1.0 + this.constraintTolerance))) continue block11;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(dArray2[n2] - this.constraints[n3] * (1.0 + this.constraintTolerance));
                        bl2 = false;
                        continue block11;
                    }
                    case 1: {
                        if (!(dArray2[n2] > this.constraints[n3])) continue block11;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(dArray2[n2] - this.constraints[n3]);
                        bl2 = false;
                    }
                }
            }
        }
        if (this.sumPenalty) {
            double d4 = 0.0;
            block12: for (int i3 = 0; i3 < this.nSumConstraints; ++i3) {
                for (int i4 = 0; i4 < this.sumPenaltyNumber[i3]; ++i4) {
                    n2 = this.sumPenaltyParam[i3][i4];
                    double d5 = this.sumPlusOrMinus[i3][i4];
                    d4 += dArray2[n2] * d5;
                }
                switch (this.sumPenaltyCheck[i3]) {
                    case -1: {
                        if (!(d4 < this.sumConstraints[i3])) continue block12;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(this.sumConstraints[i3] - d4);
                        bl2 = false;
                        continue block12;
                    }
                    case 0: {
                        if (d4 < this.sumConstraints[i3] * (1.0 - this.constraintTolerance)) {
                            d2 = d3 + this.penaltyWeight * MathBase.sqr(this.sumConstraints[i3] * (1.0 - this.constraintTolerance) - d4);
                            bl2 = false;
                        }
                        if (!(d4 > this.sumConstraints[i3] * (1.0 + this.constraintTolerance))) continue block12;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(d4 - this.sumConstraints[i3] * (1.0 + this.constraintTolerance));
                        bl2 = false;
                        continue block12;
                    }
                    case 1: {
                        if (!(d4 > this.sumConstraints[i3])) continue block12;
                        d2 = d3 + this.penaltyWeight * MathBase.sqr(d4 - this.sumConstraints[i3]);
                        bl2 = false;
                    }
                }
            }
        }
        if (bl2) {
            if (object instanceof Function) {
                ((Function)object).setFitterMode(true);
                Function function = (Function)object;
                for (n3 = 0; n3 < function.getParameterCount(); ++n3) {
                    if (function.isParameterFixed(n3)) continue;
                    function.setParameterValue(n3, dArray2[n3]);
                }
            }
            d2 = 0.0;
            if (!this.multipleY) {
                Function1D function1D = (Function1D)object;
                for (n3 = 0; n3 < this.nData; ++n3) {
                    for (int i5 = 0; i5 < this.nXarrays; ++i5) {
                        dArray3[i5] = this.xData[i5][n3];
                    }
                    d2 += MathBase.sqr((this.yData[n3] - function1D.getValue(dArray3[0])) / this.weight[n3]);
                }
            } else {
                FunctionND functionND = (FunctionND)object;
                n3 = functionND.getInputDimension();
                int n4 = this.nData / n3;
                System.err.println("length = " + this.nData + " dim = " + n3);
                for (int i6 = 0; i6 < n4; ++i6) {
                    int n5;
                    for (n5 = 0; n5 < this.nXarrays; ++n5) {
                        dArray3[n5] = this.xData[n5][i6];
                    }
                    for (n5 = 0; n5 < n3; ++n5) {
                        d2 += MathBase.sqr((this.yData[i6] - functionND.getValue(dArray3, i6)) / this.weight[i6]);
                    }
                }
            }
            this.lastSSnoConstraint = d2;
            if (object instanceof Function) {
                ((Function)object).setFitterMode(false);
            }
        }
        return d2;
    }

    @Deprecated
    protected static ArrayList<Object> dataSign(double[] dArray) {
        int n2;
        int n3;
        double d2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n4 = dArray.length;
        double d3 = 0.0;
        double d4 = dArray[0];
        int n5 = 0;
        double d5 = dArray[0];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        double d6 = 0.0;
        for (int i2 = 0; i2 < n4; ++i2) {
            d6 = dArray[i2];
            if (dArray[i2] > d4) {
                d4 = dArray[i2];
                n5 = i2;
            }
            if (dArray[i2] < d5) {
                d5 = dArray[i2];
                n6 = i2;
            }
            if (dArray[i2] == 0.0) {
                ++n9;
            }
            if (dArray[i2] > 0.0) {
                ++n7;
            }
            if (!(dArray[i2] < 0.0)) continue;
            ++n8;
        }
        d6 /= (double)n4;
        if (n9 + n7 == n4) {
            d2 = d4;
            n3 = n5;
            n2 = 0;
        } else if (n9 + n8 == n4) {
            d2 = d5;
            n3 = n6;
            n2 = 1;
        } else {
            d2 = d4;
            n3 = n5;
            if (-d5 > d4) {
                d2 = d5;
                n3 = n6;
            }
            n2 = 2;
            d3 = -d5;
        }
        arrayList.add(d5);
        arrayList.add(n6);
        arrayList.add(d4);
        arrayList.add(n5);
        arrayList.add(d2);
        arrayList.add(n3);
        arrayList.add(n2);
        arrayList.add(d3);
        arrayList.add(d6);
        return arrayList;
    }

    protected static double halfWidth(double[] dArray, double[] dArray2) {
        double d2;
        double d3 = dArray2[0];
        int n2 = 0;
        int n3 = dArray.length;
        for (int i2 = 1; i2 < n3; ++i2) {
            if (!(dArray2[i2] > d3)) continue;
            d3 = dArray2[i2];
            n2 = i2;
        }
        d3 /= 2.0;
        double d4 = -1.0;
        int n4 = -1;
        if (n2 > 0) {
            n4 = n2 - 1;
            d4 = Math.abs(d3 - dArray2[n4]);
            for (int i3 = n2 - 2; i3 >= 0; --i3) {
                d2 = Math.abs(d3 - dArray2[i3]);
                if (!(d2 < d4)) continue;
                d4 = d2;
                n4 = i3;
            }
            d4 = Math.abs(dArray[n4] - dArray[n2]);
        }
        double d5 = -1.0;
        int n5 = -1;
        if (n2 < n3 - 1) {
            n5 = n2 + 1;
            d5 = Math.abs(d3 - dArray2[n5]);
            for (int i4 = n2 + 2; i4 < n3; ++i4) {
                d2 = Math.abs(d3 - dArray2[i4]);
                if (!(d2 < d5)) continue;
                d5 = d2;
                n5 = i4;
            }
            d5 = Math.abs(dArray[n5] - dArray[n2]);
        }
        double d6 = 0.0;
        int n6 = 0;
        if (n4 != -1) {
            d6 += d4;
            ++n6;
        }
        if (n5 != -1) {
            d6 += d5;
            ++n6;
        }
        if (n6 == 0) {
            return Double.NaN;
        }
        return d6 /= (double)n6;
    }

    protected static boolean setTrueFreqWeights(double[] dArray, double[] dArray2) {
        int n2;
        int n3 = dArray.length;
        boolean bl2 = true;
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = Math.sqrt(Math.abs(dArray[n2]));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double d2 = 0.0;
            double d3 = 0.0;
            if (dArray2[n2] != 0.0) continue;
            boolean bl3 = true;
            int n4 = n2 - 1;
            while (bl3) {
                if (n4 < 0) {
                    bl3 = false;
                    continue;
                }
                if (dArray2[n4] == 0.0) {
                    --n4;
                    continue;
                }
                d2 = dArray2[n4];
                bl3 = false;
            }
            boolean bl4 = true;
            int n5 = n2 + 1;
            while (bl4) {
                if (n5 >= n3) {
                    bl4 = false;
                    continue;
                }
                if (dArray2[n5] == 0.0) {
                    ++n5;
                    continue;
                }
                d3 = dArray2[n5];
                bl4 = false;
            }
            dArray2[n2] = (d2 + d3) / 2.0;
        }
        return true;
    }

    protected static void sort(double[] dArray, double[] dArray2, double[] dArray3) {
        int n2 = -1;
        int n3 = dArray.length;
        while (n2 < n3 - 1) {
            int n4 = n2 + 1;
            for (int i2 = n2 + 2; i2 < n3; ++i2) {
                if (!(dArray[i2] < dArray[n4])) continue;
                n4 = i2;
            }
            double d2 = dArray[n4];
            dArray[n4] = dArray[++n2];
            dArray[n2] = d2;
            double d3 = dArray2[n4];
            dArray2[n4] = dArray2[n2];
            dArray2[n2] = d3;
            double d4 = dArray3[n4];
            dArray3[n4] = dArray3[n2];
            dArray3[n2] = d4;
        }
    }
}

