/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.fitter;

public class GaussFitting {
    private static double fmean = 1.0;
    private static double fmeanError = 0.0;
    private static double frms = 1.0;
    private static double frmsError = 0.0;
    private static double farea = 0.0;
    private static double fareaError = 0.0;
    private static double fconstant = 1.0;
    private static double fconstantError = 1.0;

    public static void fitData(double[] dArray, double[] dArray2, double d2, double d3, double d4) {
        int n2;
        int n3 = 0;
        int n4 = dArray.length - 1;
        int n5 = (int)d2;
        int n6 = 100;
        int n7 = (int)(d4 * d3);
        if (n5 - n3 < n7) {
            n7 = n5 - n3;
        }
        if (n4 - n5 < n7) {
            n7 = n4 - n5;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = dArray[1] - dArray[0];
        double d9 = 0.0;
        double d10 = 0.0;
        double[] dArray3 = new double[2 * n7 + 2 * n6];
        double[] dArray4 = new double[2 * n7 + 2 * n6];
        double[] dArray5 = new double[2 * n7 + 2 * n6];
        for (n2 = 0; n2 < 2 * n7; ++n2) {
            double d11 = dArray[n5 - n7 + n2];
            double d12 = dArray2[n5 - n7 + n2];
            dArray3[n2 + n6] = d11;
            dArray4[n2 + n6] = d12;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            dArray3[n6 - n2] = dArray3[n6] - d8 * (double)n2;
            dArray3[n6 + 2 * n7 + n2] = dArray3[n6 + 2 * n7 - 1] + d8 * (double)n2;
            dArray4[n2] = 0.0;
            dArray4[n6 + 2 * n7 + n2] = 0.0;
        }
        for (n2 = 0; n2 < dArray4.length; ++n2) {
            dArray5[n2] = Math.pow(dArray4[n2] * 0.1, 2.0);
            d7 += dArray4[n2];
            d5 += dArray4[n2] * dArray3[n2];
            d6 += dArray4[n2] * dArray3[n2] * dArray3[n2];
            d9 += d8 * dArray4[n2];
            d10 += dArray4[n2];
        }
        double d13 = d5 / d7;
        double d14 = d6 / d7 - d13 * d13;
        double d15 = d14 > 0.0 ? Math.sqrt(d14) : 1.0;
        fmean = d13;
        frms = d15;
        fconstant = d9;
        farea = d10;
    }

    public static double getArea() {
        return farea;
    }

    public static double getAreaError() {
        return fareaError;
    }

    public static double getConstant() {
        return fconstant;
    }

    public static double getConstantError() {
        return fconstantError;
    }

    public static double getMean() {
        return fmean;
    }

    public static double getMeanError() {
        return fmeanError;
    }

    public static double getRMS() {
        return frms;
    }

    public static double getRMSError() {
        return frmsError;
    }

    public static void main(String[] stringArray) {
        int n2 = 100;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double d2 = 3.0;
        double d3 = 0.5;
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = 0.1 * (double)i2;
            dArray2[i2] = Math.exp(-0.5 * Math.pow((dArray[i2] - d2) / d3, 2.0)) / (Math.sqrt(Math.PI * 2) * d3);
        }
        GaussFitting.fitData(dArray, dArray2, 40.0, 20.0, 20.0);
        GaussFitting.print();
    }

    public static void print() {
        System.out.printf("mean    : %s \t+- %s%nrms     : %s \t+- %s%nconstant: %s \t+- %s%narea    : %s \t+- %s\n", GaussFitting.getMean(), GaussFitting.getMeanError(), GaussFitting.getRMS(), GaussFitting.getRMSError(), GaussFitting.getConstant(), GaussFitting.getConstantError(), GaussFitting.getArea(), GaussFitting.getAreaError());
    }
}

