/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public final class LowPassTransform {
    private LowPassTransform() {
    }

    private static Complex transform(Complex complex, double d2) {
        if (complex.isInfinite()) {
            return new Complex(-1.0, 0.0);
        }
        Complex complex2 = complex.multiply(d2);
        Complex complex3 = new Complex(1.0, 0.0);
        return complex3.add(complex2).divide(complex3.subtract(complex2));
    }

    public static void transform(double d2, LayoutBase layoutBase, LayoutBase layoutBase2) {
        layoutBase.reset();
        double d3 = Math.tan(Math.PI * d2);
        int n2 = layoutBase2.getNumPoles();
        int n3 = n2 / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            PoleZeroPair poleZeroPair = layoutBase2.getPair(i2);
            layoutBase.addPoleZeroConjugatePairs(LowPassTransform.transform(poleZeroPair.poles.first, d3), LowPassTransform.transform(poleZeroPair.zeros.first, d3));
        }
        if ((n2 & 1) == 1) {
            PoleZeroPair poleZeroPair = layoutBase2.getPair(n3);
            layoutBase.add(LowPassTransform.transform(poleZeroPair.poles.first, d3), LowPassTransform.transform(poleZeroPair.zeros.first, d3));
        }
        layoutBase.setNormal(layoutBase2.getNormalW(), layoutBase2.getNormalGain());
    }
}

