/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.ComplexPair;
import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public class LayoutBase {
    private int mNumPoles;
    private PoleZeroPair[] mPair;
    private double mNormalW;
    private double mNormalGain;

    public LayoutBase(int n2) {
        this.mNumPoles = 0;
        this.mPair = n2 % 2 == 1 ? new PoleZeroPair[n2 / 2 + 1] : new PoleZeroPair[n2 / 2];
    }

    public LayoutBase(PoleZeroPair ... poleZeroPairArray) {
        this.mNumPoles = poleZeroPairArray.length * 2;
        this.mPair = poleZeroPairArray;
    }

    public void add(Complex complex, Complex complex2) {
        this.mPair[this.mNumPoles / 2] = new PoleZeroPair(complex, complex2);
        ++this.mNumPoles;
    }

    public void add(ComplexPair complexPair, ComplexPair complexPair2) {
        this.mPair[this.mNumPoles / 2] = new PoleZeroPair(complexPair.first, complexPair2.first, complexPair.second, complexPair2.second);
        this.mNumPoles += 2;
    }

    public void addPoleZeroConjugatePairs(Complex complex, Complex complex2) {
        if (complex == null) {
            throw new IllegalArgumentException("LayoutBase addConj() pole == null");
        }
        if (complex2 == null) {
            throw new IllegalArgumentException("LayoutBase addConj() zero == null");
        }
        this.mPair[this.mNumPoles / 2] = new PoleZeroPair(complex, complex2, complex.conjugate(), complex2.conjugate());
        this.mNumPoles += 2;
    }

    public double getNormalGain() {
        return this.mNormalGain;
    }

    public double getNormalW() {
        return this.mNormalW;
    }

    public int getNumPoles() {
        return this.mNumPoles;
    }

    public PoleZeroPair getPair(int n2) {
        return this.mPair[n2];
    }

    public void reset() {
        this.mNumPoles = 0;
    }

    public void setNormal(double d2, double d3) {
        this.mNormalW = d2;
        this.mNormalGain = d3;
    }
}

