/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.Biquad;
import io.fair_acc.math.filter.iir.DirectFormAbstract;
import io.fair_acc.math.filter.iir.DirectFormI;
import io.fair_acc.math.filter.iir.DirectFormII;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class Cascade {
    private Biquad[] mBiquads;
    private DirectFormAbstract[] mStates;
    private int mNumBiquads = 0;

    public void applyScale(double d2) {
        if (this.mBiquads.length > 0) {
            this.mBiquads[0].applyScale(d2);
        }
    }

    public double filter(double d2) {
        double d3 = d2;
        for (int i2 = 0; i2 < this.mNumBiquads; ++i2) {
            if (this.mStates[i2] == null) continue;
            d3 = this.mStates[i2].process1(d3, this.mBiquads[i2]);
        }
        return d3;
    }

    public Biquad getBiquad(int n2) {
        return this.mBiquads[n2];
    }

    public int getNumBiquads() {
        return this.mNumBiquads;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.mNumBiquads; ++i2) {
            this.mStates[i2].reset();
        }
    }

    public Complex response(double d2) {
        double d3 = Math.PI * 2 * d2;
        Complex complex = ComplexUtils.polar2Complex((double)1.0, (double)(-d3));
        Complex complex2 = ComplexUtils.polar2Complex((double)1.0, (double)(-2.0 * d3));
        Complex complex3 = new Complex(1.0);
        Complex complex4 = new Complex(1.0);
        for (int i2 = 0; i2 < this.mNumBiquads; ++i2) {
            Biquad biquad = this.mBiquads[i2];
            Complex complex5 = new Complex(biquad.getB0() / biquad.getA0());
            complex5 = complex5.add(complex.multiply(biquad.getB1() / biquad.getA0()));
            complex5 = complex5.add(complex2.multiply(biquad.getB2() / biquad.getA0()));
            Complex complex6 = new Complex(1.0);
            complex6 = complex6.add(complex.multiply(biquad.getA1() / biquad.getA0()));
            complex6 = complex6.add(complex2.multiply(biquad.getA2() / biquad.getA0()));
            complex3 = complex3.multiply(complex5);
            complex4 = complex4.multiply(complex6);
        }
        return complex3.divide(complex4);
    }

    public void setLayout(LayoutBase layoutBase, int n2) {
        int n3;
        int n4 = layoutBase.getNumPoles();
        this.mNumBiquads = (n4 + 1) / 2;
        this.mBiquads = new Biquad[this.mNumBiquads];
        switch (n2) {
            case 0: {
                this.mStates = new DirectFormI[this.mNumBiquads];
                for (n3 = 0; n3 < this.mNumBiquads; ++n3) {
                    this.mStates[n3] = new DirectFormI();
                }
                break;
            }
            default: {
                this.mStates = new DirectFormII[this.mNumBiquads];
                for (n3 = 0; n3 < this.mNumBiquads; ++n3) {
                    this.mStates[n3] = new DirectFormII();
                }
            }
        }
        for (n3 = 0; n3 < this.mNumBiquads; ++n3) {
            PoleZeroPair poleZeroPair = layoutBase.getPair(n3);
            this.mBiquads[n3] = new Biquad();
            this.mBiquads[n3].setPoleZeroPair(poleZeroPair);
        }
        this.applyScale(layoutBase.getNormalGain() / this.response(layoutBase.getNormalW() / (Math.PI * 2)).abs());
    }
}

