/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.BandPassTransform;
import io.fair_acc.math.filter.iir.BandStopTransform;
import io.fair_acc.math.filter.iir.Cascade;
import io.fair_acc.math.filter.iir.HighPassTransform;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.LowPassTransform;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class Butterworth
extends Cascade {
    public void bandPass(int n2, double d2, double d3, double d4) {
        this.setupBandPass(n2, d2, d3, d4, 1);
    }

    public void bandPass(int n2, double d2, double d3, double d4, int n3) {
        this.setupBandPass(n2, d2, d3, d4, n3);
    }

    public void bandStop(int n2, double d2, double d3, double d4) {
        this.setupBandStop(n2, d2, d3, d4, 1);
    }

    public void bandStop(int n2, double d2, double d3, double d4, int n3) {
        this.setupBandStop(n2, d2, d3, d4, n3);
    }

    public void highPass(int n2, double d2, double d3) {
        this.setupHighPass(n2, d2, d3, 1);
    }

    public void highPass(int n2, double d2, double d3, int n3) {
        this.setupHighPass(n2, d2, d3, n3);
    }

    public void lowPass(int n2, double d2, double d3) {
        this.setupLowPass(n2, d2, d3, 1);
    }

    public void lowPass(int n2, double d2, double d3, int n3) {
        this.setupLowPass(n2, d2, d3, n3);
    }

    private void setupBandPass(int n2, double d2, double d3, double d4, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design();
        LayoutBase layoutBase = new LayoutBase(n2 * 2);
        BandPassTransform.transform(d3 / d2, d4 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupBandStop(int n2, double d2, double d3, double d4, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design();
        LayoutBase layoutBase = new LayoutBase(n2 * 2);
        BandStopTransform.transform(d3 / d2, d4 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupHighPass(int n2, double d2, double d3, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design();
        LayoutBase layoutBase = new LayoutBase(n2);
        HighPassTransform.transform(d3 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private void setupLowPass(int n2, double d2, double d3, int n3) {
        AnalogLowPass analogLowPass = new AnalogLowPass(n2);
        analogLowPass.design();
        LayoutBase layoutBase = new LayoutBase(n2);
        LowPassTransform.transform(d3 / d2, layoutBase, analogLowPass);
        this.setLayout(layoutBase, n3);
    }

    private static class AnalogLowPass
    extends LayoutBase {
        private final int nPoles;

        public AnalogLowPass(int n2) {
            super(n2);
            this.nPoles = n2;
            this.setNormal(0.0, 1.0);
        }

        public void design() {
            this.reset();
            double d2 = 2.0 * (double)this.nPoles;
            int n2 = this.nPoles / 2;
            for (int i2 = 0; i2 < n2; ++i2) {
                Complex complex = ComplexUtils.polar2Complex((double)1.0, (double)(1.5707963267948966 + (double)(2 * i2 + 1) * Math.PI / d2));
                this.addPoleZeroConjugatePairs(complex, Complex.INF);
            }
            if ((this.nPoles & 1) == 1) {
                this.add(new Complex(-1.0), Complex.INF);
            }
        }
    }
}

