/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.fir;

import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.math.filter.FilterType;

public class FirFilter {
    FirFilter() {
        throw new IllegalStateException("Utility class");
    }

    public static double[] calculateFilterParameters(double d2, FilterType filterType, double d3, double d4, int n2) {
        double d5;
        double d6;
        double d7;
        double d8 = -Math.cos(Math.PI / (d4 * 2.0) + (double)(n2 - 1) * (Math.PI / d4));
        double d9 = Math.sin(Math.PI / (d4 * 2.0) + (double)(n2 - 1) * Math.PI / d4);
        if (d3 != 0.0) {
            d7 = Math.sqrt(Math.pow(100.0 / (100.0 - d3), 2.0) - 1.0);
            d6 = 1.0 / d4 * Math.log(1.0 / d7 + Math.sqrt(1.0 / Math.pow(d7, 2.0) + 1.0));
            d5 = 1.0 / d4 * Math.log(1.0 / d7 + Math.sqrt(1.0 / Math.pow(d7, 2.0) - 1.0));
            d5 = (Math.exp(d5) + Math.exp(-d5)) / 2.0;
            d8 = d8 * ((Math.exp(d6) - Math.exp(-d6)) / 2.0) / d5;
            d9 = d9 * ((Math.exp(d6) + Math.exp(-d6)) / 2.0) / d5;
        }
        d7 = 2.0 * Math.tan(0.5);
        d6 = Math.PI * 2 * d2;
        d5 = Math.pow(d8, 2.0) + Math.pow(d9, 2.0);
        double d10 = 4.0 - 4.0 * d8 * d7 + d5 * Math.pow(d7, 2.0);
        double d11 = Math.pow(d7, 2.0) / d10;
        double d12 = 2.0 * Math.pow(d7, 2.0) / d10;
        double d13 = Math.pow(d7, 2.0) / d10;
        double d14 = (8.0 - 2.0 * d5 * Math.pow(d7, 2.0)) / d10;
        double d15 = (-4.0 - 4.0 * d8 * d7 - d5 * Math.pow(d7, 2.0)) / d10;
        double d16 = 0.0;
        switch (filterType) {
            case HIGH_PASS: {
                d16 = -Math.cos(0.5 * d6 + 0.5) / Math.cos(0.5 * d6 - 0.5);
                break;
            }
            default: {
                d16 = Math.sin(0.5 - 0.5 * d6) / Math.sin(0.5 * d6 + 0.5);
            }
        }
        d10 = 1.0 + d14 * d16 - d15 * Math.pow(d16, 2.0);
        double[] dArray = new double[5];
        double d17 = (d11 - d12 * d16 + d13 * Math.pow(d16, 2.0)) / d10;
        double d18 = (-2.0 * d11 * d16 + d12 + d12 * Math.pow(d16, 2.0) - 2.0 * d13 * d16) / d10;
        double d19 = (d11 * Math.pow(d16, 2.0) - d12 * d16 + d13) / d10;
        double d20 = (2.0 * d16 + d14 + d14 * Math.pow(d16, 2.0) - 2.0 * d15 * d16) / d10;
        double d21 = (-Math.pow(d16, 2.0) - d14 * d16 + d15) / d10;
        if (filterType == FilterType.HIGH_PASS) {
            d18 = -d18;
            d20 = -d20;
        }
        dArray[0] = d17;
        dArray[1] = d18;
        dArray[2] = d19;
        dArray[3] = d20;
        dArray[4] = d21;
        return dArray;
    }

    public static double[] filterSignal(double[] dArray, double[] dArray2, double d2, int n2, FilterType filterType, double d3) {
        double[] dArray3;
        int n3;
        int n4;
        AssertUtils.notNull("signal", dArray);
        double[][] dArray4 = new double[22][2];
        double[] dArray5 = new double[22];
        double[] dArray6 = new double[22];
        double[] dArray7 = new double[22];
        double[] dArray8 = new double[22];
        dArray5[2] = 1.0;
        dArray6[2] = 1.0;
        for (n4 = 1; n4 < n2 / 2; ++n4) {
            int n5;
            double[] dArray9 = FirFilter.calculateFilterParameters(d2, filterType, d3, n2, n4);
            for (n5 = 0; n5 < dArray5.length; ++n5) {
                dArray7[n5] = dArray5[n5];
                dArray8[n5] = dArray6[n5];
            }
            for (n5 = 2; n5 < dArray5.length; ++n5) {
                dArray5[n5] = dArray9[0] * dArray7[n5] + dArray9[1] * dArray7[n5 - 1] + dArray9[2] * dArray7[n5 - 2];
                dArray6[n5] = dArray8[n5] - dArray9[3] * dArray8[n5 - 1] - dArray9[4] * dArray8[n5 - 2];
            }
        }
        dArray6[2] = 0.0;
        for (n4 = 0; n4 < 20; ++n4) {
            dArray5[n4] = dArray5[n4 + 2];
            dArray6[n4] = -dArray6[n4 + 2];
        }
        double d4 = 0.0;
        double d5 = 0.0;
        block7: for (int i2 = 0; i2 < 20; ++i2) {
            switch (filterType) {
                case HIGH_PASS: {
                    d4 += dArray5[i2] * Math.pow(-1.0, i2);
                    d5 += dArray5[i2] * Math.pow(-1.0, i2);
                    continue block7;
                }
                default: {
                    d4 += dArray5[i2];
                    d5 += dArray6[i2];
                }
            }
        }
        double d6 = d4 / (1.0 - d5);
        for (n3 = 0; n3 < 20; ++n3) {
            dArray5[n3] = dArray5[n3] / d6;
        }
        for (n3 = 0; n3 < 22; ++n3) {
            dArray4[n3][0] = dArray5[n3];
            dArray4[n3][1] = dArray6[n3];
        }
        double[] dArray10 = dArray3 = dArray2 == null ? new double[dArray.length] : dArray2;
        if (dArray2 != null) {
            AssertUtils.gtOrEqual("output", dArray.length, dArray2.length);
        }
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i3 = n2; i3 < dArray.length; ++i3) {
            int n6;
            for (n6 = 0; n6 < n2 + 1; ++n6) {
                d7 += dArray5[n6] * dArray[i3 - n6];
            }
            for (n6 = 1; n6 < n2 + 1; ++n6) {
                d8 += dArray6[n6] * dArray3[i3 - n6];
            }
            dArray3[i3] = d7 + d8;
            d7 = 0.0;
            d8 = 0.0;
        }
        return dArray3;
    }
}

