/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

public class RingBuffer<E> {
    private final E[] elements;
    private final int capacity;
    private int writePos;
    private int readPos;
    private boolean flipped;

    public RingBuffer(int n2) {
        this.capacity = n2;
        this.elements = new Object[n2];
        this.flipped = false;
    }

    public int available() {
        if (!this.flipped) {
            return this.writePos - this.readPos;
        }
        return this.capacity - this.readPos + this.writePos;
    }

    public boolean put(E e2) {
        if (this.flipped) {
            if (this.writePos < this.readPos) {
                this.elements[this.writePos++] = e2;
                return true;
            }
            return false;
        }
        if (this.writePos == this.capacity) {
            this.writePos = 0;
            this.flipped = true;
            if (this.writePos < this.readPos) {
                this.elements[this.writePos++] = e2;
                return true;
            }
            return false;
        }
        this.elements[this.writePos++] = e2;
        return true;
    }

    public int put(E[] EArray, int n2) {
        int n3;
        if (!this.flipped) {
            if (n2 <= this.capacity - this.writePos) {
                for (n3 = 0; n3 < n2; ++n3) {
                    this.elements[this.writePos++] = EArray[n3];
                }
                return n3;
            }
            while (this.writePos < this.capacity) {
                this.elements[this.writePos] = EArray[n3++];
                ++this.writePos;
            }
            this.writePos = 0;
            this.flipped = true;
            int n4 = Math.min(this.readPos, n2 - n3);
            while (this.writePos < n4) {
                this.elements[this.writePos] = EArray[n3++];
                ++this.writePos;
            }
            return n3;
        }
        int n5 = Math.min(this.readPos, this.writePos + n2);
        while (this.writePos < n5) {
            this.elements[this.writePos] = EArray[n3++];
            ++this.writePos;
        }
        return n3;
    }

    public int remainingCapacity() {
        if (!this.flipped) {
            return this.capacity - this.writePos;
        }
        return this.readPos - this.writePos;
    }

    public void reset() {
        this.writePos = 0;
        this.readPos = 0;
        this.flipped = false;
    }

    public E take() {
        if (!this.flipped) {
            if (this.readPos < this.writePos) {
                return this.elements[this.readPos++];
            }
            return null;
        }
        if (this.readPos == this.capacity) {
            this.readPos = 0;
            this.flipped = false;
            if (this.readPos < this.writePos) {
                return this.elements[this.readPos++];
            }
            return null;
        }
        return this.elements[this.readPos++];
    }

    public int take(E[] EArray, int n2) {
        int n3;
        if (!this.flipped) {
            int n4 = Math.min(this.writePos, this.readPos + n2);
            while (this.readPos < n4) {
                EArray[n3++] = this.elements[this.readPos];
                ++this.readPos;
            }
            return n3;
        }
        if (n2 <= this.capacity - this.readPos) {
            for (n3 = 0; n3 < n2; ++n3) {
                EArray[n3] = this.elements[this.readPos++];
            }
            return n3;
        }
        while (this.readPos < this.capacity) {
            EArray[n3++] = this.elements[this.readPos];
            ++this.readPos;
        }
        this.readPos = 0;
        this.flipped = false;
        int n5 = Math.min(this.writePos, n2 - n3);
        while (this.readPos < n5) {
            EArray[n3++] = this.elements[this.readPos];
            ++this.readPos;
        }
        return n3;
    }
}

