/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessingProfiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessingProfiler.class);
    private static boolean debugState = false;
    private static boolean verboseOutput = true;
    private static boolean loggerOutput = false;

    private ProcessingProfiler() {
    }

    public static List<String> getCallingClassMethod(int ... nArray) {
        int n2;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int[] nArray2 = nArray;
        int n4 = nArray2.length;
        for (int i2 = 0; i2 < n4 && (n3 = 2 + (n2 = nArray2[i2])) < stackTraceElementArray.length; ++i2) {
            StringBuilder stringBuilder = new StringBuilder();
            StackTraceElement stackTraceElement = stackTraceElementArray[n3];
            String string = stackTraceElement.getClassName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            String string3 = stackTraceElement.getMethodName();
            int n5 = stackTraceElement.getLineNumber();
            stringBuilder.append(string2).append("::").append(string3).append("(line:").append(n5).append(')');
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    private static String getCallingClassMethod(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n2 = string == null ? 4 : 3;
        StackTraceElement stackTraceElement = stackTraceElementArray[n2];
        String string2 = stackTraceElement.getClassName();
        String string3 = string2.substring(string2.lastIndexOf(46) + 1);
        String string4 = stackTraceElement.getMethodName();
        int n3 = stackTraceElement.getLineNumber();
        return string3 + "::" + string4 + "(line:" + n3 + ")";
    }

    public static boolean getDebugState() {
        return debugState;
    }

    public static boolean getLoggerOutputState() {
        return loggerOutput;
    }

    public static long getTimeDiff(long l2) {
        return ProcessingProfiler.getTimeDiff(l2, null);
    }

    public static long getTimeDiff(long l2, String string) {
        if (!debugState) {
            return 0L;
        }
        long l3 = System.nanoTime();
        double d2 = TimeUnit.NANOSECONDS.toMillis(l3 - l2);
        if (verboseOutput) {
            String string2 = ProcessingProfiler.getCallingClassMethod(string);
            String string3 = String.format("%-55s - time diff = %8.3f [ms] msg: '%s'", string2, d2, string == null ? "" : string);
            if (loggerOutput) {
                LOGGER.info(string3);
            } else {
                System.out.println(string3);
            }
        }
        return l3;
    }

    public static long getTimeStamp() {
        if (debugState) {
            return System.nanoTime();
        }
        return 0L;
    }

    public static boolean getVerboseOutputState() {
        return verboseOutput;
    }

    public static void setDebugState(boolean bl2) {
        debugState = bl2;
    }

    public static void setLoggerOutputState(boolean bl2) {
        loggerOutput = bl2;
    }

    public static void setVerboseOutputState(boolean bl2) {
        verboseOutput = bl2;
    }
}

