/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import io.fair_acc.dataset.utils.CacheCollection;
import java.lang.ref.Reference;
import java.util.List;

public class DoubleArrayCache
extends CacheCollection<double[]> {
    private static final DoubleArrayCache SELF = new DoubleArrayCache();

    public double[] getArray(int n2) {
        return this.getArray(n2, false);
    }

    public double[] getArrayExact(int n2) {
        return this.getArray(n2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getArray(int n2, boolean bl2) {
        List list = this.contents;
        synchronized (list) {
            double[] dArray = null;
            int n3 = Integer.MAX_VALUE;
            for (Reference reference : this.contents) {
                double[] dArray2 = (double[])reference.get();
                if (dArray2 == null) continue;
                int n4 = dArray2.length - n2;
                if (n4 == 0) {
                    dArray = dArray2;
                    break;
                }
                if (n4 <= 0 || n4 >= n3 || bl2) continue;
                n3 = n4;
                dArray = dArray2;
            }
            if (dArray == null) {
                dArray = new double[n2];
                return dArray;
            }
            this.remove(dArray);
            return dArray;
        }
    }

    public static DoubleArrayCache getInstance() {
        return SELF;
    }
}

