/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.DataSetMetaData;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.DataSetBuilder;
import io.fair_acc.dataset.spi.DefaultAxisDescription;
import io.fair_acc.dataset.spi.DefaultDataSet;
import io.fair_acc.dataset.spi.DoubleErrorDataSet;
import io.fair_acc.dataset.utils.AssertUtils;
import io.fair_acc.dataset.utils.DataSetUtilsHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetUtils
extends DataSetUtilsHelper {
    private static final String CACHED_META_DATA_STRING_BUILDER = "metaDataCacheBuilder";
    private static final String CACHED_STRING_BUILDER = "numericDataCacheBuilder";
    private static final String CACHED_WRITE_BYTE_BUFFER = "writeByteBuffer";
    public static final String NO_DATASET = "noDataset";
    private static final int SWITCH_TO_BINARY_KEY = 254;
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetUtils.class);
    private static final String DEFAULT_TIME_FORMAT = "yyyyMMdd_HHmmss";
    private static final List<Character> AXIS_ID = Arrays.asList(Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('a'), Character.valueOf('b'));
    protected static boolean useFloat32BinaryStandard = true;
    protected static boolean exportMetaDataByDefault = true;

    private DataSetUtils() {
    }

    public static AbstractDataSet<?> copyDataSet(DataSet dataSet) {
        DefaultDataSet defaultDataSet = new DefaultDataSet(dataSet.getName());
        defaultDataSet.set(dataSet);
        return defaultDataSet;
    }

    protected static double[] cropToLength(double[] dArray, int n2) {
        if (dArray.length == n2) {
            return dArray;
        }
        return Arrays.copyOf(dArray, n2);
    }

    public static double error(DataSet dataSet, ErrType errType, double d2) {
        return DataSetUtils.error(dataSet, errType, -1, d2, true);
    }

    public static double error(DataSet dataSet, ErrType errType, int n2) {
        return DataSetUtils.error(dataSet, errType, n2, 0.0, false);
    }

    protected static double error(DataSet dataSet, ErrType errType, int n2, double d2, boolean bl2) {
        if (!(dataSet instanceof DataSetError)) {
            return 0.0;
        }
        DataSetError dataSetError = (DataSetError)dataSet;
        if (bl2) {
            switch (errType) {
                case EXN: {
                    return dataSetError.getErrorNegative(0, d2);
                }
                case EXP: {
                    return dataSetError.getErrorPositive(0, d2);
                }
                case EYN: {
                    return dataSetError.getErrorNegative(1, d2);
                }
                case EYP: {
                    return dataSetError.getErrorPositive(1, d2);
                }
            }
        } else {
            switch (errType) {
                case EXN: {
                    return dataSetError.getErrorNegative(0, n2);
                }
                case EXP: {
                    return dataSetError.getErrorPositive(0, n2);
                }
                case EYN: {
                    return dataSetError.getErrorNegative(1, n2);
                }
                case EYP: {
                    return dataSetError.getErrorPositive(1, n2);
                }
            }
        }
        return 0.0;
    }

    public static double[] errors(DataSet dataSet, ErrType errType) {
        int n2 = dataSet.getDataCount();
        if (!(dataSet instanceof DataSetError)) {
            return new double[n2];
        }
        DataSetError dataSetError = (DataSetError)dataSet;
        switch (errType) {
            case EXN: {
                return DataSetUtils.cropToLength(dataSetError.getErrorsNegative(0), n2);
            }
            case EXP: {
                return DataSetUtils.cropToLength(dataSetError.getErrorsPositive(0), n2);
            }
            case EYN: {
                return DataSetUtils.cropToLength(dataSetError.getErrorsNegative(1), n2);
            }
        }
        return DataSetUtils.cropToLength(dataSetError.getErrorsPositive(1), n2);
    }

    protected static Compression evaluateAutoCompression(String string) {
        if (string.toLowerCase(Locale.UK).endsWith(".gz")) {
            return Compression.GZIP;
        }
        if (string.toLowerCase(Locale.UK).endsWith(".zip")) {
            return Compression.ZIP;
        }
        return Compression.NONE;
    }

    public static String getFileName(DataSet dataSet, String string) {
        Pattern pattern = Pattern.compile("\\{([^{}]*)}");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2;
            boolean bl2 = true;
            String[] stringArray = matcher.group(1).split(";");
            if (stringArray.length == 0) {
                bl2 = false;
            }
            switch (stringArray[0]) {
                case "systemTime": {
                    string2 = Long.toString(System.currentTimeMillis());
                    break;
                }
                case "dataSetName": {
                    string2 = dataSet == null ? NO_DATASET : dataSet.getName();
                    break;
                }
                case "xMin": {
                    string2 = dataSet == null ? NO_DATASET : Double.toString(dataSet.getAxisDescription(0).getMin());
                    break;
                }
                case "xMax": {
                    string2 = dataSet == null ? NO_DATASET : Double.toString(dataSet.getAxisDescription(0).getMax());
                    break;
                }
                case "yMin": {
                    string2 = dataSet == null ? NO_DATASET : Double.toString(dataSet.getAxisDescription(1).getMin());
                    break;
                }
                case "yMax": {
                    string2 = dataSet == null ? NO_DATASET : Double.toString(dataSet.getAxisDescription(1).getMax());
                    break;
                }
                default: {
                    if (!(dataSet instanceof DataSetMetaData)) {
                        string2 = "metaDataMissing";
                        bl2 = false;
                        break;
                    }
                    DataSetMetaData dataSetMetaData = (DataSetMetaData)((Object)dataSet);
                    string2 = dataSetMetaData.getMetaInfo().get(stringArray[0]);
                    if (string2 != null) break;
                    string2 = "metaDataFieldMissing";
                    bl2 = false;
                }
            }
            if (bl2 && stringArray.length != 1 && !stringArray[1].equals("string")) {
                switch (stringArray[1]) {
                    case "date": {
                        String string3 = stringArray.length < 3 ? DEFAULT_TIME_FORMAT : stringArray[2];
                        string2 = DataSetUtils.getISODate(Long.parseLong(string2), string3);
                        break;
                    }
                    case "int": 
                    case "long": {
                        String string3 = stringArray.length < 3 ? "%d" : stringArray[2];
                        string2 = String.format(Locale.US, string3, Long.valueOf(string2));
                        break;
                    }
                    case "float": 
                    case "double": {
                        String string3 = stringArray.length < 3 ? "%e" : stringArray[2];
                        string2 = String.format(Locale.US, string3, Double.valueOf(string2));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("fileName contains placeholder with illegal type: " + stringArray[1]);
                    }
                }
            }
            matcher.appendReplacement(stringBuffer, string2);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String getISODate(long l2, String string) {
        long l3 = TimeUnit.MILLISECONDS.toMillis(l2);
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.UK);
        simpleDateFormat.setTimeZone(timeZone);
        return simpleDateFormat.format(new Date(l3));
    }

    protected static String getKey(String string, String string2) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(" : ");
        if (stringArray.length < 2) {
            return null;
        }
        return stringArray[0].replaceAll(string2, "");
    }

    protected static String getValue(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(" : ");
        if (stringArray.length < 2) {
            return null;
        }
        return stringArray[1];
    }

    private static SplitCharByteInputStream openDatasetFileInput(File file, Compression compression) throws IOException {
        return new SplitCharByteInputStream(new PushbackInputStream(switch (compression) {
            case Compression.ZIP -> {
                ZipInputStream var3_2 = new ZipInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                if (var3_2.getNextEntry() == null) {
                    var3_2.close();
                    throw new ZipException("Corrupt zip archive has no entries");
                }
                yield var3_2;
            }
            case Compression.GZIP -> new GZIPInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
            case Compression.NONE -> Files.newInputStream(file.toPath(), new OpenOption[0]);
            default -> throw new IOException("Unimplemented Compression");
        }, 8192));
    }

    private static OutputStream openDatasetFileOutput(File file, Compression compression) throws IOException {
        switch (compression) {
            case NONE: {
                return Files.newOutputStream(file.toPath(), new OpenOption[0]);
            }
            case GZIP: {
                return new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
            }
            case ZIP: {
                ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
                String string = file.getName();
                String string2 = string.toLowerCase(Locale.UK).endsWith(".zip") ? string.substring(0, string.length() - 4) : string;
                zipOutputStream.putNextEntry(new ZipEntry(string2));
                return zipOutputStream;
            }
        }
        throw new IllegalArgumentException("Unknown Compression format: " + compression.toString());
    }

    public static DataSet readDataSetFromByteArray(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("null byteArray");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("byteArray with zero length");
        }
        DataSet dataSet = null;
        try (SplitCharByteInputStream splitCharByteInputStream = new SplitCharByteInputStream(new PushbackInputStream(new ByteArrayInputStream(byArray), 8192));){
            dataSet = DataSetUtils.readDataSetFromStream(splitCharByteInputStream);
        }
        catch (IOException iOException) {
            LOGGER.atError().setCause(iOException).addArgument(byArray.length).log("could not open/parse byte array size = {}");
        }
        return dataSet;
    }

    public static DataSet readDataSetFromFile(String string) {
        return DataSetUtils.readDataSetFromFile(string, Compression.AUTO);
    }

    public static DataSet readDataSetFromFile(String string, Compression compression) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("fileName must not be null or empty");
        }
        DataSet dataSet = null;
        try (SplitCharByteInputStream splitCharByteInputStream = DataSetUtils.openDatasetFileInput(new File(string), compression == Compression.AUTO ? DataSetUtils.evaluateAutoCompression(string) : compression);){
            dataSet = DataSetUtils.readDataSetFromStream(splitCharByteInputStream);
        }
        catch (IOException iOException) {
            LOGGER.atError().addArgument(string).log("could not open/parse file: '{}'", (Object)iOException);
        }
        return dataSet;
    }

    public static DataSet readDataSetFromStream(SplitCharByteInputStream splitCharByteInputStream) {
        boolean bl2 = false;
        DataSet dataSet = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(splitCharByteInputStream));){
            String string = "unknown data set";
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
            ArrayList<DefaultAxisDescription> arrayList4 = new ArrayList<DefaultAxisDescription>();
            boolean bl3 = false;
            String string2 = bufferedReader.readLine();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("$")) {
                    if (string2.startsWith("$binary")) {
                        bl2 = true;
                    }
                    if (!string2.contains("z")) break;
                    bl3 = true;
                    break;
                }
                if (string2.matches("^#.Min.*")) {
                    int n3 = AXIS_ID.indexOf(Character.valueOf(string2.charAt(1)));
                    if (n3 < 0) {
                        LOGGER.atError().log("Axis index does not exist: {}", (Object)Character.valueOf(string2.charAt(1)));
                    }
                    while (arrayList4.size() < n3 + 1) {
                        arrayList4.add(new DefaultAxisDescription(arrayList4.size()));
                    }
                    ((AxisDescription)arrayList4.get(n3)).setMin(Double.parseDouble(DataSetUtils.getValue(string2)));
                    continue;
                }
                if (string2.matches("^#.Max.*")) {
                    int n4 = AXIS_ID.indexOf(Character.valueOf(string2.charAt(1)));
                    if (n4 < 0) {
                        LOGGER.atError().log("Axis index does not exist: {}", (Object)Character.valueOf(string2.charAt(1)));
                    }
                    while (arrayList4.size() < n4 + 1) {
                        arrayList4.add(new DefaultAxisDescription(arrayList4.size()));
                    }
                    ((AxisDescription)arrayList4.get(n4)).setMax(Double.parseDouble(DataSetUtils.getValue(string2)));
                    continue;
                }
                if (string2.matches("^#.Name.*")) {
                    int n5 = AXIS_ID.indexOf(Character.valueOf(string2.charAt(1)));
                    if (n5 < 0) {
                        LOGGER.atError().log("Axis index does not exist: {}", (Object)Character.valueOf(string2.charAt(1)));
                    }
                    while (arrayList4.size() < n5 + 1) {
                        arrayList4.add(new DefaultAxisDescription(arrayList4.size()));
                    }
                    ((AxisDescription)arrayList4.get(n5)).set(DataSetUtils.getValue(string2) == null ? "" : DataSetUtils.getValue(string2), new String[0]);
                    continue;
                }
                if (string2.matches("^#.Unit.*")) {
                    int n6 = AXIS_ID.indexOf(Character.valueOf(string2.charAt(1)));
                    if (n6 < 0) {
                        LOGGER.atError().log("Axis index does not exist: {}", (Object)Character.valueOf(string2.charAt(1)));
                    }
                    while (arrayList4.size() < n6 + 1) {
                        arrayList4.add(new DefaultAxisDescription(arrayList4.size()));
                    }
                    ((AxisDescription)arrayList4.get(n6)).set(((AxisDescription)arrayList4.get(n6)).getName(), DataSetUtils.getValue(string2) == null ? "" : DataSetUtils.getValue(string2));
                    continue;
                }
                if (string2.contains("#dataSetName")) {
                    string = DataSetUtils.getValue(string2);
                    continue;
                }
                if (string2.contains("#nSamples")) {
                    n2 = Integer.parseInt(DataSetUtils.getValue(string2));
                    continue;
                }
                if (string2.contains("#info")) {
                    arrayList.add(DataSetUtils.getValue(string2));
                    continue;
                }
                if (string2.contains("#warning")) {
                    arrayList2.add(DataSetUtils.getValue(string2));
                    continue;
                }
                if (string2.contains("#error")) {
                    arrayList3.add(DataSetUtils.getValue(string2));
                    continue;
                }
                if (!string2.contains("#metaKey -")) continue;
                String string3 = DataSetUtils.getKey(string2, "#metaKey -");
                String object = DataSetUtils.getValue(string2);
                if (string3 == null || object == null) {
                    LOGGER.warn("Could not add meta information from file: {}", (Object)string2);
                    continue;
                }
                concurrentHashMap.put(string3, object);
            }
            if ((dataSet = bl2 ? DataSetUtils.readNumericDataFromBinaryFile(bufferedReader, splitCharByteInputStream, string) : DataSetUtils.readNumericDataFromFile(bufferedReader, string, bl3, n2)) == null) {
                throw new IllegalStateException("dataSet is null for branch binary = " + bl2);
            }
            ((DataSetMetaData)((Object)dataSet)).getMetaInfo().putAll(concurrentHashMap);
            ((DataSetMetaData)((Object)dataSet)).getInfoList().addAll(arrayList);
            ((DataSetMetaData)((Object)dataSet)).getWarningList().addAll(arrayList2);
            ((DataSetMetaData)((Object)dataSet)).getErrorList().addAll(arrayList3);
            dataSet.getAxisDescriptions().clear();
            for (AxisDescription axisDescription : arrayList4) {
                dataSet.getAxisDescriptions().add(new DefaultAxisDescription(axisDescription));
            }
        }
        catch (IOException iOException) {
            LOGGER.error("could not open/parse inputStream", iOException);
            return dataSet;
        }
        return dataSet;
    }

    private static DataSet readNumericDataFromBinaryFile(BufferedReader bufferedReader, SplitCharByteInputStream splitCharByteInputStream, String string) throws IOException {
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        List list = bufferedReader.lines().collect(Collectors.toList());
        if (splitCharByteInputStream.reachedSplit()) {
            splitCharByteInputStream.switchToBinary();
            block14: for (int i2 = 0; i2 < list.size(); ++i2) {
                String[] stringArray = ((String)list.get(i2)).substring(1).split(";");
                String string2 = stringArray[0];
                String string3 = stringArray[1];
                int n2 = Integer.parseInt(stringArray[2]);
                boolean bl2 = string3.toLowerCase(Locale.UK).contains("float32");
                ByteBuffer byteBuffer = bl2 ? ByteBuffer.allocate(n2 * 4) : ByteBuffer.allocate(n2 * 8);
                DoubleBuffer doubleBuffer = null;
                FloatBuffer floatBuffer = null;
                if (bl2) {
                    floatBuffer = byteBuffer.asFloatBuffer();
                    for (var12_12 = 0; var12_12 < n2 * 4; var12_12 += splitCharByteInputStream.read(byteBuffer.array(), var12_12, n2 * 4 - var12_12)) {
                    }
                } else {
                    doubleBuffer = byteBuffer.asDoubleBuffer();
                    while (var12_12 < n2 * 8) {
                        var12_12 += splitCharByteInputStream.read(byteBuffer.array(), var12_12, n2 * 8 - var12_12);
                    }
                }
                switch (string2) {
                    case "x": {
                        dataSetBuilder.setValuesNoCopy(0, DataSetUtils.readDoubleArrayFromBuffer(floatBuffer, doubleBuffer));
                        continue block14;
                    }
                    case "y": {
                        dataSetBuilder.setValuesNoCopy(1, DataSetUtils.readDoubleArrayFromBuffer(floatBuffer, doubleBuffer));
                        continue block14;
                    }
                    case "eyn": {
                        dataSetBuilder.setNegErrorNoCopy(1, DataSetUtils.readDoubleArrayFromBuffer(floatBuffer, doubleBuffer));
                        continue block14;
                    }
                    case "eyp": {
                        dataSetBuilder.setPosErrorNoCopy(1, DataSetUtils.readDoubleArrayFromBuffer(floatBuffer, doubleBuffer));
                        continue block14;
                    }
                    case "z": {
                        dataSetBuilder.setValuesNoCopy(2, DataSetUtils.readDoubleArrayFromBuffer(floatBuffer, doubleBuffer));
                        continue block14;
                    }
                    default: {
                        LOGGER.atDebug().addArgument(string2).addArgument(string3).log("Got unused variable {} of type {}");
                    }
                }
            }
            return dataSetBuilder.setName(string).build();
        }
        LOGGER.error("File seems to be corrupted, Split marker not found");
        return dataSetBuilder.setName("CorruptedDataSet").setMetaErrorList("Error reading file").build();
    }

    protected static DataSet readNumericDataFromFile(BufferedReader bufferedReader, String string, boolean bl2, int n2) {
        DataSet dataSet = null;
        try {
            if (bl2) {
                Object[] objectArray;
                int n3 = 0;
                DoubleBuffer doubleBuffer = DoubleBuffer.allocate(n2);
                DoubleBuffer doubleBuffer2 = DoubleBuffer.allocate(n2);
                DoubleBuffer doubleBuffer3 = DoubleBuffer.allocate(n2);
                Object object = bufferedReader.readLine();
                while (object != null) {
                    objectArray = ((String)object).split(",");
                    if (objectArray.length != 0) {
                        double d2 = Double.parseDouble(objectArray[2]);
                        if (doubleBuffer2.position() == 0 || d2 != doubleBuffer2.get(doubleBuffer2.position() - 1)) {
                            doubleBuffer2.put(d2);
                        }
                        if (doubleBuffer2.position() < 2) {
                            doubleBuffer.put(Double.parseDouble(objectArray[1]));
                        }
                        doubleBuffer3.put(Double.parseDouble(objectArray[3]));
                        ++n3;
                    }
                    object = bufferedReader.readLine();
                }
                object = new double[doubleBuffer.position()];
                doubleBuffer.position(0);
                doubleBuffer.get((double[])object);
                objectArray = new double[doubleBuffer2.position()];
                doubleBuffer2.position(0);
                doubleBuffer2.get((double[])objectArray);
                double[][] dArray = new double[objectArray.length][((Object)object).length];
                doubleBuffer3.position(0);
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    doubleBuffer3.get(dArray[n3]);
                }
                dataSet = new DataSetBuilder(string).setValues(0, (double[])object).setValues(1, (double[])objectArray).setValues(2, dArray).build();
            } else {
                dataSet = new DoubleErrorDataSet(string);
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    String[] stringArray = string2.split(",");
                    if (stringArray.length != 0) {
                        double d3 = Double.parseDouble(stringArray[1]);
                        double d4 = Double.parseDouble(stringArray[2]);
                        double d5 = stringArray.length < 5 ? 0.0 : Double.parseDouble(stringArray[3]);
                        double d6 = stringArray.length < 5 ? 0.0 : Double.parseDouble(stringArray[4]);
                        dataSet.add(d3, d4, d5, d6);
                    }
                    string2 = bufferedReader.readLine();
                }
            }
        }
        catch (Exception exception) {
            LOGGER.atError().setCause(exception).addArgument(dataSet == null ? "null" : dataSet.getName()).log("readNumericDataFrom File could not parse numeric data for: '{}'");
        }
        return dataSet;
    }

    public static void setExportMetaDataByDefault(boolean bl2) {
        exportMetaDataByDefault = bl2;
    }

    public static void setUseFloat32BinaryStandard(boolean bl2) {
        useFloat32BinaryStandard = bl2;
    }

    public static boolean useExportMetaDataByDefault() {
        return exportMetaDataByDefault;
    }

    public static boolean useFloat32BinaryStandard() {
        return useFloat32BinaryStandard;
    }

    public static void writeDataSetToByteArray(DataSet dataSet, ByteArrayOutputStream byteArrayOutputStream, boolean bl2, boolean bl3) {
        if (dataSet == null) {
            throw new IllegalArgumentException("dataSet must not be null or empty");
        }
        if (byteArrayOutputStream == null) {
            throw new IllegalArgumentException("byteOutput must not be null or empty");
        }
        byteArrayOutputStream.reset();
        dataSet.lock().readLockGuard(() -> {
            try {
                byteArrayOutputStream.write(("#file producer : " + DataSetUtils.class.getCanonicalName() + "\n").getBytes());
                DataSetUtils.writeHeaderDataToStream(byteArrayOutputStream, dataSet);
                if (DataSetUtils.useExportMetaDataByDefault()) {
                    DataSetUtils.writeMetaDataToStream(byteArrayOutputStream, dataSet);
                }
                if (bl2) {
                    DataSetUtils.writeNumericBinaryDataToStream(byteArrayOutputStream, dataSet, bl3);
                } else {
                    DataSetUtils.writeNumericDataToStream(byteArrayOutputStream, dataSet);
                }
            }
            catch (IOException iOException) {
                LOGGER.error("could not write to ByteArrayOutputStream", iOException);
                byteArrayOutputStream.reset();
            }
        });
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String string) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, string, Compression.AUTO, false);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String string, boolean bl2) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, string, Compression.AUTO, bl2);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String string, Compression compression) {
        return DataSetUtils.writeDataSetToFile(dataSet, path, string, compression, false);
    }

    public static String writeDataSetToFile(DataSet dataSet, Path path, String string, Compression compression, boolean bl2) {
        AssertUtils.notNull("dataSet", dataSet);
        AssertUtils.notNull("path", path);
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("fileName must not be null or empty");
        }
        try {
            String string2 = DataSetUtils.getFileName(dataSet, string);
            String string3 = new File(path.toFile(), string2).getAbsolutePath();
            File file = new File(string3);
            if (file.getParentFile() != null && file.getParentFile().mkdirs()) {
                LOGGER.atInfo().addArgument(string3).log("needed to create directory for file: {}");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            try (OutputStream outputStream = DataSetUtils.openDatasetFileOutput(file, compression == Compression.AUTO ? DataSetUtils.evaluateAutoCompression(string) : compression);){
                DataSetUtils.writeDataSetToByteArray(dataSet, byteArrayOutputStream, bl2, DataSetUtils.useFloat32BinaryStandard());
                byteArrayOutputStream.writeTo(outputStream);
            }
            catch (IOException iOException) {
                LOGGER.error("could not write to file: '" + string + "'", iOException);
            }
            LOGGER.atDebug().addArgument(dataSet.getName()).addArgument(string3).log("write data set '{}' to {}");
            return string3;
        }
        catch (Exception exception) {
            LOGGER.error("could not write to file: '" + string + "'", exception);
            return null;
        }
    }

    protected static void writeHeaderDataToStream(OutputStream outputStream, DataSet dataSet) {
        try {
            StringBuilder stringBuilder = DataSetUtils.getCachedStringBuilder("headerDataCacheBuilder", 250);
            stringBuilder.append("#dataSetName : ").append(dataSet.getName()).append('\n');
            int n2 = 0;
            for (AxisDescription axisDescription : dataSet.getAxisDescriptions()) {
                stringBuilder.append('#').append(AXIS_ID.get(n2)).append("Min : ").append(axisDescription.getMin()).append('\n');
                stringBuilder.append('#').append(AXIS_ID.get(n2)).append("Max : ").append(axisDescription.getMax()).append('\n');
                stringBuilder.append('#').append(AXIS_ID.get(n2)).append("Name : ").append(axisDescription.getName()).append('\n');
                stringBuilder.append('#').append(AXIS_ID.get(n2)).append("Unit : ").append(axisDescription.getUnit()).append('\n');
                if (++n2 < 26) continue;
                LOGGER.atWarn().log("Writing Axis Metadata for more than 26 dimensional data is currently not supported, sorry");
                break;
            }
            if (dataSet.getDimension() > 2) {
                stringBuilder.append("## statistics disabled for DataSet3D, not yet implemented\n");
            } else {
                try {
                    stringBuilder.append("#integral : ").append(DataSetUtils.integralSimple(dataSet)).append("\n#mean : ").append(DataSetUtils.mean(dataSet.getValues(1))).append("\n#rms : ").append(DataSetUtils.rootMeanSquare(dataSet.getValues(1))).append('\n');
                }
                catch (Exception exception) {
                    LOGGER.atError().addArgument(dataSet.getName()).setCause(exception).log("writeHeaderDataToFile - compute Math error for dataSet = '{}'");
                }
            }
            outputStream.write(stringBuilder.toString().getBytes());
            DataSetUtils.release("headerDataCacheBuilder", stringBuilder);
        }
        catch (Exception exception) {
            LOGGER.atError().setCause(exception).addArgument(dataSet.getName()).log("writeHeaderDataToFile - error for dataSet = '{}'");
        }
    }

    protected static void writeMetaDataToStream(OutputStream outputStream, DataSet dataSet) {
        if (!(dataSet instanceof DataSetMetaData)) {
            return;
        }
        DataSetMetaData dataSetMetaData = (DataSetMetaData)((Object)dataSet);
        try {
            StringBuilder stringBuilder = DataSetUtils.getCachedStringBuilder(CACHED_META_DATA_STRING_BUILDER, 1000);
            for (String object : dataSetMetaData.getInfoList()) {
                stringBuilder.append("#info : ").append(object).append('\n');
            }
            for (String string : dataSetMetaData.getWarningList()) {
                stringBuilder.append("#warning : ").append(string).append('\n');
            }
            for (String string : dataSetMetaData.getErrorList()) {
                stringBuilder.append("#error : ").append(string).append('\n');
            }
            Map<String, String> map = dataSetMetaData.getMetaInfo();
            for (String string : dataSetMetaData.getMetaInfo().keySet()) {
                stringBuilder.append("#metaKey -").append(string).append(" : ").append((String)map.get(string)).append('\n');
            }
            outputStream.write(stringBuilder.toString().getBytes());
            DataSetUtils.release(CACHED_META_DATA_STRING_BUILDER, stringBuilder);
        }
        catch (Exception exception) {
            LOGGER.error("writeMetaDataToFile - error for dataSet = '" + dataSet.getName() + "'", exception);
        }
    }

    private static void writeNumericBinaryDataToStream(OutputStream outputStream, DataSet dataSet, boolean bl2) {
        int[] nArray;
        StringBuilder stringBuilder = DataSetUtils.getCachedStringBuilder("binaryDataCacheBuilder", 250);
        stringBuilder.append("$binary\n");
        String string = bl2 ? "float32[]" : "float64[]";
        boolean bl3 = dataSet instanceof GridDataSet;
        if (bl3) {
            nArray = ((GridDataSet)dataSet).getShape();
            if (nArray.length != 2 || dataSet.getDimension() != 3) {
                throw new IllegalArgumentException("Only 3D DataSets implemented yet");
            }
            stringBuilder.append("$x;").append(string).append(';').append(nArray[0]);
            stringBuilder.append("\n$y;").append(string).append(';').append(nArray[1]);
            stringBuilder.append("\n$z;").append(string).append(';').append(dataSet.getDataCount()).append('\n');
        } else {
            stringBuilder.append("$x;").append(string).append(';').append(dataSet.getDataCount());
            stringBuilder.append("\n$y;").append(string).append(';').append(dataSet.getDataCount());
            stringBuilder.append("\n$eyn;").append(string).append(';').append(dataSet.getDataCount());
            stringBuilder.append("\n$eyp;").append(string).append(';').append(dataSet.getDataCount()).append('\n');
        }
        try {
            outputStream.write(stringBuilder.toString().getBytes());
        }
        catch (IOException iOException) {
            LOGGER.atError().setCause(iOException).log("WriteNumericDataToBinaryFile failed to write header description");
        }
        DataSetUtils.release("binaryDataCacheBuilder", stringBuilder);
        try {
            outputStream.write(254);
            if (bl2 && !bl3) {
                int n2 = dataSet.getDataCount();
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray(CACHED_WRITE_BYTE_BUFFER, 4 * n2);
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, dataSet.getValues(0), n2);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, dataSet.getValues(1), n2);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYN), n2);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayAsFloatToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYP), n2);
                outputStream.write(byteBuffer.array());
                DataSetUtils.release(CACHED_WRITE_BYTE_BUFFER, byteBuffer);
            } else if (!bl2 && !bl3) {
                int n3 = dataSet.getDataCount();
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray(CACHED_WRITE_BYTE_BUFFER, 8 * n3);
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, dataSet.getValues(0), n3);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, dataSet.getValues(1), n3);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYN), n3);
                outputStream.write(byteBuffer.array());
                DataSetUtils.writeDoubleArrayToByteBuffer(byteBuffer, DataSetUtils.errors(dataSet, ErrType.EYP), n3);
                outputStream.write(byteBuffer.array());
                DataSetUtils.release(CACHED_WRITE_BYTE_BUFFER, byteBuffer);
            } else if (bl2) {
                int n4;
                nArray = ((GridDataSet)dataSet).getShape();
                int n5 = nArray[0];
                int n6 = nArray[1];
                int n7 = dataSet.getDataCount();
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray(CACHED_WRITE_BYTE_BUFFER, 4 * (n5 + n6 + n7));
                for (n4 = 0; n4 < n5; ++n4) {
                    byteBuffer.putFloat((float)((GridDataSet)dataSet).getGrid(0, n4));
                }
                for (n4 = 0; n4 < n6; ++n4) {
                    byteBuffer.putFloat((float)((GridDataSet)dataSet).getGrid(1, n4));
                }
                for (n4 = 0; n4 < n7; ++n4) {
                    byteBuffer.putFloat((float)dataSet.get(2, n4));
                }
                outputStream.write(byteBuffer.array());
                DataSetUtils.release(CACHED_WRITE_BYTE_BUFFER, byteBuffer);
            } else {
                int n8;
                nArray = ((GridDataSet)dataSet).getShape();
                int n9 = nArray[0];
                int n10 = nArray[1];
                int n11 = dataSet.getDataCount();
                ByteBuffer byteBuffer = DataSetUtils.getCachedDoubleArray(CACHED_WRITE_BYTE_BUFFER, 8 * (n9 + n10 + n11));
                for (n8 = 0; n8 < n9; ++n8) {
                    byteBuffer.putDouble(((GridDataSet)dataSet).getGrid(0, n8));
                }
                for (n8 = 0; n8 < n10; ++n8) {
                    byteBuffer.putDouble(((GridDataSet)dataSet).getGrid(1, n8));
                }
                for (n8 = 0; n8 < n11; ++n8) {
                    byteBuffer.putDouble(dataSet.get(2, n8));
                }
                outputStream.write(byteBuffer.array());
                DataSetUtils.release(CACHED_WRITE_BYTE_BUFFER, byteBuffer);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("WriteNumericDataToBinaryFile failed to write binary body: ", iOException);
        }
    }

    protected static void writeNumericDataToStream(OutputStream outputStream, DataSet dataSet) {
        try {
            boolean bl2 = dataSet instanceof GridDataSet;
            if (bl2) {
                int[] nArray = ((GridDataSet)dataSet).getShape();
                if (nArray.length != 2 || dataSet.getDimension() != 3) {
                    throw new IllegalArgumentException("Only 3D DataSets implemented yet");
                }
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = dataSet.getDataCount();
                StringBuilder stringBuilder = DataSetUtils.getCachedStringBuilder(CACHED_STRING_BUILDER, Math.max(100, n4 * 45));
                stringBuilder.append("#nSamples : ").append(n4).append("\n$index, x, y, z\n");
                for (int i2 = 0; i2 < n3; ++i2) {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        stringBuilder.append(i2 * n2 + i3);
                        stringBuilder.append(',');
                        stringBuilder.append(((GridDataSet)dataSet).getGrid(0, i3));
                        stringBuilder.append(',');
                        stringBuilder.append(((GridDataSet)dataSet).getGrid(1, i2));
                        stringBuilder.append(',');
                        stringBuilder.append(dataSet.get(2, i3 + i2 * n2));
                        stringBuilder.append('\n');
                    }
                }
                outputStream.write(stringBuilder.toString().getBytes());
            } else {
                int n5 = dataSet.getDataCount();
                StringBuilder stringBuilder = DataSetUtils.getCachedStringBuilder(CACHED_STRING_BUILDER, Math.max(100, n5 * 45));
                stringBuilder.append("#nSamples : ").append(n5).append("\n$index, x, y, eyn, eyp\n");
                for (int i4 = 0; i4 < n5; ++i4) {
                    stringBuilder.append(i4);
                    stringBuilder.append(',');
                    stringBuilder.append(dataSet.get(0, i4));
                    stringBuilder.append(',');
                    stringBuilder.append(dataSet.get(1, i4));
                    stringBuilder.append(',');
                    stringBuilder.append(DataSetUtils.error(dataSet, ErrType.EYN, i4));
                    stringBuilder.append(',');
                    stringBuilder.append(DataSetUtils.error(dataSet, ErrType.EYP, i4));
                    stringBuilder.append('\n');
                }
                outputStream.write(stringBuilder.toString().getBytes());
                DataSetUtils.release(CACHED_STRING_BUILDER, stringBuilder);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("writeNumericDataToFile - error for dataSet = '" + dataSet.getName() + "'", iOException);
        }
    }

    public static enum ErrType {
        EXN,
        EXP,
        EYN,
        EYP;

    }

    public static enum Compression {
        AUTO,
        GZIP,
        ZIP,
        NONE;

    }

    protected static class SplitCharByteInputStream
    extends FilterInputStream {
        protected static final byte MARKER = -2;
        private final PushbackInputStream pbin;
        private boolean binary;
        private boolean hasMarker;

        public SplitCharByteInputStream(PushbackInputStream pushbackInputStream) {
            super(pushbackInputStream);
            this.pbin = pushbackInputStream;
        }

        public boolean reachedSplit() {
            return this.hasMarker && !this.binary;
        }

        @Override
        public int read() throws IOException {
            if (this.hasMarker && !this.binary) {
                return -1;
            }
            byte by2 = (byte)this.in.read();
            if (!this.binary && by2 == -2) {
                this.hasMarker = true;
                return -1;
            }
            return by2 == -1 ? -1 : by2 & 0xFF;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            int n2;
            if (this.hasMarker) {
                if (!this.binary) {
                    return -1;
                }
                n2 = this.in.read(byArray, 0, byArray.length);
            } else {
                n2 = this.in.read(byArray, 0, byArray.length);
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    if (byArray[i2] != -2) continue;
                    this.pbin.unread(byArray, i2 + 1, n2 - i2 - 1);
                    this.hasMarker = true;
                    return i2;
                }
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            if (this.hasMarker) {
                if (!this.binary) {
                    return -1;
                }
                n4 = this.in.read(byArray, n2, n3);
            } else {
                n4 = this.in.read(byArray, n2, n3);
                for (int i2 = n2; i2 < n2 + n4; ++i2) {
                    if (byArray[i2] != -2) continue;
                    this.pbin.unread(byArray, i2 + 1, n2 + n4 - i2 - 1);
                    this.hasMarker = true;
                    return i2 - n2;
                }
            }
            return n4;
        }

        public void switchToBinary() {
            if (this.hasMarker) {
                if (this.binary) {
                    LOGGER.warn("Allready in binary mode");
                } else {
                    this.binary = true;
                }
            } else {
                LOGGER.warn("Char/Byte split marker not reached yet");
            }
        }
    }
}

