/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class Cache<K, V>
implements Map<K, V> {
    private final ConcurrentHashMap<K, V> dataCache;
    private final ConcurrentHashMap<K, Instant> timeOutMap;
    private final ChronoUnit chronoUnit;
    private final TimeUnit timeUnit;
    private final long timeOut;
    private final int limit;
    private final BiConsumer<K, V> preListener;
    private final BiConsumer<K, V> postListener;

    public Cache(int n2) {
        this(0L, TimeUnit.MILLISECONDS, n2, null, null);
    }

    public Cache(long l2, TimeUnit timeUnit) {
        this(l2, timeUnit, Integer.MAX_VALUE, null, null);
    }

    public Cache(long l2, TimeUnit timeUnit, int n2) {
        this(l2, timeUnit, n2, null, null);
    }

    private Cache(long l2, TimeUnit timeUnit, int n2, BiConsumer<K, V> biConsumer, BiConsumer<K, V> biConsumer2) {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName(Cache.class.getCanonicalName() + "-Thread");
            thread.setDaemon(true);
            return thread;
        });
        this.dataCache = new ConcurrentHashMap();
        this.timeOutMap = new ConcurrentHashMap();
        if (l2 < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        if (l2 > 0L && null == timeUnit) {
            throw new IllegalArgumentException("TimeUnit cannot be null if timeOut is > 0");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Limit cannot be smaller than 1");
        }
        this.timeOut = l2;
        this.timeUnit = timeUnit;
        this.chronoUnit = Cache.convertToChronoUnit(timeUnit);
        this.limit = n2;
        this.preListener = biConsumer;
        this.postListener = biConsumer2;
        if (l2 != 0L) {
            scheduledExecutorService.scheduleAtFixedRate(this::checkTime, 0L, l2, timeUnit);
        }
    }

    @Override
    public void clear() {
        this.dataCache.clear();
        this.timeOutMap.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.dataCache.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.dataCache.containsValue(object);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.dataCache.entrySet();
    }

    @Override
    public V get(Object object) {
        return this.getIfPresent(object);
    }

    public V getIfPresent(K k2) {
        this.timeOutMap.put(k2, Instant.now());
        return this.dataCache.getOrDefault(k2, null);
    }

    public long getLimit() {
        return this.limit;
    }

    public Optional<V> getOptional(K k2) {
        return Optional.ofNullable(this.getIfPresent(k2));
    }

    public int getSize() {
        return this.dataCache.size();
    }

    public long getTimeout() {
        return this.timeOut;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public boolean isEmpty() {
        return this.dataCache.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.dataCache.keySet();
    }

    @Override
    public V put(K k2, V v2) {
        this.checkSize();
        V v3 = this.dataCache.put(k2, v2);
        this.timeOutMap.put(k2, Instant.now());
        return v3;
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        this.checkSize();
        V v3 = this.dataCache.putIfAbsent(k2, v2);
        this.timeOutMap.putIfAbsent(k2, Instant.now());
        return v3;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkSize(map.size());
        this.dataCache.putAll(map);
        Instant instant = Instant.now();
        map.keySet().forEach((? super T object) -> this.timeOutMap.putIfAbsent(object, instant));
    }

    @Override
    public V remove(Object object) {
        V v2 = this.dataCache.remove(object);
        this.timeOutMap.remove(object);
        return v2;
    }

    @Override
    public int size() {
        return this.dataCache.size();
    }

    @Override
    public Collection<V> values() {
        return this.dataCache.values();
    }

    protected void checkSize() {
        this.checkSize(1);
    }

    protected void checkSize(int n2) {
        if (this.dataCache.size() < this.limit) {
            return;
        }
        int n3 = Math.max(this.dataCache.size() - this.limit + n2, 0);
        List list = this.timeOutMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(n3).map(Map.Entry::getKey).collect(Collectors.toList());
        this.removeEntries(list);
    }

    protected void checkTime() {
        Instant instant = Instant.now().minus(this.timeOut, this.chronoUnit);
        List list = this.timeOutMap.entrySet().stream().filter(entry -> ((Instant)entry.getValue()).isBefore(instant)).map(Map.Entry::getKey).collect(Collectors.toList());
        this.removeEntries(list);
    }

    private void removeEntries(List<K> list) {
        HashMap<Object, Object> hashMap;
        if (this.preListener == null && this.postListener == null) {
            hashMap = null;
        } else {
            hashMap = new HashMap<Object, Object>();
            list.forEach((? super T object) -> hashMap.put(object, this.dataCache.get(object)));
        }
        if (this.preListener != null) {
            hashMap.forEach(this.preListener::accept);
        }
        list.forEach((? super T object) -> {
            this.timeOutMap.remove(object);
            this.dataCache.remove(object);
        });
        if (this.postListener != null) {
            hashMap.forEach(this.postListener::accept);
        }
    }

    public static <K3, V3> CacheBuilder<K3, V3> builder() {
        return new CacheBuilder();
    }

    protected static int clamp(int n2, int n3, int n4) {
        if (n4 < n2) {
            return n2;
        }
        if (n4 > n3) {
            return n3;
        }
        return n4;
    }

    protected static long clamp(long l2, long l3, long l4) {
        if (l4 < l2) {
            return l2;
        }
        if (l4 > l3) {
            return l3;
        }
        return l4;
    }

    protected static ChronoUnit convertToChronoUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        return ChronoUnit.MILLIS;
    }

    public static class CacheBuilder<K2, V2> {
        private int limit = Integer.MAX_VALUE;
        private long timeOut = 0L;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private BiConsumer<K2, V2> preListener = null;
        private BiConsumer<K2, V2> postListener = null;

        private CacheBuilder() {
        }

        public Cache<K2, V2> build() {
            return new Cache<K2, V2>(this.timeOut, this.timeUnit, this.limit, this.preListener, this.postListener);
        }

        public CacheBuilder<K2, V2> withLimit(int n2) {
            if (n2 < 1) {
                throw new IllegalArgumentException("Limit cannot be smaller than 1");
            }
            this.limit = n2;
            return this;
        }

        public CacheBuilder<K2, V2> withPostListener(BiConsumer<K2, V2> biConsumer) {
            if (biConsumer == null) {
                throw new IllegalArgumentException("listener cannot be null");
            }
            this.postListener = biConsumer;
            return this;
        }

        public CacheBuilder<K2, V2> withPreListener(BiConsumer<K2, V2> biConsumer) {
            if (biConsumer == null) {
                throw new IllegalArgumentException("listener cannot be null");
            }
            this.preListener = biConsumer;
            return this;
        }

        public CacheBuilder<K2, V2> withTimeout(long l2, TimeUnit timeUnit) {
            if (l2 < 0L) {
                throw new IllegalArgumentException("Timeout cannot be negative");
            }
            if (null == timeUnit) {
                throw new IllegalArgumentException("TimeUnit cannot be null");
            }
            this.timeOut = Cache.clamp(0L, Integer.MAX_VALUE, l2);
            this.timeUnit = timeUnit;
            return this;
        }
    }
}

