/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.testdata.spi;

import io.fair_acc.dataset.testdata.spi.AbstractTestFunction;

public class SineFunction
extends AbstractTestFunction<SineFunction> {
    private static final long serialVersionUID = -4573144986461354456L;
    private final boolean useSystemTimeOffset;

    public SineFunction(String string, int n2) {
        super(string, n2);
        this.useSystemTimeOffset = false;
    }

    public SineFunction(String string, int n2, boolean bl2) {
        super(string, n2);
        this.useSystemTimeOffset = bl2;
        this.update();
    }

    @Override
    public double[] generateY(int n2) {
        double[] dArray = new double[n2];
        double d2 = (double)n2 / 10.0;
        double d3 = this.useSystemTimeOffset ? (double)System.currentTimeMillis() / 1000.0 : 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = (double)i2 / d2;
            dArray[i2] = Math.sin(Math.PI * 2 * (d4 + 0.1 * d3));
        }
        return dArray;
    }
}

