/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.testdata.spi;

import io.fair_acc.dataset.testdata.spi.AbstractTestFunction;

public class GaussFunction
extends AbstractTestFunction<GaussFunction> {
    private static final long serialVersionUID = -2090964369869257806L;
    private final double centre;
    private final double sigma;

    public GaussFunction(String string, int n2) {
        super(string, n2);
        this.centre = 0.5 * (double)n2;
        this.sigma = 0.1 * (double)n2;
        this.update();
    }

    public GaussFunction(String string, int n2, double d2, double d3) {
        super(string, n2);
        this.centre = d2;
        this.sigma = d3;
        this.update();
    }

    @Override
    public double[] generateY(int n2) {
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = GaussFunction.gauss(i2, this.centre, this.sigma) * this.sigma;
        }
        return dArray;
    }

    public static double gauss(double d2) {
        return Math.exp(-d2 * d2 / 2.0) / Math.sqrt(Math.PI * 2);
    }

    public static double gauss(double d2, double d3, double d4) {
        return GaussFunction.gauss((d2 - d3) / d4) / d4;
    }
}

