/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayShort
extends MultiArray<short[]> {
    public static MultiArrayShort wrap(short[] sArray) {
        return MultiArrayShort.wrap(sArray, 0, sArray.length);
    }

    public static MultiArrayShort wrap(short[] sArray, int n2, int n3) {
        return new MultiArray1DShort(sArray, new int[]{n3}, n2);
    }

    public static MultiArrayShort wrap(short[] sArray, int[] nArray) {
        return MultiArrayShort.wrap(sArray, 0, nArray);
    }

    public static MultiArrayShort wrap(short[] sArray, int n2, int[] nArray) {
        int n3 = 1;
        for (int n4 : nArray) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, sArray.length);
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DShort(sArray, nArray, n2);
            }
            case 2: {
                return new MultiArray2DShort(sArray, nArray, n2);
            }
        }
        return new MultiArrayShort(sArray, nArray, n2);
    }

    public static MultiArrayShort allocate(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DShort(new short[nArray[0]], nArray, 0);
            }
            case 2: {
                return new MultiArray2DShort(new short[nArray[1] * nArray[0]], nArray, 0);
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        return new MultiArrayShort(new short[n2], nArray, 0);
    }

    protected MultiArrayShort(short[] sArray, int[] nArray, int n2) {
        super(sArray, nArray, n2);
    }

    public void setStrided(int n2, short s2) {
        ((short[])this.elements)[n2 + this.offset] = s2;
    }

    public void set(int[] nArray, short s2) {
        ((short[])this.elements)[this.getIndex((int[])nArray)] = s2;
    }

    public short getStrided(int n2) {
        return ((short[])this.elements)[n2 + this.offset];
    }

    public short get(int[] nArray) {
        return ((short[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayShort)) {
            return false;
        }
        MultiArrayShort multiArrayShort = (MultiArrayShort)object;
        return Arrays.equals(this.dimensions, multiArrayShort.dimensions) && Arrays.equals((short[])this.elements, this.offset, this.offset + this.getElementsCount(), (short[])multiArrayShort.elements, multiArrayShort.offset, multiArrayShort.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + Short.hashCode(((short[])this.elements)[i2]);
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DShort
    extends MultiArrayShort {
        protected MultiArray1DShort(short[] sArray, int[] nArray, int n2) {
            super(sArray, nArray, n2);
        }

        public short get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, short s2) {
            this.setStrided(n2, s2);
        }
    }

    public static class MultiArray2DShort
    extends MultiArrayShort {
        private final int stride;

        protected MultiArray2DShort(short[] sArray, int[] nArray, int n2) {
            super(sArray, nArray, n2);
            this.stride = nArray[1];
        }

        public short get(int n2, int n3) {
            return ((short[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, short s2) {
            ((short[])this.elements)[this.offset + n3 + n2 * this.stride] = s2;
        }

        public short[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((short[])this.elements, n3, n3 + this.stride);
        }
    }
}

