/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayFloat
extends MultiArray<float[]> {
    public static MultiArrayFloat wrap(float[] fArray) {
        return MultiArrayFloat.wrap(fArray, 0, fArray.length);
    }

    public static MultiArrayFloat wrap(float[] fArray, int n2, int n3) {
        return new MultiArray1DFloat(fArray, new int[]{n3}, n2);
    }

    public static MultiArrayFloat wrap(float[] fArray, int[] nArray) {
        return MultiArrayFloat.wrap(fArray, 0, nArray);
    }

    public static MultiArrayFloat wrap(float[] fArray, int n2, int[] nArray) {
        int n3 = 1;
        for (int n4 : nArray) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, fArray.length);
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DFloat(fArray, nArray, n2);
            }
            case 2: {
                return new MultiArray2DFloat(fArray, nArray, n2);
            }
        }
        return new MultiArrayFloat(fArray, nArray, n2);
    }

    public static MultiArrayFloat allocate(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DFloat(new float[nArray[0]], nArray, 0);
            }
            case 2: {
                return new MultiArray2DFloat(new float[nArray[1] * nArray[0]], nArray, 0);
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        return new MultiArrayFloat(new float[n2], nArray, 0);
    }

    protected MultiArrayFloat(float[] fArray, int[] nArray, int n2) {
        super(fArray, nArray, n2);
    }

    public void setStrided(int n2, float f2) {
        ((float[])this.elements)[n2 + this.offset] = f2;
    }

    public void set(int[] nArray, float f2) {
        ((float[])this.elements)[this.getIndex((int[])nArray)] = f2;
    }

    public float getStrided(int n2) {
        return ((float[])this.elements)[n2 + this.offset];
    }

    public float get(int[] nArray) {
        return ((float[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayFloat)) {
            return false;
        }
        MultiArrayFloat multiArrayFloat = (MultiArrayFloat)object;
        return Arrays.equals(this.dimensions, multiArrayFloat.dimensions) && Arrays.equals((float[])this.elements, this.offset, this.offset + this.getElementsCount(), (float[])multiArrayFloat.elements, multiArrayFloat.offset, multiArrayFloat.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + Float.hashCode(((float[])this.elements)[i2]);
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DFloat
    extends MultiArrayFloat {
        protected MultiArray1DFloat(float[] fArray, int[] nArray, int n2) {
            super(fArray, nArray, n2);
        }

        public float get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, float f2) {
            this.setStrided(n2, f2);
        }
    }

    public static class MultiArray2DFloat
    extends MultiArrayFloat {
        private final int stride;

        protected MultiArray2DFloat(float[] fArray, int[] nArray, int n2) {
            super(fArray, nArray, n2);
            this.stride = nArray[1];
        }

        public float get(int n2, int n3) {
            return ((float[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, float f2) {
            ((float[])this.elements)[this.offset + n3 + n2 * this.stride] = f2;
        }

        public float[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((float[])this.elements, n3, n3 + this.stride);
        }
    }
}

