/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayChar
extends MultiArray<char[]> {
    public static MultiArrayChar wrap(char[] cArray) {
        return MultiArrayChar.wrap(cArray, 0, cArray.length);
    }

    public static MultiArrayChar wrap(char[] cArray, int n2, int n3) {
        return new MultiArray1DChar(cArray, new int[]{n3}, n2);
    }

    public static MultiArrayChar wrap(char[] cArray, int[] nArray) {
        return MultiArrayChar.wrap(cArray, 0, nArray);
    }

    public static MultiArrayChar wrap(char[] cArray, int n2, int[] nArray) {
        int n3 = 1;
        for (int n4 : nArray) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, cArray.length);
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DChar(cArray, nArray, n2);
            }
            case 2: {
                return new MultiArray2DChar(cArray, nArray, n2);
            }
        }
        return new MultiArrayChar(cArray, nArray, n2);
    }

    public static MultiArrayChar allocate(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DChar(new char[nArray[0]], nArray, 0);
            }
            case 2: {
                return new MultiArray2DChar(new char[nArray[1] * nArray[0]], nArray, 0);
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        return new MultiArrayChar(new char[n2], nArray, 0);
    }

    protected MultiArrayChar(char[] cArray, int[] nArray, int n2) {
        super(cArray, nArray, n2);
    }

    public void setStrided(int n2, char c2) {
        ((char[])this.elements)[n2 + this.offset] = c2;
    }

    public void set(int[] nArray, char c2) {
        ((char[])this.elements)[this.getIndex((int[])nArray)] = c2;
    }

    public char getStrided(int n2) {
        return ((char[])this.elements)[n2 + this.offset];
    }

    public char get(int[] nArray) {
        return ((char[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayChar)) {
            return false;
        }
        MultiArrayChar multiArrayChar = (MultiArrayChar)object;
        return Arrays.equals(this.dimensions, multiArrayChar.dimensions) && Arrays.equals((char[])this.elements, this.offset, this.offset + this.getElementsCount(), (char[])multiArrayChar.elements, multiArrayChar.offset, multiArrayChar.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + Character.hashCode(((char[])this.elements)[i2]);
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DChar
    extends MultiArrayChar {
        protected MultiArray1DChar(char[] cArray, int[] nArray, int n2) {
            super(cArray, nArray, n2);
        }

        public char get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, char c2) {
            this.setStrided(n2, c2);
        }
    }

    public static class MultiArray2DChar
    extends MultiArrayChar {
        private final int stride;

        protected MultiArray2DChar(char[] cArray, int[] nArray, int n2) {
            super(cArray, nArray, n2);
            this.stride = nArray[1];
        }

        public char get(int n2, int n3) {
            return ((char[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, char c2) {
            ((char[])this.elements)[this.offset + n3 + n2 * this.stride] = c2;
        }

        public char[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((char[])this.elements, n3, n3 + this.stride);
        }
    }
}

