/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayByte
extends MultiArray<byte[]> {
    public static MultiArrayByte wrap(byte[] byArray) {
        return MultiArrayByte.wrap(byArray, 0, byArray.length);
    }

    public static MultiArrayByte wrap(byte[] byArray, int n2, int n3) {
        return new MultiArray1DByte(byArray, new int[]{n3}, n2);
    }

    public static MultiArrayByte wrap(byte[] byArray, int[] nArray) {
        return MultiArrayByte.wrap(byArray, 0, nArray);
    }

    public static MultiArrayByte wrap(byte[] byArray, int n2, int[] nArray) {
        int n3 = 1;
        for (int n4 : nArray) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, byArray.length);
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DByte(byArray, nArray, n2);
            }
            case 2: {
                return new MultiArray2DByte(byArray, nArray, n2);
            }
        }
        return new MultiArrayByte(byArray, nArray, n2);
    }

    public static MultiArrayByte allocate(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DByte(new byte[nArray[0]], nArray, 0);
            }
            case 2: {
                return new MultiArray2DByte(new byte[nArray[1] * nArray[0]], nArray, 0);
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        return new MultiArrayByte(new byte[n2], nArray, 0);
    }

    protected MultiArrayByte(byte[] byArray, int[] nArray, int n2) {
        super(byArray, nArray, n2);
    }

    public void setStrided(int n2, byte by2) {
        ((byte[])this.elements)[n2 + this.offset] = by2;
    }

    public void set(int[] nArray, byte by2) {
        ((byte[])this.elements)[this.getIndex((int[])nArray)] = by2;
    }

    public byte getStrided(int n2) {
        return ((byte[])this.elements)[n2 + this.offset];
    }

    public byte get(int[] nArray) {
        return ((byte[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayByte)) {
            return false;
        }
        MultiArrayByte multiArrayByte = (MultiArrayByte)object;
        return Arrays.equals(this.dimensions, multiArrayByte.dimensions) && Arrays.equals((byte[])this.elements, this.offset, this.offset + this.getElementsCount(), (byte[])multiArrayByte.elements, multiArrayByte.offset, multiArrayByte.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + Byte.hashCode(((byte[])this.elements)[i2]);
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DByte
    extends MultiArrayByte {
        protected MultiArray1DByte(byte[] byArray, int[] nArray, int n2) {
            super(byArray, nArray, n2);
        }

        public byte get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, byte by2) {
            this.setStrided(n2, by2);
        }
    }

    public static class MultiArray2DByte
    extends MultiArrayByte {
        private final int stride;

        protected MultiArray2DByte(byte[] byArray, int[] nArray, int n2) {
            super(byArray, nArray, n2);
            this.stride = nArray[1];
        }

        public byte get(int n2, int n3) {
            return ((byte[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, byte by2) {
            ((byte[])this.elements)[this.offset + n3 + n2 * this.stride] = by2;
        }

        public byte[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((byte[])this.elements, n3, n3 + this.stride);
        }
    }
}

