/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.utils.MultiArray;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayBoolean
extends MultiArray<boolean[]> {
    public static MultiArrayBoolean wrap(boolean[] blArray) {
        return MultiArrayBoolean.wrap(blArray, 0, blArray.length);
    }

    public static MultiArrayBoolean wrap(boolean[] blArray, int n2, int n3) {
        return new MultiArray1DBoolean(blArray, new int[]{n3}, n2);
    }

    public static MultiArrayBoolean wrap(boolean[] blArray, int[] nArray) {
        return MultiArrayBoolean.wrap(blArray, 0, nArray);
    }

    public static MultiArrayBoolean wrap(boolean[] blArray, int n2, int[] nArray) {
        int n3 = 1;
        for (int n4 : nArray) {
            n3 *= n4;
        }
        AssertUtils.gtOrEqual("Array size", n3 + n2, blArray.length);
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DBoolean(blArray, nArray, n2);
            }
            case 2: {
                return new MultiArray2DBoolean(blArray, nArray, n2);
            }
        }
        return new MultiArrayBoolean(blArray, nArray, n2);
    }

    public static MultiArrayBoolean allocate(int[] nArray) {
        switch (nArray.length) {
            case 1: {
                return new MultiArray1DBoolean(new boolean[nArray[0]], nArray, 0);
            }
            case 2: {
                return new MultiArray2DBoolean(new boolean[nArray[1] * nArray[0]], nArray, 0);
            }
        }
        int n2 = 1;
        for (int n3 : nArray) {
            n2 *= n3;
        }
        return new MultiArrayBoolean(new boolean[n2], nArray, 0);
    }

    protected MultiArrayBoolean(boolean[] blArray, int[] nArray, int n2) {
        super(blArray, nArray, n2);
    }

    public void setStrided(int n2, boolean bl2) {
        ((boolean[])this.elements)[n2 + this.offset] = bl2;
    }

    public void set(int[] nArray, boolean bl2) {
        ((boolean[])this.elements)[this.getIndex((int[])nArray)] = bl2;
    }

    public boolean getStrided(int n2) {
        return ((boolean[])this.elements)[n2 + this.offset];
    }

    public boolean get(int[] nArray) {
        return ((boolean[])this.elements)[this.getIndex(nArray)];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MultiArrayBoolean)) {
            return false;
        }
        MultiArrayBoolean multiArrayBoolean = (MultiArrayBoolean)object;
        return Arrays.equals(this.dimensions, multiArrayBoolean.dimensions) && Arrays.equals((boolean[])this.elements, this.offset, this.offset + this.getElementsCount(), (boolean[])multiArrayBoolean.elements, multiArrayBoolean.offset, multiArrayBoolean.offset + this.getElementsCount());
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.offset; i2 < this.offset + this.getElementsCount(); ++i2) {
            n2 = 31 * n2 + Boolean.hashCode(((boolean[])this.elements)[i2]);
        }
        n2 = 31 * n2 + Arrays.hashCode(this.dimensions);
        return n2;
    }

    public static class MultiArray1DBoolean
    extends MultiArrayBoolean {
        protected MultiArray1DBoolean(boolean[] blArray, int[] nArray, int n2) {
            super(blArray, nArray, n2);
        }

        public boolean get(int n2) {
            return this.getStrided(n2);
        }

        public void set(int n2, boolean bl2) {
            this.setStrided(n2, bl2);
        }
    }

    public static class MultiArray2DBoolean
    extends MultiArrayBoolean {
        private final int stride;

        protected MultiArray2DBoolean(boolean[] blArray, int[] nArray, int n2) {
            super(blArray, nArray, n2);
            this.stride = nArray[1];
        }

        public boolean get(int n2, int n3) {
            return ((boolean[])this.elements)[this.offset + n3 + n2 * this.stride];
        }

        public void set(int n2, int n3, boolean bl2) {
            ((boolean[])this.elements)[this.offset + n3 + n2 * this.stride] = bl2;
        }

        public boolean[] getRow(int n2) {
            int n3 = n2 * this.stride + this.offset;
            return Arrays.copyOfRange((boolean[])this.elements, n3, n3 + this.stride);
        }
    }
}

