/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.financial.api.attrs;

import io.fair_acc.dataset.spi.financial.api.attrs.AttributeKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class AttributeModel
implements Cloneable {
    private Map<AttributeKey<?>, Object> attributes;

    public AttributeModel() {
        this.attributes = new LinkedHashMap();
    }

    public AttributeModel(Map<AttributeKey<?>, Object> map) {
        this.attributes = map;
    }

    public static AttributeModel configure() {
        return new AttributeModel();
    }

    public static AttributeModel configure(AttributeModel attributeModel) {
        return attributeModel.deepCopyAttributes();
    }

    public <T> T getAttribute(AttributeKey<T> attributeKey) {
        return (T)this.attributes.get(attributeKey);
    }

    public <T> T getRequiredAttribute(AttributeKey<T> attributeKey) {
        T t2 = this.getAttribute(attributeKey);
        if (t2 == null) {
            throw new IllegalArgumentException("The attribute " + attributeKey + " is required!");
        }
        return t2;
    }

    public <T> T getAttribute(AttributeKey<T> attributeKey, T t2) {
        Object object = this.attributes.get(attributeKey);
        if (object == null) {
            return t2;
        }
        return (T)object;
    }

    public <T> T getAttributeAndSet(AttributeKey<T> attributeKey, T t2) {
        Object object = this.attributes.get(attributeKey);
        if (object == null) {
            this.setAttribute(attributeKey, t2);
            return t2;
        }
        return (T)object;
    }

    public <T, E extends T> E getAttribute(AttributeKey<T> attributeKey, Class<E> clazz) {
        Object object = this.attributes.get(attributeKey);
        return (E)object;
    }

    public <T, E extends T> E getAttribute(AttributeKey<T> attributeKey, Class<E> clazz, E e2) {
        Object object = this.attributes.get(attributeKey);
        if (object == null) {
            return e2;
        }
        return (E)object;
    }

    public <T> AttributeModel setAttribute(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null) {
            throw new IllegalArgumentException("The attribute key hasn't be null");
        }
        if (t2 == null) {
            this.attributes.remove(attributeKey);
        } else {
            this.attributes.put(attributeKey, t2);
        }
        return this;
    }

    public boolean containsAttribute(AttributeKey<?> attributeKey) {
        return this.attributes.containsKey(attributeKey);
    }

    public Set<AttributeKey<?>> getAttributes() {
        return this.attributes.keySet();
    }

    public synchronized void merge(AttributeModel attributeModel) {
        AttributeModel attributeModel2 = (AttributeModel)attributeModel.clone();
        for (AttributeKey<?> attributeKey : attributeModel2.getAttributes()) {
            if (AttributeModel.class.isAssignableFrom(attributeKey.getType())) {
                AttributeModel attributeModel3 = (AttributeModel)attributeModel2.getAttribute(attributeKey);
                attributeModel3 = attributeModel3.deepCopyAttributes();
                this.setAttribute(attributeKey, attributeModel3);
                continue;
            }
            this.setAttribute(attributeKey, attributeModel2.getAttribute(attributeKey));
        }
    }

    public synchronized AttributeModel deepCopyAttributes() {
        AttributeModel attributeModel = (AttributeModel)this.clone();
        for (AttributeKey<?> attributeKey : new HashSet(attributeModel.getAttributes())) {
            if (!AttributeModel.class.isAssignableFrom(attributeKey.getType())) continue;
            AttributeModel attributeModel2 = (AttributeModel)attributeModel.getAttribute(attributeKey);
            attributeModel2 = attributeModel2.deepCopyAttributes();
            attributeModel.setAttribute(attributeKey, attributeModel2);
        }
        return attributeModel;
    }

    public Object clone() {
        try {
            AttributeModel attributeModel = (AttributeModel)super.clone();
            attributeModel.attributes = (HashMap)((HashMap)this.attributes).clone();
            return attributeModel;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        return "AttributeModel [attributes=" + this.attributes + "]";
    }
}

