/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.fastutil;

import io.fair_acc.dataset.spi.fastutil.ArrayUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

public class FloatArrayList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected transient float[] a;
    protected int size;

    public void forEach(FloatConsumer floatConsumer) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            floatConsumer.accept(this.a[i2]);
        }
    }

    protected FloatArrayList(float[] fArray, boolean bl2) {
        this.a = fArray;
    }

    public FloatArrayList(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial capacity (" + n2 + ") is negative");
        }
        this.a = n2 == 0 ? FloatArrays.EMPTY_ARRAY : new float[n2];
    }

    public FloatArrayList() {
        this.a = FloatArrays.DEFAULT_EMPTY_ARRAY;
    }

    public float[] elements() {
        return this.a;
    }

    public static FloatArrayList wrap(float[] fArray, int n2) {
        if (n2 > fArray.length) {
            throw new IllegalArgumentException("The specified length (" + n2 + ") is greater than the array size (" + fArray.length + ")");
        }
        FloatArrayList floatArrayList = new FloatArrayList(fArray, false);
        floatArrayList.size = n2;
        return floatArrayList;
    }

    public static FloatArrayList wrap(float[] fArray) {
        return FloatArrayList.wrap(fArray, fArray.length);
    }

    public void ensureCapacity(int n2) {
        if (n2 <= this.a.length || this.a == FloatArrays.DEFAULT_EMPTY_ARRAY && n2 <= 10) {
            return;
        }
        this.a = FloatArrays.ensureCapacity(this.a, n2, this.size);
        assert (this.size <= this.a.length);
    }

    protected void ensureIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is negative");
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    private void grow(int n2) {
        if (n2 <= this.a.length) {
            return;
        }
        if (this.a != FloatArrays.DEFAULT_EMPTY_ARRAY) {
            n2 = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)n2);
        } else if (n2 < 10) {
            n2 = 10;
        }
        this.a = FloatArrays.forceCapacity(this.a, n2, this.size);
        assert (this.size <= this.a.length);
    }

    public void add(int n2, float f2) {
        this.ensureIndex(n2);
        this.grow(this.size + 1);
        if (n2 != this.size) {
            System.arraycopy(this.a, n2, this.a, n2 + 1, this.size - n2);
        }
        this.a[n2] = f2;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    public boolean add(float f2) {
        this.grow(this.size + 1);
        this.a[this.size++] = f2;
        assert (this.size <= this.a.length);
        return true;
    }

    public float getFloat(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[n2];
    }

    public int indexOf(float f2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (Float.floatToIntBits(f2) != Float.floatToIntBits(this.a[i2])) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(float f2) {
        int n2 = this.size;
        while (n2-- != 0) {
            if (Float.floatToIntBits(f2) != Float.floatToIntBits(this.a[n2])) continue;
            return n2;
        }
        return -1;
    }

    public float removeFloat(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        float f2 = this.a[n2];
        --this.size;
        if (n2 != this.size) {
            System.arraycopy(this.a, n2 + 1, this.a, n2, this.size - n2);
        }
        assert (this.size <= this.a.length);
        return f2;
    }

    public boolean rem(float f2) {
        int n2 = this.indexOf(f2);
        if (n2 == -1) {
            return false;
        }
        this.removeFloat(n2);
        assert (this.size <= this.a.length);
        return true;
    }

    public float set(int n2, float f2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + n2 + ") is greater than or equal to list size (" + this.size + ")");
        }
        float f3 = this.a[n2];
        this.a[n2] = f2;
        return f3;
    }

    public void clear() {
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    public int size() {
        return this.size;
    }

    public void size(int n2) {
        if (n2 > this.a.length) {
            this.a = FloatArrays.forceCapacity(this.a, n2, this.size);
        }
        if (n2 > this.size) {
            Arrays.fill(this.a, this.size, n2, 0.0f);
        }
        this.size = n2;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n2) {
        if (n2 >= this.a.length || this.size == this.a.length) {
            return;
        }
        float[] fArray = new float[Math.max(n2, this.size)];
        System.arraycopy(this.a, 0, fArray, 0, this.size);
        this.a = fArray;
        assert (this.size <= this.a.length);
    }

    public void getElements(int n2, float[] fArray, int n3, int n4) {
        FloatArrays.ensureOffsetLength(fArray, n3, n4);
        System.arraycopy(this.a, n2, fArray, n3, n4);
    }

    public void removeElements(int n2, int n3) {
        ArrayUtil.ensureFromTo(this.size, n2, n3);
        System.arraycopy(this.a, n3, this.a, n2, this.size - n3);
        this.size -= n3 - n2;
    }

    public void addElements(int n2, float[] fArray, int n3, int n4) {
        this.ensureIndex(n2);
        FloatArrays.ensureOffsetLength(fArray, n3, n4);
        this.grow(this.size + n4);
        System.arraycopy(this.a, n2, this.a, n2 + n4, this.size - n2);
        System.arraycopy(fArray, n3, this.a, n2, n4);
        this.size += n4;
    }

    public void addElements(int n2, float[] fArray) {
        this.addElements(n2, fArray, 0, fArray.length);
    }

    public void setElements(int n2, float[] fArray, int n3, int n4) {
        this.ensureIndex(n2);
        FloatArrays.ensureOffsetLength(fArray, n3, n4);
        if (n2 + n4 > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (n2 + n4) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(fArray, n3, this.a, n2, n4);
    }

    public void setElements(float[] fArray) {
        this.setElements(0, fArray);
    }

    public void setElements(int n2, float[] fArray) {
        this.setElements(n2, fArray, 0, fArray.length);
    }

    public float[] toArray(float[] fArray) {
        if (fArray == null || fArray.length < this.size) {
            fArray = new float[this.size];
        }
        System.arraycopy(this.a, 0, fArray, 0, this.size);
        return fArray;
    }

    public boolean removeAll(Collection<?> collection) {
        int n2;
        float[] fArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; ++n2) {
            if (collection.contains(Float.valueOf(fArray[n2]))) continue;
            fArray[n3++] = fArray[n2];
        }
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    public FloatArrayList clone() {
        FloatArrayList floatArrayList = new FloatArrayList(this.size);
        System.arraycopy(this.a, 0, floatArrayList.a, 0, this.size);
        floatArrayList.size = this.size;
        return floatArrayList;
    }

    public int compareTo(FloatArrayList floatArrayList) {
        int n2;
        int n3 = this.size();
        int n4 = floatArrayList.size();
        float[] fArray = this.a;
        float[] fArray2 = floatArrayList.a;
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            float f2 = fArray[n2];
            float f3 = fArray2[n2];
            int n5 = Float.compare(f2, f3);
            if (n5 == 0) continue;
            return n5;
        }
        return n2 < n4 ? -1 : (n2 < n3 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectOutputStream.writeFloat(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a = new float[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = objectInputStream.readFloat();
        }
    }

    @FunctionalInterface
    public static interface FloatConsumer {
        public void accept(float var1);
    }

    private static class FloatArrays {
        public static final float[] EMPTY_ARRAY = new float[0];
        public static final float[] DEFAULT_EMPTY_ARRAY = new float[0];

        private FloatArrays() {
        }

        public static void ensureOffsetLength(float[] fArray, int n2, int n3) {
            FloatArrays.ensureOffsetLength(fArray.length, n2, n3);
        }

        public static void ensureOffsetLength(int n2, int n3, int n4) {
            if (n3 < 0) {
                throw new ArrayIndexOutOfBoundsException("Offset (" + n3 + ") is negative");
            }
            if (n4 < 0) {
                throw new IllegalArgumentException("Length (" + n4 + ") is negative");
            }
            if (n3 + n4 > n2) {
                throw new ArrayIndexOutOfBoundsException("Last index (" + (n3 + n4) + ") is greater than array length (" + n2 + ")");
            }
        }

        public static float[] ensureCapacity(float[] fArray, int n2, int n3) {
            return n2 > fArray.length ? FloatArrays.forceCapacity(fArray, n2, n3) : fArray;
        }

        public static float[] forceCapacity(float[] fArray, int n2, int n3) {
            float[] fArray2 = new float[n2];
            System.arraycopy(fArray, 0, fArray2, 0, n3);
            return fArray2;
        }
    }
}

