/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet2D;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.fastutil.FloatArrayList;
import io.fair_acc.dataset.spi.utils.MathUtils;
import io.fair_acc.dataset.utils.AssertUtils;

public class FloatDataSet
extends AbstractDataSet<FloatDataSet>
implements DataSet2D,
EditableDataSet {
    private static final long serialVersionUID = 7625465583757088697L;
    private static final String X_COORDINATES = "X coordinates";
    private static final String Y_COORDINATES = "Y coordinates";
    protected FloatArrayList xValues;
    protected FloatArrayList yValues;

    public FloatDataSet(DataSet dataSet) {
        super(dataSet.getName(), dataSet.getDimension());
        this.set(dataSet);
    }

    public FloatDataSet(String string) {
        this(string, 0);
    }

    public FloatDataSet(String string, float[] fArray, float[] fArray2, int n2, boolean bl2) {
        this(string);
        this.set(fArray, fArray2, n2, bl2);
    }

    public FloatDataSet(String string, int n2) {
        super(string, 2);
        AssertUtils.gtEqThanZero("initalSize", n2);
        this.xValues = new FloatArrayList(n2);
        this.yValues = new FloatArrayList(n2);
    }

    public FloatDataSet add(float f2, float f3) {
        return this.add(this.getDataCount(), f2, f3, null);
    }

    public FloatDataSet add(float f2, float f3, String string) {
        this.lock().writeLockGuard(() -> {
            this.xValues.add(f2);
            this.yValues.add(f3);
            if (string != null && !string.isEmpty()) {
                this.addDataLabel(this.xValues.size() - 1, string);
            }
            this.getAxisDescription(0).add(f2);
            this.getAxisDescription(1).add(f3);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (FloatDataSet)this.getThis();
    }

    public FloatDataSet add(float[] fArray, float[] fArray2) {
        AssertUtils.notNull(X_COORDINATES, fArray);
        AssertUtils.notNull(Y_COORDINATES, fArray2);
        AssertUtils.equalFloatArrays(fArray, fArray2);
        this.lock().writeLockGuard(() -> {
            this.xValues.addElements(this.xValues.size(), fArray);
            this.yValues.addElements(this.yValues.size(), fArray2);
            for (float f2 : fArray) {
                this.getAxisDescription(0).add(f2);
            }
            for (float f2 : fArray2) {
                this.getAxisDescription(1).add(f2);
            }
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (FloatDataSet)this.getThis();
    }

    @Override
    public FloatDataSet add(int n2, double ... dArray) {
        return this.add(n2, (float)dArray[0], (float)dArray[1], null);
    }

    public FloatDataSet add(int n2, double d2, double d3) {
        return this.add(n2, (float)d2, (float)d3, null);
    }

    public FloatDataSet add(int n2, float f2, float f3, String string) {
        this.lock().writeLockGuard(() -> {
            int n3 = Math.max(0, Math.min(n2, this.getDataCount() + 1));
            this.xValues.add(n3, f2);
            this.yValues.add(n3, f3);
            this.getDataLabelMap().addValueAndShiftKeys(n3, this.xValues.size(), string);
            this.getDataStyleMap().shiftKeys(n3, this.xValues.size());
            this.getAxisDescription(0).add(f2);
            this.getAxisDescription(1).add(f3);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (FloatDataSet)this.getThis();
    }

    public FloatDataSet add(int n2, float[] fArray, float[] fArray2) {
        AssertUtils.notNull(X_COORDINATES, fArray);
        AssertUtils.notNull(Y_COORDINATES, fArray2);
        int n3 = Math.min(fArray.length, fArray2.length);
        AssertUtils.equalFloatArrays(fArray, fArray2, n3);
        this.lock().writeLockGuard(() -> {
            int n4 = Math.max(0, Math.min(n2, this.getDataCount() + 1));
            this.xValues.addElements(n4, fArray, 0, n3);
            this.yValues.addElements(n4, fArray2, 0, n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                this.getAxisDescription(0).add(fArray[i2]);
                this.getAxisDescription(1).add(fArray2[i2]);
            }
            this.getDataLabelMap().shiftKeys(n4, this.xValues.size());
            this.getDataStyleMap().shiftKeys(n4, this.xValues.size());
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (FloatDataSet)this.getThis();
    }

    public FloatDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.xValues.clear();
            this.yValues.clear();
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (FloatDataSet)this.getThis();
    }

    @Override
    public double get(int n2, int n3) {
        return n2 == 0 ? (double)this.xValues.elements()[n3] : (double)this.yValues.elements()[n3];
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    @Override
    public int getDataCount() {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    public FloatDataSet increaseCapacity(int n2) {
        this.lock().writeLockGuard(() -> {
            int n3 = this.getDataCount();
            this.resize(this.getCapacity() + n2);
            this.resize(n3);
        });
        return (FloatDataSet)this.getThis();
    }

    @Override
    public EditableDataSet remove(int n2) {
        return this.remove(n2, n2 + 1);
    }

    public FloatDataSet remove(int n2, int n3) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(n2, this.getDataCount(), "fromIndex");
            AssertUtils.indexOrder(n2, "fromIndex", n3, "toIndex");
            int n4 = Math.min(n3, this.getDataCount());
            this.xValues.removeElements(n2, n4);
            this.yValues.removeElements(n2, n4);
            this.getDataLabelMap().remove(n2, n4);
            this.getDataLabelMap().remove(n2, n4);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (FloatDataSet)this.getThis();
    }

    public FloatDataSet resize(int n2) {
        this.lock().writeLockGuard(() -> {
            this.xValues.size(n2);
            this.yValues.size(n2);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (FloatDataSet)this.getThis();
    }

    @Override
    public FloatDataSet set(DataSet dataSet, boolean bl2) {
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            if (dataSet instanceof FloatDataSet) {
                FloatDataSet floatDataSet = (FloatDataSet)dataSet;
                this.set(floatDataSet.getFloatValues(0), floatDataSet.getFloatValues(1), dataSet.getDataCount(), bl2);
            } else {
                this.set(MathUtils.toFloats(dataSet.getValues(0)), MathUtils.toFloats(dataSet.getValues(1)), dataSet.getDataCount(), false);
            }
            this.copyMetaData(dataSet);
            this.copyDataLabelsAndStyles(dataSet, bl2);
            this.copyAxisDescription(dataSet);
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return (FloatDataSet)this.getThis();
    }

    public FloatDataSet set(float[] fArray, float[] fArray2) {
        return this.set(fArray, fArray2, true);
    }

    public FloatDataSet set(float[] fArray, float[] fArray2, boolean bl2) {
        return this.set(fArray, fArray2, -1, bl2);
    }

    public FloatDataSet set(float[] fArray, float[] fArray2, int n2, boolean bl2) {
        AssertUtils.notNull(X_COORDINATES, fArray);
        AssertUtils.notNull(Y_COORDINATES, fArray2);
        AssertUtils.equalFloatArrays(fArray, fArray2);
        if (n2 >= 0) {
            AssertUtils.indexInBounds(n2, fArray.length + 1, "xValues bounds");
            AssertUtils.indexInBounds(n2, fArray2.length + 1, "yValues bounds");
        }
        int n3 = n2 >= 0 ? Math.min(n2, fArray.length) : fArray.length;
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (bl2) {
                if (this.xValues == null) {
                    this.xValues = new FloatArrayList();
                }
                if (this.yValues == null) {
                    this.yValues = new FloatArrayList();
                }
                this.resize(0);
                this.xValues.addElements(0, fArray, 0, n3);
                this.yValues.addElements(0, fArray2, 0, n3);
            } else {
                this.xValues = FloatArrayList.wrap(fArray, n3);
                this.yValues = FloatArrayList.wrap(fArray2, n3);
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (FloatDataSet)this.getThis();
    }

    @Override
    public FloatDataSet set(int n2, double ... dArray) {
        return this.set(n2, dArray[0], dArray[1]);
    }

    public FloatDataSet set(int n2, double d2, double d3) {
        this.lock().writeLockGuard(() -> {
            int n3 = Math.max(n2 + 1, this.getDataCount());
            this.xValues.size(n3);
            this.yValues.size(n3);
            this.xValues.elements()[n2] = (float)d2;
            this.yValues.elements()[n2] = (float)d3;
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (FloatDataSet)this.getThis();
    }

    public FloatDataSet set(int n2, double[] dArray, double[] dArray2) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(n2 + dArray.length, this.xValues.size()));
            System.arraycopy(MathUtils.toFloats(dArray), 0, this.xValues.elements(), n2, dArray.length);
            System.arraycopy(MathUtils.toFloats(dArray2), 0, this.yValues.elements(), n2, dArray2.length);
            this.getDataLabelMap().remove(n2, n2 + dArray.length);
            this.getDataStyleMap().remove(n2, n2 + dArray.length);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (FloatDataSet)this.getThis();
    }

    public FloatDataSet trim() {
        this.lock().writeLockGuard(() -> {
            this.xValues.trim(0);
            this.yValues.trim(0);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (FloatDataSet)this.getThis();
    }

    public float[] getFloatValues(int n2) {
        return n2 == 0 ? this.xValues.elements() : this.yValues.elements();
    }

    @Override
    public double[] getValues(int n2) {
        return n2 == 0 ? MathUtils.toDoubles(this.xValues.elements()) : MathUtils.toDoubles(this.yValues.elements());
    }

    public float[] getXFloatValues() {
        return this.getFloatValues(0);
    }

    public float[] getYFloatValues() {
        return this.getFloatValues(1);
    }
}

