/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet3D;
import io.fair_acc.dataset.GridDataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractGridDataSet;
import io.fair_acc.dataset.spi.DefaultAxisDescription;
import io.fair_acc.dataset.spi.utils.MultiArrayDouble;
import java.util.Arrays;
import java.util.stream.IntStream;

public class DoubleGridDataSet
extends AbstractGridDataSet<DoubleGridDataSet>
implements DataSet3D {
    private static final long serialVersionUID = -493232313124620828L;
    protected transient double[][] grid;
    protected transient MultiArrayDouble[] values;
    protected transient int[] shape;
    protected transient int dataCount;

    public DoubleGridDataSet(GridDataSet gridDataSet) {
        super(gridDataSet.getName(), gridDataSet.getDimension());
        this.set(gridDataSet);
    }

    public DoubleGridDataSet(String string, int n2) {
        this(string, n2, new int[n2 - 1]);
    }

    public DoubleGridDataSet(String string, int n2, int[] nArray) {
        super(string, n2);
        int n3;
        if (nArray.length > n2) {
            throw new IllegalArgumentException("nDims must be greater or equal to grid shape");
        }
        this.shape = (int[])nArray.clone();
        int[] nArray2 = DoubleGridDataSet.reverseOrder(nArray);
        this.grid = new double[nArray.length][];
        this.values = new MultiArrayDouble[n2 - nArray.length];
        this.dataCount = 1;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            this.dataCount *= nArray[n3];
            this.grid[n3] = IntStream.range(0, nArray[n3]).asDoubleStream().toArray();
        }
        for (n3 = nArray.length; n3 < n2; ++n3) {
            this.values[n3 - nArray.length] = MultiArrayDouble.wrap(new double[this.dataCount], 0, nArray2);
        }
    }

    public DoubleGridDataSet(String string, int[] nArray, boolean bl2, double[] ... dArray) {
        super(string, nArray.length + dArray.length);
        int n2;
        int n3 = nArray.length + dArray.length;
        this.shape = (int[])nArray.clone();
        int[] nArray2 = DoubleGridDataSet.reverseOrder(nArray);
        this.grid = new double[nArray.length][];
        this.values = new MultiArrayDouble[dArray.length];
        this.dataCount = 1;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.dataCount *= nArray[n2];
            this.grid[n2] = IntStream.range(0, nArray[n2]).asDoubleStream().toArray();
        }
        for (n2 = nArray.length; n2 < n3; ++n2) {
            if (dArray[n2 - nArray.length].length != this.dataCount) {
                throw new IllegalArgumentException("Dimension missmatch between grid and values");
            }
            this.values[n2 - nArray.length] = MultiArrayDouble.wrap(bl2 ? (double[])dArray[n2 - nArray.length].clone() : dArray[n2 - nArray.length], 0, nArray2);
        }
    }

    public DoubleGridDataSet(String string, boolean bl2, double[][] dArray, double[] ... dArray2) {
        super(string, dArray.length + dArray2.length);
        this.set(bl2, dArray, dArray2);
    }

    @Override
    public double get(int n2, int n3) {
        if (n2 < this.shape.length) {
            return this.grid[n2][this.values[0].getIndices(n3)[this.shape.length - 1 - n2]];
        }
        return this.values[n2 - this.shape.length].getStrided(n3);
    }

    @Override
    public int getDataCount() {
        return this.dataCount;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public int getShape(int n2) {
        return this.shape[n2];
    }

    @Override
    public double getGrid(int n2, int n3) {
        if (n2 >= this.shape.length) {
            throw new IndexOutOfBoundsException("Grid index out of bounds");
        }
        return this.grid[n2][n3];
    }

    @Override
    public double[] getGridValues(int n2) {
        if (n2 >= this.shape.length) {
            throw new IndexOutOfBoundsException("Grid index out of bounds");
        }
        return this.grid[n2];
    }

    @Override
    public double get(int n2, int ... nArray) {
        if (n2 < this.shape.length) {
            return this.grid[n2][nArray[n2]];
        }
        return this.values[n2 - this.shape.length].get(DoubleGridDataSet.reverseOrder(nArray));
    }

    @Override
    public double[] getValues(int n2) {
        if (n2 >= this.shape.length) {
            return (double[])this.values[n2 - this.shape.length].elements();
        }
        return super.getValues(n2);
    }

    public void set(boolean bl2, double[][] dArray, double[] ... dArray2) {
        this.lock().writeLockGuard(() -> {
            int n2;
            int n3 = this.getDimension();
            if (n3 != dArray.length + dArray2.length) {
                throw new IllegalArgumentException("grid + value dimensions must match dataset dimensions");
            }
            this.shape = Arrays.stream(dArray).mapToInt(dArray -> ((double[])dArray).length).toArray();
            int[] nArray = DoubleGridDataSet.reverseOrder(this.shape);
            this.grid = bl2 ? (Object)new double[this.shape.length][] : dArray;
            this.dataCount = 1;
            for (n2 = 0; n2 < this.shape.length; ++n2) {
                this.dataCount *= this.shape[n2];
                if (!bl2) continue;
                this.grid[n2] = (double[])dArray[n2].clone();
            }
            this.values = new MultiArrayDouble[dArray2.length];
            for (n2 = this.shape.length; n2 < n3; ++n2) {
                if (dArray2[n2 - this.shape.length].length != this.dataCount) {
                    throw new IllegalArgumentException("Dimension mismatch between grid and values");
                }
                this.values[n2 - this.shape.length] = MultiArrayDouble.wrap(bl2 ? (double[])dArray2[n2 - this.shape.length].clone() : dArray2[n2 - this.shape.length], 0, nArray);
            }
        });
        this.fireInvalidated(ChartBits.DataSetData);
    }

    @Override
    public GridDataSet set(DataSet dataSet, boolean bl2) {
        if (!(dataSet instanceof GridDataSet)) {
            throw new UnsupportedOperationException("other data set has to be of type GridDataSEt");
        }
        GridDataSet gridDataSet = (GridDataSet)dataSet;
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            String string;
            int n2;
            int n3 = this.getDimension();
            if (n3 != dataSet.getDimension()) {
                throw new IllegalArgumentException("datasets must have same number of dimensions to be assigned");
            }
            this.shape = (int[])gridDataSet.getShape().clone();
            int[] nArray = DoubleGridDataSet.reverseOrder(this.shape);
            this.grid = new double[this.shape.length][];
            this.values = new MultiArrayDouble[n3 - this.shape.length];
            this.dataCount = 1;
            for (n2 = 0; n2 < this.shape.length; ++n2) {
                this.dataCount *= this.shape[n2];
                this.grid[n2] = (double[])gridDataSet.getGridValues(n2).clone();
            }
            for (n2 = this.shape.length; n2 < n3; ++n2) {
                this.values[n2 - this.shape.length] = MultiArrayDouble.wrap((double[])dataSet.getValues(n2).clone(), 0, nArray);
            }
            this.getDataLabelMap().clear();
            for (n2 = 0; n2 < gridDataSet.getDataCount(); ++n2) {
                string = gridDataSet.getDataLabel(n2);
                if (string == null) continue;
                this.addDataLabel(n2, string);
            }
            this.getDataStyleMap().clear();
            for (n2 = 0; n2 < gridDataSet.getDataCount(); ++n2) {
                string = gridDataSet.getStyle(n2);
                if (string == null || string.isEmpty()) continue;
                this.addDataStyle(n2, string);
            }
            this.setStyle(gridDataSet.getStyle());
            for (n2 = 0; n2 < this.getDimension(); ++n2) {
                this.getAxisDescription(n2).set(new DefaultAxisDescription(gridDataSet.getAxisDescription(n2)));
            }
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return (GridDataSet)this.getThis();
    }

    public GridDataSet set(int n2, int[] nArray, double d2) {
        this.lock().writeLockGuard(() -> this.values[n2 - this.shape.length].set(nArray, d2));
        this.fireInvalidated(ChartBits.DataSetData);
        return (GridDataSet)this.getThis();
    }

    public void clearData() {
        this.set(false, new double[this.shape.length][0], new double[1][0]);
    }

    private static int[] reverseOrder(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = nArray[nArray.length - 1 - i2];
        }
        return nArray2;
    }
}

