/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet2D;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractErrorDataSet;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import io.fair_acc.dataset.utils.AssertUtils;

public class DoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSet2D,
DataSetError,
EditableDataSet {
    private static final String Y_COORDINATES = "Y coordinates";
    private static final String X_COORDINATES = "X coordinates";
    private static final long serialVersionUID = 8931518518245752926L;
    protected DoubleArrayList xValues;
    protected DoubleArrayList yValues;
    protected DoubleArrayList yErrorsPos;
    protected DoubleArrayList yErrorsNeg;

    public DoubleErrorDataSet(DataSet dataSet) {
        super(dataSet.getName(), dataSet.getDimension(), DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        this.set(dataSet);
    }

    public DoubleErrorDataSet(String string) {
        this(string, 0);
    }

    public DoubleErrorDataSet(String string, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2, boolean bl2) {
        super(string, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        this.set(dArray, dArray2, dArray3, dArray4, n2, bl2);
    }

    public DoubleErrorDataSet(String string, int n2) {
        super(string, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        AssertUtils.gtEqThanZero("initalSize", n2);
        this.xValues = new DoubleArrayList(n2);
        this.yValues = new DoubleArrayList(n2);
        this.yErrorsPos = new DoubleArrayList(n2);
        this.yErrorsNeg = new DoubleArrayList(n2);
    }

    public DoubleErrorDataSet add(double d2, double d3) {
        return this.add(d2, d3, 0.0, 0.0, null);
    }

    public DoubleErrorDataSet add(double d2, double d3, double d4, double d5) {
        return this.add(d2, d3, d4, d5, null);
    }

    public DoubleErrorDataSet add(double d2, double d3, double d4, double d5, String string) {
        this.lock().writeLockGuard(() -> {
            this.xValues.add(d2);
            this.yValues.add(d3);
            this.yErrorsNeg.add(d4);
            this.yErrorsPos.add(d5);
            if (string != null && !string.isEmpty()) {
                this.addDataLabel(this.xValues.size() - 1, string);
            }
            this.getAxisDescription(0).add(d2);
            this.getAxisDescription(1).add(d3 - d4);
            this.getAxisDescription(1).add(d3 + d5);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet add(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        AssertUtils.notNull(X_COORDINATES, dArray);
        AssertUtils.notNull(Y_COORDINATES, dArray2);
        AssertUtils.notNull("X error coordinates", dArray3);
        AssertUtils.notNull("Y error coordinates", dArray4);
        AssertUtils.equalDoubleArrays(dArray, dArray2);
        this.lock().writeLockGuard(() -> {
            int n2 = this.xValues.size();
            int n3 = Math.min(Math.min(dArray.length, dArray2.length), Math.min(dArray3.length, dArray4.length));
            this.resize(n2 + n3);
            this.xValues.setElements(n2, dArray, 0, n3);
            this.yValues.setElements(n2, dArray2, 0, n3);
            this.yErrorsNeg.setElements(n2, dArray3, 0, n3);
            this.yErrorsPos.setElements(n2, dArray4, 0, n3);
            this.getAxisDescription(0).add(dArray);
            this.getAxisDescription(1).add(dArray2);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (DoubleErrorDataSet)this.getThis();
    }

    @Override
    public DoubleErrorDataSet add(int n2, double ... dArray) {
        if (dArray.length >= 4) {
            return this.add(n2, dArray[0], dArray[1], dArray[2], dArray[3]);
        }
        return this.add(n2, dArray[0], dArray[1]);
    }

    public DoubleErrorDataSet add(int n2, double d2, double d3) {
        return this.add(n2, d2, d3, 0.0, 0.0, null);
    }

    public DoubleErrorDataSet add(int n2, double d2, double d3, double d4, double d5) {
        return this.add(n2, d2, d3, d4, d5, null);
    }

    public DoubleErrorDataSet add(int n2, double d2, double d3, double d4, double d5, String string) {
        this.lock().writeLockGuard(() -> {
            int n3 = Math.max(0, Math.min(n2, this.getDataCount() + 1));
            this.xValues.add(n3, d2);
            this.yValues.add(n3, d3);
            this.yErrorsNeg.add(n3, d4);
            this.yErrorsPos.add(n3, d5);
            this.getDataLabelMap().addValueAndShiftKeys(n3, this.xValues.size(), string);
            this.getDataStyleMap().shiftKeys(n3, this.xValues.size());
            this.getAxisDescription(0).add(d2);
            this.getAxisDescription(1).add(d3 - d4);
            this.getAxisDescription(1).add(d3 + d5);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet add(int n2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        AssertUtils.notNull(X_COORDINATES, dArray);
        AssertUtils.notNull(Y_COORDINATES, dArray2);
        AssertUtils.notNull(X_COORDINATES, dArray3);
        AssertUtils.notNull(Y_COORDINATES, dArray4);
        int n3 = Math.min(dArray.length, dArray2.length);
        AssertUtils.equalDoubleArrays(dArray, dArray2, n3);
        this.lock().writeLockGuard(() -> {
            int n4 = Math.max(0, Math.min(n2, this.getDataCount()));
            this.xValues.addElements(n4, dArray, 0, n3);
            this.yValues.addElements(n4, dArray2, 0, n3);
            this.yErrorsNeg.addElements(n4, dArray3, 0, n3);
            this.yErrorsPos.addElements(n4, dArray4, 0, n3);
            this.getAxisDescription(0).add(dArray);
            this.getAxisDescription(1).add(dArray2);
            this.getDataLabelMap().shiftKeys(n4, this.xValues.size());
            this.getDataStyleMap().shiftKeys(n4, this.xValues.size());
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.xValues.clear();
            this.yValues.clear();
            this.yErrorsPos.clear();
            this.yErrorsNeg.clear();
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (DoubleErrorDataSet)this.getThis();
    }

    @Override
    public final double get(int n2, int n3) {
        return n2 == 0 ? this.xValues.elements()[n3] : this.yValues.elements()[n3];
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    @Override
    public int getDataCount() {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    @Override
    public double getErrorNegative(int n2, int n3) {
        return n2 == 0 ? 0.0 : this.yErrorsNeg.elements()[n3];
    }

    @Override
    public double getErrorPositive(int n2, int n3) {
        return n2 == 0 ? 0.0 : this.yErrorsPos.elements()[n3];
    }

    @Override
    public double[] getErrorsNegative(int n2) {
        return n2 == 0 ? super.getErrorsNegative(n2) : this.yErrorsNeg.elements();
    }

    @Override
    public double[] getErrorsPositive(int n2) {
        return n2 == 0 ? super.getErrorsPositive(n2) : this.yErrorsPos.elements();
    }

    @Override
    public final double[] getValues(int n2) {
        return n2 == 0 ? this.xValues.elements() : this.yValues.elements();
    }

    public DoubleErrorDataSet increaseCapacity(int n2) {
        this.lock().writeLockGuard(() -> {
            int n3 = this.getDataCount();
            this.resize(this.getCapacity() + n2);
            this.resize(n3);
        });
        return (DoubleErrorDataSet)this.getThis();
    }

    @Override
    public DoubleErrorDataSet remove(int n2) {
        return this.remove(n2, n2 + 1);
    }

    public DoubleErrorDataSet remove(int n2, int n3) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(n2, this.getDataCount(), "fromIndex");
            AssertUtils.indexOrder(n2, "fromIndex", n3, "toIndex");
            int n4 = Math.min(n3, this.getDataCount());
            this.xValues.removeElements(n2, n4);
            this.yValues.removeElements(n2, n4);
            this.yErrorsNeg.removeElements(n2, n4);
            this.yErrorsPos.removeElements(n2, n4);
            this.getDataLabelMap().remove(n2, n4);
            this.getDataLabelMap().remove(n2, n4);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet resize(int n2) {
        this.lock().writeLockGuard(() -> {
            this.xValues.size(n2);
            this.yValues.size(n2);
            this.yErrorsPos.size(n2);
            this.yErrorsNeg.size(n2);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleErrorDataSet)this.getThis();
    }

    @Override
    public DoubleErrorDataSet set(DataSet dataSet, boolean bl2) {
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            if (dataSet instanceof DataSetError) {
                this.set(dataSet.getValues(0), dataSet.getValues(1), ((DataSetError)dataSet).getErrorsNegative(1), ((DataSetError)dataSet).getErrorsPositive(1), dataSet.getDataCount(), bl2);
            } else {
                int n2 = dataSet.getDataCount();
                this.set(dataSet.getValues(0), dataSet.getValues(1), new double[n2], new double[n2], dataSet.getDataCount(), bl2);
            }
            this.copyMetaData(dataSet);
            this.copyDataLabelsAndStyles(dataSet, bl2);
            this.copyAxisDescription(dataSet);
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet set(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        return this.set(dArray, dArray2, dArray3, dArray4, true);
    }

    public DoubleErrorDataSet set(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl2) {
        return this.set(dArray, dArray2, dArray3, dArray4, -1, bl2);
    }

    public DoubleErrorDataSet set(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n2, boolean bl2) {
        AssertUtils.notNull(X_COORDINATES, dArray);
        AssertUtils.notNull(Y_COORDINATES, dArray2);
        AssertUtils.notNull("Y error neg", dArray3);
        AssertUtils.notNull("Y error pos", dArray4);
        int n3 = Math.min(dArray4.length, dArray3.length);
        int n4 = Math.min(dArray.length, Math.min(dArray2.length, n3));
        AssertUtils.equalDoubleArrays(dArray, dArray2, n4);
        AssertUtils.equalDoubleArrays(dArray, dArray3, n4);
        AssertUtils.equalDoubleArrays(dArray, dArray4, n4);
        if (n2 >= 0) {
            AssertUtils.indexInBounds(n2, dArray.length + 1, "xValues bounds");
            AssertUtils.indexInBounds(n2, dArray2.length + 1, "yValues bounds");
            AssertUtils.indexInBounds(n2, dArray3.length + 1, "yErrorsNeg bounds");
            AssertUtils.indexInBounds(n2, dArray4.length + 1, "yErrorsPos bounds");
        }
        int n5 = n2 >= 0 ? Math.min(n2, dArray.length) : dArray.length;
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (bl2) {
                if (this.xValues == null) {
                    this.xValues = new DoubleArrayList();
                }
                if (this.yValues == null) {
                    this.yValues = new DoubleArrayList();
                }
                if (this.yErrorsPos == null) {
                    this.yErrorsPos = new DoubleArrayList();
                }
                if (this.yErrorsNeg == null) {
                    this.yErrorsNeg = new DoubleArrayList();
                }
                this.resize(0);
                this.xValues.addElements(0, dArray, 0, n5);
                this.yValues.addElements(0, dArray2, 0, n5);
                this.yErrorsNeg.addElements(0, dArray3, 0, n5);
                this.yErrorsPos.addElements(0, dArray4, 0, n5);
            } else {
                this.xValues = DoubleArrayList.wrap(dArray, n5);
                this.yValues = DoubleArrayList.wrap(dArray2, n5);
                this.yErrorsNeg = DoubleArrayList.wrap(dArray3, n5);
                this.yErrorsPos = DoubleArrayList.wrap(dArray4, n5);
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleErrorDataSet)this.getThis();
    }

    @Override
    public DoubleErrorDataSet set(int n2, double ... dArray) {
        if (dArray.length >= 4) {
            return this.set(n2, dArray[0], dArray[1], dArray[2], dArray[3]);
        }
        return this.set(n2, dArray[0], dArray[1]);
    }

    public DoubleErrorDataSet set(int n2, double d2, double d3) {
        return this.set(n2, d2, d3, 0.0, 0.0);
    }

    public DoubleErrorDataSet set(int n2, double d2, double d3, double d4, double d5) {
        this.lock().writeLockGuard(() -> {
            int n3 = Math.max(n2 + 1, this.getDataCount());
            this.xValues.size(n3);
            this.yValues.size(n3);
            this.xValues.elements()[n2] = d2;
            this.yValues.elements()[n2] = d3;
            this.yErrorsNeg.size(n3);
            this.yErrorsPos.size(n3);
            this.yErrorsNeg.elements()[n2] = d4;
            this.yErrorsPos.elements()[n2] = d5;
            this.getDataLabelMap().remove(n2);
            this.getDataStyleMap().remove(n2);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet set(int n2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(n2 + dArray.length, this.xValues.size()));
            System.arraycopy(dArray, 0, this.xValues.elements(), n2, dArray.length);
            System.arraycopy(dArray2, 0, this.yValues.elements(), n2, dArray2.length);
            System.arraycopy(dArray3, 0, this.yErrorsNeg.elements(), n2, dArray3.length);
            System.arraycopy(dArray4, 0, this.yErrorsPos.elements(), n2, dArray4.length);
            this.getDataLabelMap().remove(n2, n2 + dArray.length);
            this.getDataStyleMap().remove(n2, n2 + dArray.length);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleErrorDataSet)this.getThis();
    }

    public DoubleErrorDataSet trim() {
        this.lock().writeLockGuard(() -> {
            this.xValues.trim(0);
            this.yValues.trim(0);
            this.yErrorsPos.trim(0);
            this.yErrorsNeg.trim(0);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (DoubleErrorDataSet)this.getThis();
    }
}

