/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSet2D;
import io.fair_acc.dataset.EditableDataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import io.fair_acc.dataset.utils.AssertUtils;

public class DoubleDataSet
extends AbstractDataSet<DoubleDataSet>
implements EditableDataSet,
DataSet2D {
    private static final long serialVersionUID = -493232313124620828L;
    private static final String X_COORDINATES = "X coordinates";
    private static final String Y_COORDINATES = "Y coordinates";
    protected DoubleArrayList xValues;
    protected DoubleArrayList yValues;

    public DoubleDataSet(DataSet dataSet) {
        super(dataSet.getName(), dataSet.getDimension());
        this.set(dataSet);
    }

    public DoubleDataSet(String string) {
        this(string, 0);
    }

    public DoubleDataSet(String string, double[] dArray, double[] dArray2, int n2, boolean bl2) {
        super(string, 2);
        this.set(dArray, dArray2, n2, bl2);
    }

    public DoubleDataSet(String string, int n2) {
        super(string, 2);
        AssertUtils.gtEqThanZero("initalSize", n2);
        this.xValues = new DoubleArrayList(n2);
        this.yValues = new DoubleArrayList(n2);
    }

    public DoubleDataSet add(double d2, double d3) {
        return this.add(this.getDataCount(), d2, d3, null);
    }

    public DoubleDataSet add(double d2, double d3, String string) {
        this.lock().writeLockGuard(() -> {
            this.xValues.add(d2);
            this.yValues.add(d3);
            if (string != null && !string.isEmpty()) {
                this.addDataLabel(this.xValues.size() - 1, string);
            }
            this.getAxisDescription(0).add(d2);
            this.getAxisDescription(1).add(d3);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (DoubleDataSet)this.getThis();
    }

    public DoubleDataSet add(double[] dArray, double[] dArray2) {
        AssertUtils.notNull(X_COORDINATES, dArray);
        AssertUtils.notNull(Y_COORDINATES, dArray2);
        AssertUtils.equalDoubleArrays(dArray, dArray2);
        this.lock().writeLockGuard(() -> {
            int n2 = this.xValues.size();
            int n3 = Math.min(dArray.length, dArray2.length);
            this.resize(n2 + n3);
            this.xValues.setElements(n2, dArray);
            this.yValues.setElements(n2, dArray2);
            this.getAxisDescription(0).add(dArray);
            this.getAxisDescription(1).add(dArray2);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (DoubleDataSet)this.getThis();
    }

    @Override
    public DoubleDataSet add(int n2, double ... dArray) {
        return this.add(n2, dArray[0], dArray[1], null);
    }

    public DoubleDataSet add(int n2, double d2, double d3) {
        return this.add(n2, d2, d3, null);
    }

    public DoubleDataSet add(int n2, double d2, double d3, String string) {
        this.lock().writeLockGuard(() -> {
            int n3 = Math.max(0, Math.min(n2, this.getDataCount() + 1));
            this.xValues.add(n3, d2);
            this.yValues.add(n3, d3);
            this.getDataLabelMap().addValueAndShiftKeys(n3, this.xValues.size(), string);
            this.getDataStyleMap().shiftKeys(n3, this.xValues.size());
            this.getAxisDescription(0).add(d2);
            this.getAxisDescription(1).add(d3);
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (DoubleDataSet)this.getThis();
    }

    public DoubleDataSet add(int n2, double[] dArray, double[] dArray2) {
        AssertUtils.notNull(X_COORDINATES, dArray);
        AssertUtils.notNull(Y_COORDINATES, dArray2);
        int n3 = Math.min(dArray.length, dArray2.length);
        AssertUtils.equalDoubleArrays(dArray, dArray2, n3);
        this.lock().writeLockGuard(() -> {
            int n4 = Math.max(0, Math.min(n2, this.getDataCount() + 1));
            this.xValues.addElements(n4, dArray, 0, n3);
            this.yValues.addElements(n4, dArray2, 0, n3);
            this.getAxisDescription(0).add(dArray, n3);
            this.getAxisDescription(1).add(dArray2, n3);
            this.getDataLabelMap().shiftKeys(n4, this.xValues.size());
            this.getDataStyleMap().shiftKeys(n4, this.xValues.size());
        });
        this.fireInvalidated(ChartBits.DataSetDataAdded);
        return (DoubleDataSet)this.getThis();
    }

    public DoubleDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.xValues.clear();
            this.yValues.clear();
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (DoubleDataSet)this.getThis();
    }

    @Override
    public final double get(int n2, int n3) {
        return n2 == 0 ? this.xValues.elements()[n3] : this.yValues.elements()[n3];
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    @Override
    public int getDataCount() {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    @Override
    public final double[] getValues(int n2) {
        return n2 == 0 ? this.xValues.elements() : this.yValues.elements();
    }

    public DoubleDataSet increaseCapacity(int n2) {
        this.lock().writeLockGuard(() -> {
            int n3 = this.getDataCount();
            this.resize(this.getCapacity() + n2);
            this.resize(n3);
        });
        return (DoubleDataSet)this.getThis();
    }

    @Override
    public EditableDataSet remove(int n2) {
        return this.remove(n2, n2 + 1);
    }

    public DoubleDataSet remove(int n2, int n3) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(n2, this.getDataCount(), "fromIndex");
            AssertUtils.indexOrder(n2, "fromIndex", n3, "toIndex");
            int n4 = Math.min(n3, this.getDataCount());
            this.xValues.removeElements(n2, n4);
            this.yValues.removeElements(n2, n4);
            this.getDataLabelMap().remove(n2, n4);
            this.getDataStyleMap().remove(n2, n4);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetDataRemoved);
        return (DoubleDataSet)this.getThis();
    }

    public DoubleDataSet resize(int n2) {
        this.lock().writeLockGuard(() -> {
            this.xValues.size(n2);
            this.yValues.size(n2);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleDataSet)this.getThis();
    }

    @Override
    public DoubleDataSet set(DataSet dataSet, boolean bl2) {
        this.lock().writeLockGuard(() -> dataSet.lock().writeLockGuard(() -> {
            this.set(dataSet.getValues(0), dataSet.getValues(1), dataSet.getDataCount(), bl2);
            this.copyMetaData(dataSet);
            this.copyDataLabelsAndStyles(dataSet, bl2);
            this.copyAxisDescription(dataSet);
        }));
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleDataSet)this.getThis();
    }

    public DoubleDataSet set(double[] dArray, double[] dArray2) {
        return this.set(dArray, dArray2, true);
    }

    public DoubleDataSet set(double[] dArray, double[] dArray2, boolean bl2) {
        return this.set(dArray, dArray2, -1, bl2);
    }

    public DoubleDataSet set(double[] dArray, double[] dArray2, int n2, boolean bl2) {
        AssertUtils.notNull(X_COORDINATES, dArray);
        AssertUtils.notNull(Y_COORDINATES, dArray2);
        int n3 = Math.min(dArray.length, dArray2.length);
        AssertUtils.equalDoubleArrays(dArray, dArray2, n3);
        if (n2 >= 0) {
            AssertUtils.indexInBounds(n2, dArray.length + 1, "xValues bounds");
            AssertUtils.indexInBounds(n2, dArray2.length + 1, "yValues bounds");
        }
        int n4 = n2 >= 0 ? Math.min(n2, dArray.length) : dArray.length;
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (bl2) {
                if (this.xValues == null) {
                    this.xValues = new DoubleArrayList();
                }
                if (this.yValues == null) {
                    this.yValues = new DoubleArrayList();
                }
                this.resize(0);
                this.xValues.addElements(0, dArray, 0, n4);
                this.yValues.addElements(0, dArray2, 0, n4);
            } else {
                this.xValues = DoubleArrayList.wrap(dArray, n4);
                this.yValues = DoubleArrayList.wrap(dArray2, n4);
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleDataSet)this.getThis();
    }

    @Override
    public DoubleDataSet set(int n2, double ... dArray) {
        return this.set(n2, dArray[0], dArray[1]);
    }

    public DoubleDataSet set(int n2, double d2, double d3) {
        this.lock().writeLockGuard(() -> {
            int n3 = Math.max(n2 + 1, this.getDataCount());
            this.xValues.size(n3);
            this.yValues.size(n3);
            this.xValues.elements()[n2] = d2;
            this.yValues.elements()[n2] = d3;
            this.getDataLabelMap().remove(n2);
            this.getDataStyleMap().remove(n2);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleDataSet)this.getThis();
    }

    public DoubleDataSet set(int n2, double[] dArray, double[] dArray2) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(n2 + dArray.length, this.xValues.size()));
            System.arraycopy(dArray, 0, this.xValues.elements(), n2, dArray.length);
            System.arraycopy(dArray2, 0, this.yValues.elements(), n2, dArray2.length);
            this.getDataLabelMap().remove(n2, n2 + dArray.length);
            this.getDataStyleMap().remove(n2, n2 + dArray.length);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleDataSet)this.getThis();
    }

    public DoubleDataSet trim() {
        this.lock().writeLockGuard(() -> {
            this.xValues.trim(0);
            this.yValues.trim(0);
        });
        this.fireInvalidated(ChartBits.DataSetData);
        return (DoubleDataSet)this.getThis();
    }
}

